/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class ReadOnlyCollectionTest<T> {
    @Test
    public final void prohibitsInjections() {
        this.testInterferenceResistence(shared -> {
            boolean bl = shared.add(this.single());
        });
        this.testInterferenceResistence(shared -> {
            boolean bl = shared.addAll(Collections.singleton(this.single()));
        });
    }

    @Test
    public final void prohibitsRemovals() {
        Assume.assumeTrue((this.collection().get().size() > 0 ? 1 : 0) != 0);
        this.testInterferenceResistence(Collection::clear);
        this.testInterferenceResistence(shared -> {
            boolean bl = shared.retainAll(Collections.emptyList());
        });
        this.testInterferenceResistence(shared -> {
            boolean bl = shared.removeAll((Collection<?>)shared);
        });
        this.testInterferenceResistence(shared -> {
            boolean bl = shared.remove(shared.iterator().next());
        });
    }

    private void testInterferenceResistence(Consumer<Collection<T>> interference) {
        Collection<T> shared = this.collection().get();
        int before = shared.size();
        try {
            interference.accept(shared);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        Assert.assertTrue((before == this.collection().get().size() ? 1 : 0) != 0);
    }

    protected abstract Supplier<Collection<T>> collection();

    protected abstract T single();
}

