/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.apache.lucene.internal.hppc.AbstractIterator;
import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

public class IntArrayList
implements Iterable<IntCursor>,
Cloneable,
Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayList.class);
    public static final int[] EMPTY_ARRAY = new int[0];
    public int[] buffer;
    public int elementsCount;

    public IntArrayList() {
        this(4);
    }

    public IntArrayList(int expectedElements) {
        this.buffer = new int[expectedElements];
    }

    public IntArrayList(IntArrayList list) {
        this(list.size());
        this.addAll(list);
    }

    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(int[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(int ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(IntArrayList list) {
        int size = list.size();
        this.ensureBufferSpace(size);
        for (IntCursor cursor : list) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends IntCursor> iterable) {
        int size = 0;
        for (IntCursor intCursor : iterable) {
            this.add(intCursor.value);
            ++size;
        }
        return size;
    }

    public void insert(int index, int e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [0, " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    public int get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        return this.buffer[index];
    }

    public int set(int index, int e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        int v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public int removeAt(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        int v = this.buffer[index];
        System.arraycopy(this.buffer, index + 1, this.buffer, index, --this.elementsCount - index);
        return v;
    }

    public int removeLast() {
        assert (!this.isEmpty()) : "List is empty";
        return this.buffer[--this.elementsCount];
    }

    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [0, " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [0, " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    public boolean removeElement(int e) {
        return this.removeFirst(e) != -1;
    }

    public int removeFirst(int e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public int removeLast(int e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public int removeAll(int e) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e == this.buffer[from]) continue;
            if (to != from) {
                this.buffer[to] = this.buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    public boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    public int indexOf(int e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.buffer.length) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    public int[] toArray() {
        return ArrayUtil.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    public IntArrayList clone() {
        try {
            IntArrayList cloned = (IntArrayList)super.clone();
            cloned.buffer = (int[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.buffer);
    }

    public IntStream stream() {
        return Arrays.stream(this.buffer, 0, this.size());
    }

    public IntArrayList sort() {
        Arrays.sort(this.buffer, 0, this.elementsCount);
        return this;
    }

    public IntArrayList reverse() {
        int i = 0;
        int mid = this.elementsCount >> 1;
        int j = this.elementsCount - 1;
        while (i < mid) {
            int tmp = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = tmp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    public static IntArrayList from(int ... elements) {
        IntArrayList list = new IntArrayList(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int[] buffer;
        private final int size;

        public ValueIterator(int[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected IntCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (IntCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

