/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Authenticator {
    private String ok;
    private String info;
    private String warning;
    private String error;

    public static Set<? extends Authenticator> create(VariableTask variable, final StringExpander stringExpander) {
        LinkedHashSet<Form> result = null;
        HashSet keys = null;
        if (variable.getType() == VariableType.PASSWORD) {
            for (Annotation annotation : variable.getAnnotations()) {
                String error;
                String warning;
                String info;
                String formFields;
                EMap details;
                if (!"http://www.eclipse.org/oomph/setup/PasswordVerification".equals(annotation.getSource()) || !"form".equals((details = annotation.getDetails()).get((Object)"type"))) continue;
                String cookie = (String)details.get((Object)"form.cookie");
                String url = (String)details.get((Object)"form.url");
                if (url == null || (formFields = (String)details.get((Object)"form.parameters")) == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<Form>();
                    keys = new HashSet();
                }
                final HashMap<String, String> map = new HashMap<String, String>();
                String variableValue = variable.getValue();
                map.put("value", variableValue);
                map.put("form.url", url);
                StringExpander localExpander = new StringExpander(){

                    protected String resolve(String key) {
                        return map.containsKey(key) ? (String)map.get(key) : 1.resolve((StringExpander)stringExpander, (String)key);
                    }

                    protected boolean isUnexpanded(String key) {
                        return !map.containsKey(key) && 1.isUnexpanded((StringExpander)stringExpander, (String)key);
                    }

                    protected String filter(String value, String filterName) {
                        return 1.filter((StringExpander)stringExpander, (String)value, (String)filterName);
                    }
                };
                String formSecurity = (String)details.get((Object)"form.secure.parameters");
                List secureKeys = formSecurity == null ? null : SegmentSequence.create((String)" ", (String)formSecurity).segmentsList();
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                String[] stringArray = SegmentSequence.create((String)" ", (String)formFields).segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String detailKey = "form.parameter." + key;
                    String unexpandedValue = (String)details.get((Object)detailKey);
                    String value = localExpander.expandString(unexpandedValue, keys);
                    if (value == null) {
                        value = secureKeys.contains(key) ? PreferencesUtil.encrypt((String)" ") : unexpandedValue;
                    }
                    map.put(detailKey, value);
                    parameters.put(key, value);
                    ++n2;
                }
                String formString = Form.getForm(parameters, secureKeys, true);
                String formFilter = (String)details.get((Object)"form.filter");
                boolean isFiltered = formFilter != null && formString.matches(formFilter);
                String ok = localExpander.expandString((String)details.get((Object)"form.ok"), keys);
                if (ok == null || (info = localExpander.expandString((String)details.get((Object)"form.info"), keys)) == null || (warning = localExpander.expandString((String)details.get((Object)"form.warning"), keys)) == null || (error = localExpander.expandString((String)details.get((Object)"form.error"), keys)) == null) continue;
                String verificationURL = localExpander.expandString((String)details.get((Object)"form.verification.url"));
                Pattern verificationPattern = null;
                String verificationMatches = localExpander.expandString((String)details.get((Object)"form.verification.matches"));
                if (verificationMatches != null) {
                    try {
                        verificationPattern = Pattern.compile(verificationMatches, 32);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                result.add(new Form(isFiltered, url, parameters, secureKeys, cookie, ok, info, warning, error, verificationURL, verificationPattern));
            }
        }
        return result;
    }

    protected Authenticator(String ok, String info, String warning, String error) {
        this.ok = ok;
        this.info = info;
        this.warning = warning;
        this.error = error;
    }

    public abstract boolean isFiltered();

    public abstract int validate();

    public String getMessage(int severity) {
        switch (severity) {
            case 0: {
                return this.ok;
            }
            case 1: {
                return this.info;
            }
            case 2: {
                return this.warning;
            }
            case 4: {
                return this.error;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Form
    extends Authenticator {
        private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([A-Za-z0-9-_]+)");
        private boolean isFiltered;
        private String uri;
        private String cookie;
        private Map<String, String> parameters;
        private Collection<String> secureKeys;
        private String verificationURI;
        private Pattern verificationPattern;

        public Form(boolean isFiltered, String uri, Map<String, String> parameters, Collection<String> secureKeys, String cookie, String ok, String info, String warning, String error) {
            super(ok, info, warning, error);
            this.isFiltered = isFiltered;
            this.uri = uri;
            this.parameters = parameters;
            this.secureKeys = secureKeys;
            this.cookie = cookie;
        }

        public Form(boolean isFiltered, String uri, Map<String, String> parameters, Collection<String> secureKeys, String cookie, String ok, String info, String warning, String error, String verificationURI, Pattern verificationPattern) {
            this(isFiltered, uri, parameters, secureKeys, cookie, ok, info, warning, error);
            this.verificationURI = verificationURI;
            this.verificationPattern = verificationPattern;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
            result = 31 * result + (this.isFiltered ? 1231 : 1237);
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.secureKeys == null ? 0 : this.secureKeys.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.verificationPattern == null ? 0 : this.verificationPattern.toString().hashCode());
            result = 31 * result + (this.verificationURI == null ? 0 : this.verificationURI.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Form other = (Form)obj;
            if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
                return false;
            }
            if (this.isFiltered != other.isFiltered) {
                return false;
            }
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            if (this.secureKeys == null ? other.secureKeys != null : !this.secureKeys.equals(other.secureKeys)) {
                return false;
            }
            if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
                return false;
            }
            if (this.verificationPattern == null ? other.verificationPattern != null : !this.verificationPattern.toString().equals(other.verificationPattern.toString())) {
                return false;
            }
            return !(this.verificationURI == null ? other.verificationURI != null : !this.verificationURI.equals(other.verificationURI));
        }

        @Override
        public boolean isFiltered() {
            return this.isFiltered;
        }

        @Override
        public int validate() {
            int status = 2;
            int i = 0;
            while (i < 3) {
                try {
                    status = this.sendPost() ? 0 : 4;
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            if (this.verificationURI != null && status == 0) {
                try {
                    status = this.verify() ? 0 : 4;
                }
                catch (Exception exception) {
                    status = 2;
                }
            }
            return status;
        }

        protected boolean sendPost() throws Exception {
            URL url = new URL(this.uri.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            this.handleProxy(connection);
            DataOutputStream data = new DataOutputStream(connection.getOutputStream());
            data.writeBytes(Form.getForm(this.parameters, this.secureKeys, true));
            data.close();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                if (this.cookie == null) {
                    return true;
                }
                Map<String, List<String>> headerFields = connection.getHeaderFields();
                List<String> list = headerFields.get("Set-Cookie");
                if (list != null) {
                    String prefix = String.valueOf(this.cookie) + "=";
                    for (String value : list) {
                        if (!value.startsWith(prefix)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        protected boolean verify() throws Exception {
            URL url = new URL(this.verificationURI.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            this.handleProxy(connection);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                InputStream inputStream = null;
                try {
                    Matcher matcher;
                    inputStream = connection.getInputStream();
                    String contentType = connection.getHeaderField("Content-Type");
                    if (contentType != null && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
                        String charset = matcher.group(1);
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        IOUtil.copy((InputStream)inputStream, (OutputStream)bytes);
                        String content = new String(bytes.toByteArray(), charset);
                        boolean bl = this.verificationPattern.matcher(content).matches();
                        return bl;
                    }
                }
                finally {
                    IOUtil.close((Closeable)inputStream);
                }
            }
            return false;
        }

        protected static String getForm(Map<String, String> parameters, Collection<String> secureKeys, boolean secure) {
            StringBuilder form = new StringBuilder();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (secure && secureKeys != null && secureKeys.contains(key)) {
                    value = PreferencesUtil.decrypt((String)value);
                }
                if (form.length() != 0) {
                    form.append('&');
                }
                form.append(key);
                form.append('=');
                try {
                    form.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            return form.toString();
        }

        public String toString() {
            return Form.getForm(this.parameters, this.secureKeys, false);
        }

        private void handleProxy(HttpURLConnection connection) {
            try {
                ECFURIHandlerImpl.AuthorizationHandler.Authorization authorization;
                Proxy proxy = ProxySetupHelper.getProxy((String)this.uri);
                if (proxy != null && (authorization = new ECFURIHandlerImpl.AuthorizationHandler.Authorization(proxy.getUsername(), proxy.getPassword())).isAuthorized()) {
                    connection.setRequestProperty("Proxy-Authorization", authorization.getAuthorization());
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }
}

