/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.units;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.IllegalIcuArgumentException;
import com.ibm.icu.impl.UResource;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnitAliases {
    private final Map<String, String> mapAliasToReplacement;

    public UnitAliases() {
        ICUResourceBundle metadataResource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudata", "metadata");
        AllAliasSink aliasSink = new AllAliasSink();
        metadataResource.getAllChildrenWithFallback("alias/unit", aliasSink);
        this.mapAliasToReplacement = aliasSink.getAliasMap();
    }

    public List<Alias> getAliases() {
        ArrayList<Alias> aliasList = new ArrayList<Alias>(this.mapAliasToReplacement.size());
        for (Map.Entry<String, String> entry : this.mapAliasToReplacement.entrySet()) {
            aliasList.add(new Alias(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableList(aliasList);
    }

    public String getReplacement(String alias) {
        return this.mapAliasToReplacement.get(alias);
    }

    private static final class AllAliasSink
    extends UResource.Sink {
        private final Map<String, String> mapAliasToReplacement = new HashMap<String, String>();

        private AllAliasSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            String alias = key.toString();
            UResource.Table aliasEntryTable = value.getTable();
            if (!aliasEntryTable.findValue("replacement", value)) {
                throw new IllegalIcuArgumentException("No replacement found for alias: " + alias);
            }
            String replacement = value.toString();
            this.mapAliasToReplacement.put(alias, replacement);
        }

        public Map<String, String> getAliasMap() {
            return Collections.unmodifiableMap(this.mapAliasToReplacement);
        }
    }

    public static class Alias {
        public final String alias;
        public final String replacement;

        public Alias(String alias, String replacement) {
            this.alias = alias;
            this.replacement = replacement;
        }
    }
}

