/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.PlainMessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.util.Descriptors;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectivesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private PerspectiveRegistry perspectiveRegistry;
    private ArrayList<IPerspectiveDescriptor> perspectives;
    private String defaultPerspectiveId;
    private ArrayList<IPerspectiveDescriptor> perspToDelete = new ArrayList();
    private ArrayList<IPerspectiveDescriptor> perspToRevert = new ArrayList();
    private Table perspectivesTable;
    private Button revertButton;
    private Button deleteButton;
    private Button setDefaultButton;
    private Button openSameWindowButton;
    private Button openNewWindowButton;
    private int openPerspMode;
    private final String OPM_TITLE = WorkbenchMessages.OpenPerspectiveMode_optionsTitle;
    private final String OPM_SAME_WINDOW = WorkbenchMessages.OpenPerspectiveMode_sameWindow;
    private final String OPM_NEW_WINDOW = WorkbenchMessages.OpenPerspectiveMode_newWindow;
    private Comparator<IPerspectiveDescriptor> comparator = new Comparator<IPerspectiveDescriptor>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(IPerspectiveDescriptor d1, IPerspectiveDescriptor d2) {
            return this.collator.compare(d1.getLabel(), d2.getLabel());
        }
    };

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.perspectives_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createOpenPerspButtonGroup(composite);
        this.createCustomizePerspective(composite);
        return composite;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void createOpenPerspButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = new Group(composite, 16384);
        buttonComposite.setText(this.OPM_TITLE);
        buttonComposite.setLayoutData((Object)new GridData(768));
        buttonComposite.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        this.openSameWindowButton = new Button((Composite)buttonComposite, 16);
        this.openSameWindowButton.setText(this.OPM_SAME_WINDOW);
        this.openSameWindowButton.setSelection(this.openPerspMode == 0);
        this.openSameWindowButton.setFont(font);
        this.openSameWindowButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int n = this.openPerspMode = 0;
        }));
        this.openNewWindowButton = new Button((Composite)buttonComposite, 16);
        this.openNewWindowButton.setText(this.OPM_NEW_WINDOW);
        this.openNewWindowButton.setSelection(2 == this.openPerspMode);
        this.openNewWindowButton.setFont(font);
        this.openNewWindowButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int n = this.openPerspMode = 2;
        }));
    }

    protected Composite createCustomizePerspective(Composite parent) {
        Font font = parent.getFont();
        Composite perspectivesComponent = new Composite(parent, 0);
        perspectivesComponent.setLayoutData((Object)new GridData(1808));
        perspectivesComponent.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        perspectivesComponent.setLayout((Layout)layout);
        Label label = new Label(perspectivesComponent, 16384);
        label.setText(WorkbenchMessages.PerspectivesPreference_available);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.perspectivesTable = new Table(perspectivesComponent, 2816);
        this.perspectivesTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateButtons()));
        this.perspectivesTable.setFont(font);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.perspectivesTable.setLayoutData((Object)data);
        IPerspectiveDescriptor[] persps = this.perspectiveRegistry.getPerspectives();
        this.perspectives = new ArrayList(persps.length);
        int i = 0;
        while (i < persps.length) {
            this.perspectives.add(i, persps[i]);
            ++i;
        }
        this.perspectives.sort(this.comparator);
        this.defaultPerspectiveId = this.perspectiveRegistry.getDefaultPerspective();
        this.updatePerspectivesTable();
        Composite buttonBar = (Composite)this.createVerticalButtonBar(perspectivesComponent);
        data = new GridData(1040);
        buttonBar.setLayoutData((Object)data);
        String NOTE_LABEL = WorkbenchMessages.Preference_note;
        String REVERT_NOTE = WorkbenchMessages.RevertPerspective_note;
        Composite noteComposite = this.createNoteComposite(font, parent, NOTE_LABEL, REVERT_NOTE);
        GridData noteData = new GridData();
        noteData.horizontalSpan = 2;
        noteComposite.setLayoutData((Object)noteData);
        return perspectivesComponent;
    }

    protected Button createVerticalButton(Composite parent, String label, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = this.setButtonLayoutData(button);
        data.horizontalAlignment = 4;
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.verticalButtonPressed(event.widget)));
        button.setToolTipText(label);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        button.setFont(parent.getFont());
        return button;
    }

    protected Control createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.setDefaultButton = this.createVerticalButton(composite, WorkbenchMessages.PerspectivesPreference_MakeDefault, false);
        this.setDefaultButton.setToolTipText(WorkbenchMessages.PerspectivesPreference_MakeDefaultTip);
        this.revertButton = this.createVerticalButton(composite, WorkbenchMessages.PerspectivesPreference_Reset, false);
        this.revertButton.setToolTipText(WorkbenchMessages.PerspectivesPreference_ResetTip);
        this.deleteButton = this.createVerticalButton(composite, WorkbenchMessages.PerspectivesPreference_Delete, false);
        this.deleteButton.setToolTipText(WorkbenchMessages.PerspectivesPreference_DeleteTip);
        this.updateButtons();
        return composite;
    }

    @Override
    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
        this.perspectiveRegistry = (PerspectiveRegistry)this.workbench.getPerspectiveRegistry();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.openPerspMode = store.getInt("OPEN_PERSPECTIVE_MODE");
    }

    protected void performDefaults() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.openPerspMode = store.getDefaultInt("OPEN_PERSPECTIVE_MODE");
        this.openSameWindowButton.setSelection(this.openPerspMode == 0);
        this.openNewWindowButton.setSelection(2 == this.openPerspMode);
        String currentDefault = this.perspectiveRegistry.getDefaultPerspective();
        int index = this.indexOf(currentDefault);
        if (index >= 0) {
            this.defaultPerspectiveId = currentDefault;
            this.updatePerspectivesTable();
            this.perspectivesTable.setSelection(index);
        }
        String newDefault = PrefUtil.getAPIPreferenceStore().getDefaultString("defaultPerspectiveId");
        IPerspectiveDescriptor desc = null;
        if (newDefault != null) {
            desc = this.workbench.getPerspectiveRegistry().findPerspectiveWithId(newDefault);
        }
        if (desc == null) {
            newDefault = this.workbench.getPerspectiveRegistry().getDefaultPerspective();
        }
        this.defaultPerspectiveId = newDefault;
        this.updatePerspectivesTable();
    }

    private int indexOf(String perspectiveId) {
        if (perspectiveId == null) {
            return -1;
        }
        PerspectiveDescriptor[] descriptors = new PerspectiveDescriptor[this.perspectives.size()];
        this.perspectives.toArray(descriptors);
        int i = 0;
        while (i < descriptors.length) {
            PerspectiveDescriptor descriptor = descriptors[i];
            if (descriptor.getId().equals(perspectiveId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean canDeletePerspective(IPerspectiveDescriptor desc) {
        MApplication application = ((Workbench)this.workbench).getApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        if (modelService.findElements((MUIElement)application, desc.getId(), MPerspective.class).isEmpty()) {
            return true;
        }
        PlainMessageDialog.Builder builder = PlainMessageDialog.getBuilder((Shell)this.getShell(), (String)WorkbenchMessages.PerspectivesPreference_perspectiveopen_title);
        builder.message(NLS.bind((String)WorkbenchMessages.PerspectivesPreference_perspectiveopen_message, (Object)desc.getLabel()));
        builder.image(this.getShell().getDisplay().getSystemImage(4));
        builder.buttonLabels(Arrays.asList(IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL));
        return builder.build().open() == 0;
    }

    public boolean performOk() {
        if (!Objects.equals(this.defaultPerspectiveId, this.perspectiveRegistry.getDefaultPerspective())) {
            this.perspectiveRegistry.setDefaultPerspective(this.defaultPerspectiveId);
        }
        for (IPerspectiveDescriptor perspective : this.perspToDelete) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = this.workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    page.closePerspective(perspective, true, false);
                    ++n4;
                }
                ++n2;
            }
            this.perspectiveRegistry.deletePerspectives(this.perspToDelete);
        }
        for (IPerspectiveDescriptor perspective : this.perspToRevert) {
            this.perspectiveRegistry.revertPerspective(perspective);
        }
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("OPEN_PERSPECTIVE_MODE", this.openPerspMode);
        PrefUtil.savePrefs();
        return true;
    }

    protected void updateButtons() {
        int index = this.perspectivesTable.getSelectionIndex();
        PerspectiveDescriptor desc = null;
        if (index > -1) {
            desc = (PerspectiveDescriptor)this.perspectives.get(index);
        }
        if (desc != null) {
            this.revertButton.setEnabled(desc.isPredefined() && desc.hasCustomDefinition() && !this.perspToRevert.contains(desc));
            this.deleteButton.setEnabled(!desc.isPredefined());
            this.setDefaultButton.setEnabled(true);
        } else {
            this.revertButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        }
    }

    protected void updatePerspectivesTable() {
        this.perspectivesTable.removeAll();
        int i = 0;
        while (i < this.perspectives.size()) {
            PerspectiveDescriptor persp = (PerspectiveDescriptor)this.perspectives.get(i);
            this.newPerspectivesTableItem(persp, i, false);
            ++i;
        }
    }

    protected TableItem newPerspectivesTableItem(IPerspectiveDescriptor persp, int index, boolean selected) {
        ImageDescriptor image = persp.getImageDescriptor();
        TableItem item = new TableItem(this.perspectivesTable, 0, index);
        if (image != null) {
            Descriptors.setImage((Item)item, image);
        }
        String label = persp.getLabel();
        if (persp.getId().equals(this.defaultPerspectiveId)) {
            label = NLS.bind((String)WorkbenchMessages.PerspectivesPreference_defaultLabel, (Object)label);
        }
        item.setText(label);
        item.setData((Object)persp);
        if (selected) {
            this.perspectivesTable.setSelection(index);
        }
        return item;
    }

    protected void verticalButtonPressed(Widget button) {
        int index = this.perspectivesTable.getSelectionIndex();
        PerspectiveDescriptor desc = null;
        if (index <= -1) {
            return;
        }
        desc = (PerspectiveDescriptor)this.perspectives.get(index);
        if (button == this.revertButton) {
            if (!this.perspToRevert.contains(desc)) {
                this.perspToRevert.add(desc);
            }
        } else if (button == this.deleteButton) {
            if (!this.perspToDelete.contains(desc) && this.canDeletePerspective(desc)) {
                this.perspToDelete.add(desc);
                this.perspToRevert.remove(desc);
                this.perspectives.remove(desc);
                this.updatePerspectivesTable();
            }
        } else if (button == this.setDefaultButton) {
            this.defaultPerspectiveId = desc.getId();
            this.updatePerspectivesTable();
            this.perspectivesTable.setSelection(index);
        }
        this.updateButtons();
    }
}

