/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.Messages;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PreferenceInitializationDialog
extends AbstractSetupDialog {
    private static final String TITLE = Messages.PreferenceInitializationDialog_title;
    private final PreferenceManager preferenceManager;
    private CheckboxTreeViewer checkboxTreeViewer;
    private PreferenceDialog preferenceDialog;
    private FilteredTree filteredTree;

    public PreferenceInitializationDialog(PreferenceDialog preferenceDialog, PreferenceManager preferenceManager) {
        super(preferenceDialog.getShell(), Messages.PreferenceInitializationDialog_dialogTitle, 500, 600, SetupUIPlugin.INSTANCE, true);
        this.preferenceDialog = preferenceDialog;
        this.preferenceManager = preferenceManager;
    }

    protected String getDefaultMessage() {
        return Messages.PreferenceInitializationDialog_defaultMessage;
    }

    public String getHelpPath() {
        return String.valueOf(SetupUIPlugin.INSTANCE.getSymbolicName()) + "/html/PreferenceInitializationHelp.html";
    }

    protected void createUI(Composite parent) {
        final Object root = new Object();
        final Set<String> initializedPreferencePages = RecorderManager.INSTANCE.getInitializedPreferencePages();
        this.checkboxTreeViewer = new ContainerCheckedTreeViewer(parent, 2);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return true;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{root};
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList<IPreferenceNode> nodes = new ArrayList<IPreferenceNode>();
                if (parentElement == root) {
                    nodes.addAll(Arrays.asList(PreferenceInitializationDialog.this.preferenceManager.getRootSubNodes()));
                } else {
                    IPreferenceNode preferenceNode = (IPreferenceNode)parentElement;
                    nodes.addAll(Arrays.asList(preferenceNode.getSubNodes()));
                }
                return this.filter(nodes);
            }

            private Object[] filter(List<IPreferenceNode> nodes) {
                Iterator<IPreferenceNode> it = nodes.iterator();
                while (it.hasNext()) {
                    IPreferenceNode preferenceNode = it.next();
                    if (!initializedPreferencePages.contains(preferenceNode.getId()) || this.getChildren(preferenceNode).length != 0) continue;
                    it.remove();
                }
                return nodes.toArray();
            }
        });
        this.checkboxTreeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ') {
                    Object object;
                    IStructuredSelection selection = (IStructuredSelection)PreferenceInitializationDialog.this.checkboxTreeViewer.getSelection();
                    boolean check = true;
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = objectArray[n2];
                        if (PreferenceInitializationDialog.this.checkboxTreeViewer.getChecked(object) || PreferenceInitializationDialog.this.checkboxTreeViewer.getGrayed(object)) {
                            check = false;
                            break;
                        }
                        ++n2;
                    }
                    objectArray = selection.toArray();
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        object = objectArray[n2];
                        PreferenceInitializationDialog.this.checkboxTreeViewer.setChecked(object, check);
                        ++n2;
                    }
                    e.doit = false;
                }
            }
        });
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == root) {
                    return Messages.PreferenceInitializationDialog_checkBoxTree_rootLabel;
                }
                IPreferenceNode preferenceNode = (IPreferenceNode)element;
                return preferenceNode.getLabelText();
            }
        });
        this.filteredTree = (FilteredTree)ReflectUtil.getValue((String)"filteredTree", (Object)this.preferenceDialog);
        TreeViewer viewer = this.filteredTree.getViewer();
        this.checkboxTreeViewer.setComparator(viewer.getComparator());
        this.checkboxTreeViewer.setInput((Object)this.preferenceManager);
        this.checkboxTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.checkboxTreeViewer.expandAll();
        this.checkboxTreeViewer.setSubtreeChecked(root, true);
        Set<String> ignoredPreferencePages = RecorderManager.INSTANCE.getIgnoredPreferencePages();
        List preferenceNodes = this.preferenceManager.getElements(0);
        for (IPreferenceNode preferenceNode : preferenceNodes) {
            if (!ignoredPreferencePages.contains(preferenceNode.getId())) continue;
            this.checkboxTreeViewer.setChecked((Object)preferenceNode, false);
        }
        PreferenceInitializationDialog.showFirstTimeHelp((TrayDialog)this);
    }

    protected String getShellText() {
        return TITLE;
    }

    protected void okPressed() {
        Set<String> initializedOrCheckedPreferencePages = RecorderManager.INSTANCE.getInitializedPreferencePages();
        LinkedHashSet<String> checkedPreferencePages = new LinkedHashSet<String>();
        Object[] checkedElements = this.checkboxTreeViewer.getCheckedElements();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IPreferenceNode) {
                IPreferenceNode preferenceNode = (IPreferenceNode)object;
                String id = preferenceNode.getId();
                initializedOrCheckedPreferencePages.add(id);
                checkedPreferencePages.add(id);
            }
            ++n2;
        }
        LinkedHashSet<String> ignoredPreferencePages = new LinkedHashSet<String>();
        List preferenceNodes = this.preferenceManager.getElements(0);
        for (IPreferenceNode preferenceNode : preferenceNodes) {
            String id = preferenceNode.getId();
            if (initializedOrCheckedPreferencePages.contains(id)) continue;
            ignoredPreferencePages.add(id);
        }
        RecorderManager.INSTANCE.setIgnoredPreferencePages(ignoredPreferencePages);
        super.okPressed();
        if (checkedElements.length == 0) {
            RecorderManager.INSTANCE.disposeInitializeItem();
        } else {
            new Initializer(this.preferenceDialog, checkedPreferencePages, ignoredPreferencePages).run();
        }
    }

    private static class Initializer
    implements Runnable {
        private final String originalID;
        private PreferenceDialog preferenceDialog;
        private FilteredTree filteredTree;
        private TreeViewer viewer;
        final Set<String> initializedPreferencePages = RecorderManager.INSTANCE.getInitializedPreferencePages();
        final Map<String, IPreferenceNode> nodes = new LinkedHashMap<String, IPreferenceNode>();
        final Set<IPreferenceNode> visitedNodes = new HashSet<IPreferenceNode>();

        public Initializer(PreferenceDialog preferenceDialog, Set<String> checkedPreferencePages, Set<String> ignoredPreferencePages) {
            this.setPreferenceDialog(preferenceDialog);
            this.filteredTree.getFilterControl().setText("");
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            IPreferenceNode selectedNode = (IPreferenceNode)selection.getFirstElement();
            this.originalID = selectedNode == null ? null : selectedNode.getId();
            Tree tree = this.viewer.getTree();
            this.viewer.expandAll();
            TreeItem[] treeItemArray = tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem object = treeItemArray[n2];
                this.visit(this.nodes, object);
                ++n2;
            }
            Iterator<IPreferenceNode> it = this.nodes.values().iterator();
            while (it.hasNext()) {
                IPreferenceNode preferenceNode = it.next();
                String id = preferenceNode.getId();
                checkedPreferencePages.remove(id);
                if (!ignoredPreferencePages.contains(id) && !this.initializedPreferencePages.contains(id)) continue;
                it.remove();
            }
            this.initializedPreferencePages.addAll(checkedPreferencePages);
        }

        private void setPreferenceDialog(PreferenceDialog preferenceDialog) {
            this.preferenceDialog = preferenceDialog;
            this.filteredTree = (FilteredTree)ReflectUtil.getValue((String)"filteredTree", (Object)preferenceDialog);
            this.viewer = this.filteredTree.getViewer();
        }

        protected void visit(Map<String, IPreferenceNode> nodes, TreeItem treeItem) {
            Object data = treeItem.getData();
            if (data instanceof IPreferenceNode) {
                IPreferenceNode preferenceNode = (IPreferenceNode)data;
                StringBuilder description = new StringBuilder();
                TreeItem item = treeItem;
                while (item != null) {
                    if (description.length() != 0) {
                        description.insert(0, " -> ");
                    }
                    description.insert(0, item.getText());
                    item = item.getParentItem();
                }
                nodes.put(description.toString(), preferenceNode);
            }
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                this.visit(nodes, child);
                ++n2;
            }
        }

        @Override
        public void run() {
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.preferenceDialog.getShell()){

                    protected void configureShell(Shell shell) {
                        super.configureShell(shell);
                        shell.setText(TITLE);
                    }
                };
                progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        boolean cancel = false;
                        final AtomicBoolean abort = new AtomicBoolean(false);
                        final HashSet badPages = new HashSet();
                        try {
                            monitor.beginTask(Messages.PreferenceInitializationDialog_visitingPreferencePagesTask_name, nodes.size());
                            LinkedHashMap<String, IPreferenceNode> remainingNodes = new LinkedHashMap<String, IPreferenceNode>(nodes);
                            remainingNodes.values().removeAll(visitedNodes);
                            monitor.worked(visitedNodes.size());
                            int count = 0;
                            for (final Map.Entry entry : remainingNodes.entrySet()) {
                                if (monitor.isCanceled()) {
                                    cancel = true;
                                    break;
                                }
                                if (++count > 100) {
                                    monitor.setCanceled(true);
                                    abort.set(true);
                                    continue;
                                }
                                visitedNodes.add((IPreferenceNode)entry.getValue());
                                UIUtil.syncExec((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        monitor.subTask((String)entry.getKey());
                                        IPreferenceNode preferenceNode = (IPreferenceNode)entry.getValue();
                                        String id = preferenceNode.getId();
                                        try {
                                            viewer.setSelection((ISelection)new StructuredSelection((Object)preferenceNode));
                                        }
                                        catch (Throwable throwable) {
                                            SetupUIPlugin.INSTANCE.log(throwable, 2);
                                        }
                                        IPreferencePage currentPage = (IPreferencePage)ReflectUtil.invokeMethod((String)"getCurrentPage", (Object)preferenceDialog);
                                        if (currentPage != null && !currentPage.okToLeave()) {
                                            Bundle bundle = FrameworkUtil.getBundle(currentPage.getClass());
                                            SetupUIPlugin.INSTANCE.log((IStatus)new Status(2, bundle == null ? SetupUIPlugin.PLUGIN_ID : bundle.getSymbolicName(), NLS.bind((String)Messages.PreferenceInitializationDialog_preferenceInvalidState_message, entry.getKey())));
                                            badPages.add(preferenceNode);
                                            monitor.setCanceled(true);
                                            abort.set(true);
                                        }
                                        initializedPreferencePages.add(id);
                                    }
                                });
                                monitor.worked(1);
                            }
                            monitor.done();
                        }
                        catch (Throwable throwable) {
                            RecorderManager.INSTANCE.setInitializedPreferencePages(initializedPreferencePages);
                            UIUtil.asyncExec((Runnable)new Runnable(this, badPages, abort){
                                final /* synthetic */ 2 this$2;
                                private final /* synthetic */ Set val$badPages;
                                private final /* synthetic */ AtomicBoolean val$abort;
                                {
                                    this.this$2 = var1_1;
                                    this.val$badPages = set;
                                    this.val$abort = atomicBoolean;
                                }

                                @Override
                                public void run() {
                                    RecorderManager.INSTANCE.cancelRecording();
                                    final Shell shell = preferenceDialog.getShell();
                                    final List<Shell> children = Arrays.asList(shell.getShells());
                                    Runnable runnable = new Runnable(){

                                        @Override
                                        public void run() {
                                            Shell[] shells;
                                            Shell[] shellArray = shells = shell.getShells();
                                            int n = shells.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                Shell child = shellArray[n2];
                                                if (!children.contains(child) && shell.isVisible()) {
                                                    child.dispose();
                                                }
                                                ++n2;
                                            }
                                            UIUtil.asyncExec((Control)shell, (Runnable)this);
                                        }
                                    };
                                    UIUtil.asyncExec((Control)shell, (Runnable)runnable);
                                    HashSet<IPreferencePage> pages = new HashSet<IPreferencePage>();
                                    for (IPreferenceNode node : this.val$badPages) {
                                        IPreferencePage page = node.getPage();
                                        pages.add(page);
                                        ReflectUtil.setValue((String)"page", (Object)node, null);
                                    }
                                    ReflectUtil.invokeMethod((String)"okPressed", (Object)preferenceDialog);
                                    RecorderTransaction transaction = RecorderTransaction.getInstance();
                                    if (transaction != null) {
                                        transaction.close();
                                    }
                                    UIUtil.asyncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)originalID, null, null);
                                            if (val$abort.get()) {
                                                this$2.this.setPreferenceDialog(dialog);
                                                UIUtil.asyncExec((Runnable)this$2.this);
                                            }
                                            dialog.open();
                                        }
                                    });
                                }
                            });
                            if (cancel) {
                                throw new InterruptedException();
                            }
                            throw throwable;
                        }
                        RecorderManager.INSTANCE.setInitializedPreferencePages(initializedPreferencePages);
                        UIUtil.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                        if (cancel) {
                            throw new InterruptedException();
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

