/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.ser;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ser.ObjectSerializer;
import java.util.HashMap;
import java.util.Map;

public class ObjectMapSerializer<K, V>
extends JsonSerializer<Map<K, V>>
implements ResultDeserializer<Map<K, V>> {
    private final JsonSerializer<K> keySerializer;
    private final JsonSerializer<V> valueSerializer;

    public ObjectMapSerializer(JsonSerializer<K> k, JsonSerializer<V> v) {
        this.keySerializer = k;
        this.valueSerializer = v;
    }

    @Override
    public void printJson(StringBuilder sb, Map<K, V> o) {
        sb.append('[');
        boolean first = true;
        for (Map.Entry<K, V> e : o.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            ObjectMapSerializer.encode(sb, this.keySerializer, e.getKey());
            sb.append(',');
            ObjectMapSerializer.encode(sb, this.valueSerializer, e.getValue());
        }
        sb.append(']');
    }

    private static <T> void encode(StringBuilder sb, JsonSerializer<T> serializer, T item) {
        if (item != null) {
            serializer.printJson(sb, item);
        } else {
            sb.append("null");
        }
    }

    @Override
    public Map<K, V> fromJson(Object o) {
        if (o == null) {
            return null;
        }
        JavaScriptObject jso = (JavaScriptObject)o;
        int n = ObjectMapSerializer.size(jso);
        HashMap<K, V> r = new HashMap<K, V>();
        int i = 0;
        while (i < n) {
            K k = this.keySerializer.fromJson(ObjectMapSerializer.get(jso, i++));
            V v = this.valueSerializer.fromJson(ObjectMapSerializer.get(jso, i++));
            r.put(k, v);
        }
        return r;
    }

    @Override
    public Map<K, V> fromResult(JavaScriptObject response) {
        JavaScriptObject result = ObjectSerializer.objectResult(response);
        return result == null ? null : this.fromJson(result);
    }

    private static final native int size(JavaScriptObject var0);

    private static final native Object get(JavaScriptObject var0, int var1);
}

