/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSelectionModel<T>
extends SelectionModel.AbstractSelectionModel<T> {
    private final HashMap<Object, T> selectedSet = new HashMap();
    private final HashMap<T, Boolean> selectionChanges = new HashMap();

    public MultiSelectionModel() {
        super(null);
    }

    public MultiSelectionModel(ProvidesKey<T> keyProvider) {
        super(keyProvider);
    }

    public Set<T> getSelectedSet() {
        this.resolveChanges();
        return new HashSet<T>(this.selectedSet.values());
    }

    @Override
    public boolean isSelected(T object) {
        this.resolveChanges();
        return this.selectedSet.containsKey(this.getKey(object));
    }

    @Override
    public void setSelected(T object, boolean selected) {
        this.selectionChanges.put(object, selected);
        this.scheduleSelectionChangeEvent();
    }

    @Override
    protected void fireSelectionChangeEvent() {
        if (this.isEventScheduled()) {
            this.setEventCancelled(true);
        }
        this.resolveChanges();
    }

    private void resolveChanges() {
        if (this.selectionChanges.isEmpty()) {
            return;
        }
        boolean changed = false;
        for (Map.Entry<T, Boolean> entry : this.selectionChanges.entrySet()) {
            T object = entry.getKey();
            boolean selected = entry.getValue();
            Object key = this.getKey(object);
            T oldValue = this.selectedSet.get(key);
            if (selected) {
                if (oldValue != null && oldValue.equals(object)) continue;
                this.selectedSet.put(this.getKey(object), object);
                changed = true;
                continue;
            }
            if (oldValue == null) continue;
            this.selectedSet.remove(key);
            changed = true;
        }
        this.selectionChanges.clear();
        if (changed) {
            SelectionChangeEvent.fire(this);
        }
    }
}

