/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

public class GitlabTaskAttributeMapper
extends TaskAttributeMapper {
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd[' ']['T'][H:mm[:ss[.SSS]['Z']]]");

    public GitlabTaskAttributeMapper(TaskRepository taskRepository) {
        super(taskRepository);
    }

    public Date getDateValue(TaskAttribute attribute) {
        if (attribute == null || attribute.getValue().isBlank()) {
            return null;
        }
        Date parsedDate = GitlabTaskAttributeMapper.parseDate(attribute.getValue());
        if (parsedDate != null) {
            return parsedDate;
        }
        return super.getDateValue(attribute);
    }

    public static final Date parseDate(String dateString) {
        if (dateString.matches("[0-9]+")) {
            return new Date(Long.parseLong(dateString));
        }
        return Date.from(LocalDateTime.parse(dateString, formatter).atZone(ZoneId.systemDefault()).toInstant());
    }

    public void setRepositoryPerson(@NonNull TaskAttribute taskAttribute, @NonNull IRepositoryPerson person) {
        super.setRepositoryPerson(taskAttribute, person);
        if (person.getAttributes().size() > 0) {
            for (Map.Entry entry : person.getAttributes().entrySet()) {
                TaskAttribute taskAttrib = taskAttribute.getAttribute((String)entry.getKey());
                if (taskAttrib == null) {
                    taskAttrib = taskAttribute.createAttribute((String)entry.getKey());
                }
                taskAttrib.setValue((String)entry.getValue());
            }
        }
    }
}

