/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.operations.FeatureDescriptor;
import org.eclipse.epp.internal.mpc.ui.wizards.InstallProfile;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionModel {
    private final Map<CatalogItem, org.eclipse.epp.mpc.ui.Operation> itemToOperation = new HashMap<CatalogItem, org.eclipse.epp.mpc.ui.Operation>();
    private List<CatalogItemEntry> entries;
    private final InstallProfile installProfile;

    public SelectionModel(InstallProfile installProfile) {
        this.installProfile = installProfile;
    }

    @Deprecated
    public void select(CatalogItem item, Operation operation) {
        this.select(item, operation == null ? null : operation.getOperation());
    }

    public void select(CatalogItem item, org.eclipse.epp.mpc.ui.Operation operation) {
        boolean changed = false;
        if (operation == null || org.eclipse.epp.mpc.ui.Operation.NONE == operation) {
            if (this.itemToOperation.remove(item) != org.eclipse.epp.mpc.ui.Operation.NONE) {
                changed = true;
            }
            if (this.entries != null) {
                Iterator<CatalogItemEntry> it = this.entries.iterator();
                while (it.hasNext()) {
                    CatalogItemEntry entry = it.next();
                    if (!entry.getItem().equals(item)) continue;
                    it.remove();
                }
            }
        } else {
            org.eclipse.epp.mpc.ui.Operation previous = this.itemToOperation.put(item, operation);
            if (previous != operation) {
                changed = true;
                if (this.entries != null) {
                    Iterator<CatalogItemEntry> it = this.entries.iterator();
                    while (it.hasNext()) {
                        CatalogItemEntry entry = it.next();
                        if (!entry.getItem().equals(item)) continue;
                        it.remove();
                    }
                    CatalogItemEntry itemEntry = this.createItemEntry(item, operation);
                    this.entries.add(itemEntry);
                }
            }
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    public List<CatalogItemEntry> getCatalogItemEntries() {
        if (this.entries == null) {
            ArrayList<CatalogItemEntry> entries = new ArrayList<CatalogItemEntry>();
            for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : this.itemToOperation.entrySet()) {
                CatalogItem item = entry.getKey();
                org.eclipse.epp.mpc.ui.Operation operation = entry.getValue();
                CatalogItemEntry itemEntry = this.createItemEntry(item, operation);
                entries.add(itemEntry);
            }
            this.entries = entries;
        }
        return this.entries;
    }

    @Deprecated
    public CatalogItemEntry createItemEntry(CatalogItem item, Operation operation) {
        return this.createItemEntry(item, operation == null ? null : operation.getOperation());
    }

    public CatalogItemEntry createItemEntry(CatalogItem item, org.eclipse.epp.mpc.ui.Operation operation) {
        CatalogItemEntry itemEntry = new CatalogItemEntry(item, operation);
        this.computeChildren(itemEntry);
        return itemEntry;
    }

    private void computeChildren(CatalogItemEntry itemEntry) {
        ArrayList<FeatureEntry> children = new ArrayList<FeatureEntry>();
        List<MarketplaceNodeInstallableUnitItem> iuItems = ((MarketplaceNodeCatalogItem)itemEntry.getItem()).getInstallableUnitItems();
        if (iuItems != null) {
            for (MarketplaceNodeInstallableUnitItem iuItem : iuItems) {
                FeatureEntry featureEntry = new FeatureEntry(itemEntry, iuItem);
                featureEntry.setInstalled(this.computeInstalled(featureEntry));
                featureEntry.setChecked(this.computeInitiallyChecked(featureEntry));
                children.add(featureEntry);
            }
        }
        itemEntry.children = children;
    }

    private Boolean computeInitiallyChecked(FeatureEntry featureEntry) {
        CatalogItemEntry parent = featureEntry.getParent();
        org.eclipse.epp.mpc.ui.Operation selectedOperation = parent.getSelectedOperation();
        switch (selectedOperation) {
            case INSTALL: {
                if (!featureEntry.isInstalled()) {
                    if (!featureEntry.isRequiredInstall() && !featureEntry.getInstallableUnitItem().isDefaultSelected()) {
                        return false;
                    }
                    return true;
                }
                return featureEntry.hasUpdateAvailable();
            }
            case UNINSTALL: {
                return featureEntry.isInstalled();
            }
            case UPDATE: {
                if (!featureEntry.hasUpdateAvailable() && !featureEntry.isRequiredInstall()) {
                    return false;
                }
                return true;
            }
            case CHANGE: {
                return featureEntry.isInstalled();
            }
        }
        return false;
    }

    private boolean computeInstalled(FeatureEntry entry) {
        Set<String> installedFeatures = this.installProfile.getInstalledFeatures();
        return installedFeatures.contains(entry.featureDescriptor.getId()) || installedFeatures.contains(entry.featureDescriptor.getSimpleId());
    }

    @Deprecated
    public Map<CatalogItem, Operation> getItemToOperation() {
        HashMap<CatalogItem, Operation> itemToOperation = new HashMap<CatalogItem, Operation>();
        Set<Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation>> entrySet = this.itemToOperation.entrySet();
        for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : entrySet) {
            itemToOperation.put(entry.getKey(), Operation.map(entry.getValue()));
        }
        return itemToOperation;
    }

    public Map<CatalogItem, org.eclipse.epp.mpc.ui.Operation> getItemToSelectedOperation() {
        return Collections.unmodifiableMap(this.itemToOperation);
    }

    public void selectionChanged() {
    }

    public Map<FeatureEntry, org.eclipse.epp.mpc.ui.Operation> getFeatureEntryToOperation(boolean includeNone, boolean verify) {
        HashMap<FeatureEntry, org.eclipse.epp.mpc.ui.Operation> featureEntries = new HashMap<FeatureEntry, org.eclipse.epp.mpc.ui.Operation>();
        for (CatalogItemEntry entry : this.getCatalogItemEntries()) {
            for (FeatureEntry featureEntry : entry.getChildren()) {
                org.eclipse.epp.mpc.ui.Operation old;
                org.eclipse.epp.mpc.ui.Operation operation = featureEntry.computeChangeOperation();
                if (operation == null || !includeNone && operation == org.eclipse.epp.mpc.ui.Operation.NONE || (old = featureEntries.put(featureEntry, operation)) == null || old == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
                if (operation == org.eclipse.epp.mpc.ui.Operation.NONE) {
                    featureEntries.put(featureEntry, old);
                    old = null;
                    continue;
                }
                if (!verify || old.equals((Object)operation)) continue;
                Status error = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.SelectionModel_Inconsistent_Actions, (Object[])new Object[]{featureEntry.getFeatureDescriptor().getName(), old, operation}));
                throw new IllegalStateException((Throwable)new CoreException((IStatus)error));
            }
        }
        return Collections.unmodifiableMap(featureEntries);
    }

    public Set<FeatureEntry> getSelectedFeatureEntries() {
        return this.getFeatureEntryToOperation(false, false).keySet();
    }

    @Deprecated
    public Set<FeatureDescriptor> getSelectedFeatureDescriptors() {
        HashSet<FeatureDescriptor> featureDescriptors = new HashSet<FeatureDescriptor>();
        Set<FeatureEntry> selectedFeatureEntries = this.getSelectedFeatureEntries();
        for (FeatureEntry featureEntry : selectedFeatureEntries) {
            featureDescriptors.add(featureEntry.getFeatureDescriptor());
        }
        return Collections.unmodifiableSet(featureDescriptors);
    }

    public Set<CatalogItem> getSelectedCatalogItems() {
        HashSet<CatalogItem> items = new HashSet<CatalogItem>();
        for (CatalogItemEntry entry : this.getCatalogItemEntries()) {
            if (entry.getSelectedOperation() == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
            for (FeatureEntry featureEntry : entry.getChildren()) {
                org.eclipse.epp.mpc.ui.Operation operation = featureEntry.computeChangeOperation();
                if (operation == null || operation == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
                items.add(entry.item);
                break;
            }
            if (entry.getSelectedOperation() != org.eclipse.epp.mpc.ui.Operation.CHANGE) continue;
            items.add(entry.item);
        }
        return Collections.unmodifiableSet(items);
    }

    @Deprecated
    public Operation getOperation(CatalogItem item) {
        org.eclipse.epp.mpc.ui.Operation operation = this.getSelectedOperation(item);
        return Operation.map(operation);
    }

    public org.eclipse.epp.mpc.ui.Operation getSelectedOperation(CatalogItem item) {
        org.eclipse.epp.mpc.ui.Operation operation = this.itemToOperation.get(item);
        return operation == null ? org.eclipse.epp.mpc.ui.Operation.NONE : operation;
    }

    public boolean computeProvisioningOperationViableForFeatureSelection() {
        IStatus status = this.computeFeatureOperationViability();
        if (status == null) {
            Map<org.eclipse.epp.mpc.ui.Operation, List<CatalogItem>> operationToItem = this.computeOperationToItem();
            return operationToItem.size() == 1 && operationToItem.containsKey((Object)org.eclipse.epp.mpc.ui.Operation.CHANGE);
        }
        return this.computeProvisioningOperationViable();
    }

    public boolean computeProvisioningOperationViable() {
        IStatus status = this.computeProvisioningOperationViability();
        if (status != null) {
            switch (status.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public IStatus computeProvisioningOperationViability() {
        IStatus featureStatus = this.computeFeatureOperationViability();
        if (featureStatus == null || !featureStatus.isOK()) {
            return featureStatus;
        }
        Map<org.eclipse.epp.mpc.ui.Operation, List<CatalogItem>> operationToItem = this.computeOperationToItem();
        if (operationToItem.size() == 0) {
            return new Status(4, "org.eclipse.epp.mpc.ui", Messages.SelectionModel_Nothing_Selected);
        }
        if (operationToItem.size() == 1) {
            Map.Entry<org.eclipse.epp.mpc.ui.Operation, List<CatalogItem>> entry = operationToItem.entrySet().iterator().next();
            return new Status(1, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.SelectionModel_count_selectedFor_operation, (Object)(entry.getValue().size() == 1 ? Messages.SelectionModel_oneSolution : NLS.bind((String)Messages.SelectionModel_countSolutions, (Object)entry.getValue().size())), (Object)entry.getKey().getLabel()));
        }
        if (operationToItem.size() == 2 && operationToItem.containsKey((Object)org.eclipse.epp.mpc.ui.Operation.INSTALL) && operationToItem.containsKey((Object)org.eclipse.epp.mpc.ui.Operation.UPDATE)) {
            int count = 0;
            for (List<CatalogItem> items : operationToItem.values()) {
                count += items.size();
            }
            return new Status(1, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.SelectionModel_countSolutionsSelectedForInstallUpdate, (Object)count));
        }
        return new Status(4, "org.eclipse.epp.mpc.ui", Messages.SelectionModel_cannotInstallRemoveConcurrently);
    }

    private IStatus computeFeatureOperationViability() {
        Map<FeatureEntry, org.eclipse.epp.mpc.ui.Operation> selectedFeatureEntries;
        try {
            selectedFeatureEntries = this.getFeatureEntryToOperation(false, true);
        }
        catch (IllegalStateException ex) {
            CoreException cause = (CoreException)ex.getCause();
            return cause.getStatus();
        }
        if (selectedFeatureEntries.isEmpty()) {
            return null;
        }
        return Status.OK_STATUS;
    }

    private Map<org.eclipse.epp.mpc.ui.Operation, List<CatalogItem>> computeOperationToItem() {
        Map<CatalogItem, org.eclipse.epp.mpc.ui.Operation> itemToOperation = this.getItemToSelectedOperation();
        HashMap<org.eclipse.epp.mpc.ui.Operation, List<CatalogItem>> catalogItemByOperation = new HashMap<org.eclipse.epp.mpc.ui.Operation, List<CatalogItem>>();
        for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : itemToOperation.entrySet()) {
            if (entry.getValue() == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
            ArrayList<CatalogItem> list = (ArrayList<CatalogItem>)catalogItemByOperation.get((Object)entry.getValue());
            if (list == null) {
                list = new ArrayList<CatalogItem>();
                catalogItemByOperation.put(entry.getValue(), list);
            }
            list.add(entry.getKey());
        }
        return catalogItemByOperation;
    }

    public void clear() {
        this.itemToOperation.clear();
        this.entries = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CatalogItemEntry {
        private final CatalogItem item;
        private final org.eclipse.epp.mpc.ui.Operation operation;
        private List<FeatureEntry> children;

        private CatalogItemEntry(CatalogItem item, org.eclipse.epp.mpc.ui.Operation operation) {
            this.item = item;
            this.operation = operation;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        @Deprecated
        public Operation getOperation() {
            return Operation.map(this.operation);
        }

        public org.eclipse.epp.mpc.ui.Operation getSelectedOperation() {
            return this.operation;
        }

        public List<FeatureEntry> getChildren() {
            return this.children;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CatalogItemEntry other = (CatalogItemEntry)obj;
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }

    public class FeatureEntry {
        private final CatalogItemEntry parent;
        private final MarketplaceNodeInstallableUnitItem installableUnitItem;
        private FeatureDescriptor featureDescriptor;
        private Boolean checked;

        private FeatureEntry(CatalogItemEntry parent, MarketplaceNodeInstallableUnitItem installableUnitItem) {
            this(parent, installableUnitItem, new FeatureDescriptor(installableUnitItem.getId()));
        }

        private FeatureEntry(CatalogItemEntry parent, MarketplaceNodeInstallableUnitItem installableUnitItem, FeatureDescriptor featureDescriptor) {
            this.parent = parent;
            this.installableUnitItem = installableUnitItem;
            this.featureDescriptor = featureDescriptor;
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.featureDescriptor;
        }

        public void setFeatureDescriptor(FeatureDescriptor featureDescriptor) {
            if (featureDescriptor != null && this.featureDescriptor != null && !this.featureDescriptor.getId().equals(featureDescriptor.getId())) {
                throw new IllegalStateException();
            }
            this.featureDescriptor = featureDescriptor;
        }

        public MarketplaceNodeInstallableUnitItem getInstallableUnitItem() {
            return this.installableUnitItem;
        }

        public boolean isOptional() {
            return this.getInstallableUnitItem().isOptional();
        }

        public boolean isInstalled() {
            return Boolean.TRUE.equals(this.getInstallableUnitItem().getInstalled());
        }

        public void setInstalled(boolean installed) {
            this.getInstallableUnitItem().setInstalled(installed);
        }

        public boolean hasUpdateAvailable() {
            return this.isInstalled() && Boolean.TRUE.equals(this.getInstallableUnitItem().getUpdateAvailable());
        }

        public boolean isRequiredInstall() {
            return !this.isInstalled() && !this.getInstallableUnitItem().isOptional();
        }

        public CatalogItemEntry getParent() {
            return this.parent;
        }

        public void setChecked(Boolean checked) {
            this.checked = checked;
        }

        public boolean isChecked() {
            return Boolean.TRUE.equals(this.checked);
        }

        public boolean isGrayed() {
            return this.checked == null;
        }

        public void setGrayed() {
            this.setChecked(null);
        }

        public org.eclipse.epp.mpc.ui.Operation computeChangeOperation() {
            return this.isGrayed() ? org.eclipse.epp.mpc.ui.Operation.NONE : this.computeChangeOperation(this.isChecked());
        }

        public org.eclipse.epp.mpc.ui.Operation computeChangeOperation(boolean checked) {
            CatalogItemEntry parent = this.getParent();
            switch (parent.getSelectedOperation()) {
                case INSTALL: 
                case UPDATE: {
                    if (checked) {
                        if (this.hasUpdateAvailable()) {
                            return org.eclipse.epp.mpc.ui.Operation.UPDATE;
                        }
                        if (this.isRequiredInstall() && !this.isInstalled()) {
                            return org.eclipse.epp.mpc.ui.Operation.INSTALL;
                        }
                        if (!this.isInstalled()) {
                            return org.eclipse.epp.mpc.ui.Operation.INSTALL;
                        }
                    }
                    return org.eclipse.epp.mpc.ui.Operation.NONE;
                }
                case UNINSTALL: {
                    if (checked && this.isInstalled()) {
                        return org.eclipse.epp.mpc.ui.Operation.UNINSTALL;
                    }
                    return org.eclipse.epp.mpc.ui.Operation.NONE;
                }
                case CHANGE: {
                    if (checked) {
                        if (this.isInstalled()) {
                            if (this.hasUpdateAvailable()) {
                                return org.eclipse.epp.mpc.ui.Operation.UPDATE;
                            }
                            return org.eclipse.epp.mpc.ui.Operation.NONE;
                        }
                        return org.eclipse.epp.mpc.ui.Operation.INSTALL;
                    }
                    if (this.isInstalled()) {
                        return org.eclipse.epp.mpc.ui.Operation.UNINSTALL;
                    }
                    return org.eclipse.epp.mpc.ui.Operation.NONE;
                }
            }
            return org.eclipse.epp.mpc.ui.Operation.NONE;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.featureDescriptor == null ? 0 : this.featureDescriptor.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureEntry other = (FeatureEntry)obj;
            if (this.featureDescriptor == null ? other.featureDescriptor != null : !this.featureDescriptor.equals(other.featureDescriptor)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }
    }
}

