/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.wizards.ActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesPage;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.jface.wizard.IWizard;

public class ImportFavoritesActionLink
extends ActionLink {
    private static final String IMPORT_ACTION_ID = "import";
    private final MarketplacePage marketplacePage;

    public ImportFavoritesActionLink(MarketplacePage page) {
        super(IMPORT_ACTION_ID, Messages.UserFavoritesAbstractImportActionItem_importFavoritesActionLabel, Messages.UserFavoritesAbstractImportActionItem_importFavoritesTooltip);
        this.marketplacePage = page;
    }

    public void selected() {
        this.importFavorites();
    }

    protected void importFavorites() {
        MarketplaceDiscoveryStrategy marketplaceStrategy = this.findMarketplaceDiscoveryStrategy();
        if (marketplaceStrategy != null && marketplaceStrategy.hasUserFavoritesService()) {
            this.importFavorites(marketplaceStrategy);
        }
    }

    protected MarketplaceDiscoveryStrategy findMarketplaceDiscoveryStrategy() {
        MarketplaceDiscoveryStrategy marketplaceStrategy = null;
        List discoveryStrategies = this.marketplacePage.getCatalog().getDiscoveryStrategies();
        for (AbstractDiscoveryStrategy strategy : discoveryStrategies) {
            if (!(strategy instanceof MarketplaceDiscoveryStrategy)) continue;
            marketplaceStrategy = (MarketplaceDiscoveryStrategy)strategy;
            break;
        }
        return marketplaceStrategy;
    }

    protected void importFavorites(MarketplaceDiscoveryStrategy marketplaceStrategy) {
        MarketplaceWizard wizard = this.marketplacePage.getWizard();
        FavoritesCatalog favoritesCatalog = new FavoritesCatalog();
        ImportFavoritesWizard importFavoritesWizard = new ImportFavoritesWizard(favoritesCatalog, wizard.getConfiguration(), wizard);
        final ImportFavoritesPage importFavoritesPage = importFavoritesWizard.getImportFavoritesPage();
        favoritesCatalog.getDiscoveryStrategies().add(new FavoritesDiscoveryStrategy(marketplaceStrategy){
            private String discoveryError;
            {
                super($anonymous0);
                this.discoveryError = null;
            }

            protected void preDiscovery() {
                this.discoveryError = null;
            }

            protected void handleDiscoveryError(CoreException ex) throws CoreException {
                this.discoveryError = ImportFavoritesPage.handleDiscoveryError(this.getFavoritesReference(), (Exception)ex);
            }

            protected void postDiscovery() {
                String errorMessage = this.discoveryError;
                this.discoveryError = null;
                importFavoritesPage.setDiscoveryError(errorMessage);
            }
        });
        int result = new ImportFavoritesWizardDialog(wizard.getShell(), (IWizard)importFavoritesWizard).open();
        if (result == 0) {
            MarketplacePage catalogPage = wizard.getCatalogPage();
            catalogPage.setActiveTab(MarketplaceViewer.ContentType.FAVORITES);
            catalogPage.reloadCatalog();
        }
    }
}

