/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpContextInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProvider;

abstract class AbstractAddCredentialsProviderInterceptor
implements HttpContextInterceptor {
    AbstractAddCredentialsProviderInterceptor() {
    }

    protected abstract boolean isMatchingProvider(CredentialsProvider var1);

    protected CredentialsProvider findExistingProvider(CredentialsProvider credentialsProvider) {
        if (this.isMatchingProvider(credentialsProvider)) {
            return credentialsProvider;
        }
        if (credentialsProvider instanceof ChainedCredentialsProvider) {
            ChainedCredentialsProvider chain = (ChainedCredentialsProvider)credentialsProvider;
            CredentialsProvider existingProvider = this.findExistingProvider(chain.getSecond());
            if (existingProvider != null) {
                return existingProvider;
            }
            return this.findExistingProvider(chain.getFirst());
        }
        if (credentialsProvider instanceof SynchronizedCredentialsProvider) {
            SynchronizedCredentialsProvider syncProvider = (SynchronizedCredentialsProvider)credentialsProvider;
            return this.findExistingProvider(syncProvider.getDelegate());
        }
        return null;
    }

    protected void addCredentialsProvider(String providerAttribute, HttpContext context) {
        Object value = context.getAttribute(providerAttribute);
        if (value != null) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        Object credentialsProvider = clientContext.getCredentialsProvider();
        CredentialsProvider resultProvider = this.findExistingProvider((CredentialsProvider)credentialsProvider);
        if (resultProvider == null) {
            resultProvider = this.getCredentialsProviderToAdd();
            credentialsProvider = credentialsProvider == null ? resultProvider : this.chainCredentialsProviders((CredentialsProvider)credentialsProvider, resultProvider);
            clientContext.setCredentialsProvider(credentialsProvider);
        }
        clientContext.setAttribute(providerAttribute, (Object)resultProvider);
    }

    protected abstract CredentialsProvider getCredentialsProviderToAdd();

    protected ChainedCredentialsProvider chainCredentialsProviders(CredentialsProvider existingProvider, CredentialsProvider addedProvider) {
        return new ChainedCredentialsProvider(existingProvider, addedProvider);
    }
}

