/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.am3.dsls.km3.actions;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.am3.dsls.km3.KM3Projector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class KM32MOF14
implements IObjectActionDelegate {
    private static final String pluginid = "org.eclipse.gmt.am3.dsls.km3";
    private static final String errorMsg = "An error was encountered while trying to get a MOF-1.4 metamodel from a KM3 file.";
    private AtlModelHandler amh = null;
    private ISelection selection;
    private KM3Projector kp = KM3Projector.getKM3Projector();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Job job = new Job("KM3 to MOF-1.4"){

            protected IStatus run(IProgressMonitor mon) {
                Status ret = null;
                mon.beginTask("KM3 to MOF-1.4", -1);
                if (KM32MOF14.this.amh == null) {
                    mon.subTask("Initializing MDR");
                    KM32MOF14.this.amh = AtlModelHandler.getDefault((String)"MDR");
                }
                try {
                    IFile file = (IFile)((IStructuredSelection)KM32MOF14.this.selection).getFirstElement();
                    mon.subTask("Parsing and checking KM3 file");
                    ASMModel km3model = KM32MOF14.this.kp.getEMFKM3FromFile(file);
                    ASMModel mof = null;
                    if (km3model != null) {
                        mon.subTask("Transforming KM3 model into MOF-1.4 metamodel");
                        mof = KM32MOF14.this.kp.getMOF14FromKM3File(file);
                    }
                    if (mof != null) {
                        mon.subTask("Serializing MOF-1.4 metamodel");
                        String name = file.getFullPath().removeFirstSegments(1).toString();
                        name = String.valueOf(name.substring(0, name.length() - file.getFileExtension().length())) + "xmi";
                        KM32MOF14.this.amh.saveModel(mof, name, file.getProject());
                        ret = new Status(0, KM32MOF14.pluginid, 0, file + " transformed into " + name, null);
                    } else {
                        ret = new Status(4, KM32MOF14.pluginid, 0, KM32MOF14.errorMsg, null);
                    }
                }
                catch (CoreException e) {
                    ret = new Status(4, KM32MOF14.pluginid, 0, KM32MOF14.errorMsg, (Throwable)e);
                }
                catch (IOException ioe) {
                    ret = new Status(4, KM32MOF14.pluginid, 0, KM32MOF14.errorMsg, (Throwable)ioe);
                }
                return ret;
            }
        };
        job.setPriority(40);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

