/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.am3.dsls.km3.actions;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.am3.dsls.km3.KM3Projector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class KM32Ecore
implements IObjectActionDelegate {
    private static final String pluginid = "org.eclipse.gmt.am3.dsls.km3";
    private static final String errorMsg = "An error was encountered while trying to get an Ecore metamodel from the KM3 file.";
    private AtlModelHandler amh = AtlModelHandler.getDefault((String)"EMF");
    private ISelection selection;
    private KM3Projector kp = KM3Projector.getKM3Projector();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Job job = new Job("KM3 to Ecore"){

            public IStatus run(IProgressMonitor mon) {
                Status ret = null;
                mon.beginTask("KM3 to Ecore", -1);
                try {
                    IFile file = (IFile)((IStructuredSelection)KM32Ecore.this.selection).getFirstElement();
                    mon.subTask("Parsing and checking KM3 file");
                    ASMModel km3model = KM32Ecore.this.kp.getEMFKM3FromFile(file);
                    ASMModel emf = null;
                    if (km3model != null) {
                        mon.subTask("Transforming KM3 model into Ecore metamodel");
                        emf = KM32Ecore.this.kp.getEcoreFromKM3(km3model);
                    }
                    if (emf != null) {
                        mon.subTask("Serializing Ecore metamodel");
                        String name = file.getFullPath().removeFirstSegments(1).toString();
                        name = String.valueOf(name.substring(0, name.length() - file.getFileExtension().length())) + "ecore";
                        KM32Ecore.this.amh.saveModel(emf, name, file.getProject());
                        ret = new Status(0, KM32Ecore.pluginid, 0, file + " transformed into " + name, null);
                    } else {
                        ret = new Status(4, KM32Ecore.pluginid, 0, KM32Ecore.errorMsg, null);
                    }
                }
                catch (CoreException e) {
                    ret = new Status(4, KM32Ecore.pluginid, 0, KM32Ecore.errorMsg, (Throwable)e);
                }
                catch (IOException ioe) {
                    ret = new Status(4, KM32Ecore.pluginid, 0, KM32Ecore.errorMsg, (Throwable)ioe);
                }
                return ret;
            }
        };
        job.setPriority(40);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

