/*
 * Decompiled with CFR 0.152.
 */
package org.atl.engine.extractors.ebnf;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.atl.engine.extractors.ebnf.EBNFExtractionException;
import org.eclipse.m2m.atl.engine.extractors.Extractor;
import org.eclipse.m2m.atl.engine.vm.nativelib.AMN;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class EBNFExtractor
implements Extractor {
    private boolean debug = false;
    private boolean debugws = false;
    private static Map parameterTypes = new HashMap();
    private Map templates = new HashMap();
    private Map primitiveTemplates = new HashMap();
    private Map tokens = new HashMap();
    private Collection keywords = new ArrayList();
    private boolean kwCheckIgnoreCase;
    private String identEscStart = "\"";
    private String identEscEnd = "\"";
    private String stringDelim = "'";
    private boolean serializeComments = true;
    private boolean usePrimitiveTemplates = false;
    private static DecimalFormatSymbols dfs;
    private DecimalFormat df = new DecimalFormat("0.##############", dfs);
    private PrintStream out;
    private Stack priorities = new Stack();
    private Stack currentSeparator = new Stack();
    private int indentLevel = 0;
    private String indentString = "  ";
    private String curIndent = "";
    private String standardSeparator = " ";
    private String lineFeed = "\n";
    private static final int TYPE_KEYWORD = 1;
    private static final int TYPE_SYMBOL = 2;
    private static final int TYPE_IDENT = 3;
    private static final int TYPE_BOOL = 4;
    private static final int TYPE_INT = 5;
    private static final int TYPE_REAL = 6;
    private static final int TYPE_STRING = 7;
    private static final int TYPE_SPACE = 8;
    private static final int TYPE_COMMENT = 9;
    private static final int SYMBOL_LS = 16;
    private static final int SYMBOL_RS = 32;
    private static final int SYMBOL_BS = 48;
    private static final int SYMBOL_LN = 64;
    private static final int SYMBOL_RN = 128;
    private int typeLast = 0;
    private Map symbols = new HashMap();

    static {
        parameterTypes.put("format", "Model:TCS");
        parameterTypes.put("indentString", "String");
        parameterTypes.put("standardSeparator", "String");
        parameterTypes.put("kwCheckIgnoreCase", "String");
        parameterTypes.put("identEsc", "String");
        parameterTypes.put("identEscStart", "String");
        parameterTypes.put("identEscEnd", "String");
        parameterTypes.put("stringDelim", "String");
        parameterTypes.put("debug", "String");
        parameterTypes.put("debugws", "String");
        parameterTypes.put("serializeComments", "String");
        parameterTypes.put("usePrimitiveTemplates", "String");
        parameterTypes.put("decimalFormat", "String");
        dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    private void error(String msg) {
        System.out.println("ERROR: " + msg);
    }

    public Map getParameterTypes() {
        return parameterTypes;
    }

    public void extract(ASMModel source, OutputStream target, Map params) {
        String value;
        String name;
        ASMModelElement ame;
        String decimalFormat;
        String stringDelim;
        String identEsc;
        String identEscEnd;
        this.out = new PrintStream(target);
        String newIndentString = (String)params.get("indentString");
        String newStandardSeparator = (String)params.get("standardSeparator");
        this.kwCheckIgnoreCase = "true".equals(params.get("kwCheckIgnoreCase"));
        this.debug = "true".equals(params.get("debug"));
        this.debugws = "true".equals(params.get("debugws"));
        this.serializeComments = !"false".equals(params.get("serializeComments"));
        this.usePrimitiveTemplates = "true".equals(params.get("usePrimitiveTemplates"));
        String identEscStart = (String)params.get("identEscStart");
        if (identEscStart != null) {
            this.identEscStart = identEscStart;
        }
        if ((identEscEnd = (String)params.get("identEscEnd")) != null) {
            this.identEscEnd = identEscEnd;
        }
        if ((identEsc = (String)params.get("identEsc")) != null) {
            this.identEscStart = identEsc;
            this.identEscEnd = identEsc;
        }
        if ((stringDelim = (String)params.get("stringDelim")) != null) {
            this.stringDelim = stringDelim;
        }
        if ((decimalFormat = (String)params.get("decimalFormat")) != null) {
            this.df = new DecimalFormat(decimalFormat, dfs);
        }
        if (newIndentString != null) {
            this.indentString = newIndentString;
        }
        if (newStandardSeparator != null) {
            this.standardSeparator = newStandardSeparator;
        }
        ASMModel format = (ASMModel)params.get("format");
        String rootName = null;
        ASMModelElement rootTemplate = null;
        Iterator i = format.getElementsByType("Template").iterator();
        while (i.hasNext()) {
            ame = (ASMModelElement)i.next();
            name = AMN.getString((ASMModelElement)ame, (String)"name");
            boolean isMain = false;
            try {
                isMain = AMN.getBool((ASMModelElement)ame, (String)"isMain");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isMain) {
                rootName = name;
                rootTemplate = ame;
            }
            if (AMN.getTypeName((ASMModelElement)ame).equals("EnumerationTemplate")) {
                HashMap<String, ASMModelElement> mappings = new HashMap<String, ASMModelElement>();
                Iterator j = AMN.getCol((ASMModelElement)ame, (String)"mappings");
                while (j.hasNext()) {
                    ASMModelElement mapping = (ASMModelElement)j.next();
                    mappings.put(AMN.getString((ASMModelElement)AMN.getME((ASMModelElement)mapping, (String)"literal"), (String)"name"), AMN.getME((ASMModelElement)mapping, (String)"element"));
                }
                this.templates.put(name, mappings);
                continue;
            }
            if (AMN.getTypeName((ASMModelElement)ame).equals("PrimitiveTemplate")) {
                this.primitiveTemplates.put(name, ame);
                name = AMN.getString((ASMModelElement)ame, (String)"typeName");
                ArrayList<ASMModelElement> c = (ArrayList<ASMModelElement>)this.templates.get(name);
                if (c == null) {
                    c = new ArrayList<ASMModelElement>();
                    this.templates.put(name, c);
                }
                c.add(ame);
                continue;
            }
            this.templates.put(name, ame);
        }
        i = format.getElementsByType("Keyword").iterator();
        while (i.hasNext()) {
            ame = (ASMModelElement)i.next();
            value = AMN.getString((ASMModelElement)ame, (String)"value");
            if (this.kwCheckIgnoreCase) {
                value = value.toUpperCase();
            }
            this.keywords.add(value);
        }
        i = format.getElementsByType("Token").iterator();
        while (i.hasNext()) {
            ame = (ASMModelElement)i.next();
            name = AMN.getString((ASMModelElement)ame, (String)"name");
            this.tokens.put(name, ame);
        }
        i = format.getElementsByType("Symbol").iterator();
        while (i.hasNext()) {
            ame = (ASMModelElement)i.next();
            value = AMN.getString((ASMModelElement)ame, (String)"value");
            this.debug("Symbol: " + value);
            int type = 2;
            Iterator j = AMN.getCol((ASMModelElement)ame, (String)"spaces");
            while (j.hasNext()) {
                String l = ((ASMEnumLiteral)j.next()).getName();
                this.debug("\tLiteral: " + l);
                if (l.equals("leftSpace")) {
                    type += 16;
                } else if (l.equals("leftNone")) {
                    type += 64;
                }
                if (l.equals("rightSpace")) {
                    type += 32;
                    continue;
                }
                if (!l.equals("rightNone")) continue;
                type += 128;
            }
            this.symbols.put(value, new Integer(type));
        }
        Iterator possibleRoots = source.getElementsByType(rootName).iterator();
        boolean isMulti = AMN.getBool((ASMModelElement)rootTemplate, (String)"isMulti");
        boolean first = true;
        while (possibleRoots.hasNext()) {
            ASMModelElement root = (ASMModelElement)possibleRoots.next();
            if (root.refImmediateComposite() instanceof ASMModelElement) continue;
            if (!isMulti && !first) {
                System.out.println("Error: multiple possible roots found.");
                break;
            }
            this.priorities.push(new Integer(Integer.MAX_VALUE));
            this.serialize(root);
            first = false;
        }
        if (first && !isMulti) {
            System.out.println("Error: no root found.");
        }
        this.out.close();
    }

    private void pushSep(String sep) {
        this.currentSeparator.push(sep);
        this.debug("PUSHING SEPARATOR: \"" + sep + "\"");
    }

    private void popSep() {
        String old = (String)this.currentSeparator.pop();
        this.debug("POPING SEPARATOR: \"" + old + "\"");
    }

    private void serialize(ASMModelElement ame) {
        this.pushSep(this.standardSeparator);
        String typeName = AMN.getTypeName((ASMModelElement)ame);
        this.debug("processing " + typeName);
        ASMModelElement template = (ASMModelElement)this.templates.get(typeName);
        if (template == null) {
            throw new EBNFExtractionException("cannot find mathing template for: " + typeName, null);
        }
        String templateTypeName = AMN.getTypeName((ASMModelElement)template);
        this.debug("Applying template type " + templateTypeName);
        if (this.serializeComments) {
            try {
                boolean first = true;
                boolean nl = false;
                Iterator i = AMN.getCol((ASMModelElement)ame, (String)"commentsBefore");
                while (i.hasNext()) {
                    String c = ((ASMString)i.next()).getSymbol();
                    if (c.equals("\n")) {
                        nl = true;
                        continue;
                    }
                    this.debug("printing comment: \"" + c + "\"");
                    if (first && !nl) {
                        this.printComment(c);
                    } else {
                        this.printComment(c);
                    }
                    this.printWS(String.valueOf(this.lineFeed) + this.curIndent);
                    first = false;
                }
            }
            catch (Exception e) {
                System.out.println("Warning: could not get comments of " + ame + ", disabling further comments serialization");
                this.serializeComments = false;
            }
        }
        if (templateTypeName.equals("ClassTemplate")) {
            this.priorities.push(new Integer(Integer.MAX_VALUE));
            this.serializeSeq(ame, AMN.getME((ASMModelElement)template, (String)"templateSequence"));
            this.priorities.pop();
        } else if (templateTypeName.equals("OperatorTemplate")) {
            ASMModelElement literal;
            String sourcePropName = AMN.getString((ASMModelElement)template, (String)"source");
            String opPropName = AMN.getString((ASMModelElement)template, (String)"storeOpTo");
            String rightPropName = AMN.getString((ASMModelElement)template, (String)"storeRightTo");
            this.debug("OperatorTemplate: source = " + sourcePropName + " ; operator = " + opPropName + " ; right = " + rightPropName);
            ASMOclAny r = null;
            boolean isUnary = false;
            if (rightPropName != null) {
                r = AMN.get((ASMModelElement)ame, (String)rightPropName);
                isUnary = r instanceof ASMCollection ? ((ASMCollection)r).collection().size() == 0 : r == null;
            }
            this.debug("rightPropName = " + rightPropName + " ; isUnary = " + isUnary);
            ASMModelElement operator = null;
            if (opPropName != null) {
                String op = AMN.getString((ASMModelElement)ame, (String)opPropName);
                if (op == null) {
                    throw new RuntimeException("Property " + opPropName + " has not been set in " + ame + " (" + ame.getMetaobject() + ")");
                }
                Iterator i = AMN.getCol((ASMModelElement)template, (String)"operators");
                while (i.hasNext() && operator == null) {
                    ASMModelElement opme = (ASMModelElement)i.next();
                    literal = AMN.getME((ASMModelElement)opme, (String)"literal");
                    String opmes = null;
                    opmes = literal == null ? "" : AMN.getString((ASMModelElement)literal, (String)"value");
                    int arity = AMN.getInt((ASMModelElement)opme, (String)"arity");
                    if (!op.equals(opmes)) continue;
                    if (rightPropName != null) {
                        if ((!isUnary || arity != 1) && (isUnary || arity != 2)) continue;
                        operator = opme;
                        continue;
                    }
                    operator = opme;
                }
                if (operator == null) {
                    System.err.println("Error: could not find operator \"" + op + "\"");
                }
            } else {
                operator = (ASMModelElement)AMN.getCol((ASMModelElement)template, (String)"operators").next();
            }
            int curPrio = (Integer)this.priorities.peek();
            int priority = AMN.getInt((ASMModelElement)AMN.getME((ASMModelElement)operator, (String)"priority"), (String)"value");
            boolean paren = priority > curPrio;
            this.priorities.push(new Integer(priority));
            literal = AMN.getME((ASMModelElement)operator, (String)"literal");
            this.debug("PRIORITY = " + priority + " ; CURPRIO = " + curPrio + " ; OPERATOR = " + (literal != null ? AMN.getString((ASMModelElement)literal, (String)"value") : "") + " ; paren = " + paren);
            if (paren) {
                this.printSymbol("(");
            }
            ASMModelElement source = AMN.getME((ASMModelElement)ame, (String)sourcePropName);
            if (isUnary) {
                if (literal != null) {
                    this.printLiteral(literal);
                }
                this.serialize(source);
            } else {
                this.serialize(source);
                if (literal != null) {
                    this.printLiteral(literal);
                }
            }
            if (rightPropName == null) {
                this.priorities.push(new Integer(Integer.MAX_VALUE));
                this.serializeSeq(ame, AMN.getME((ASMModelElement)template, (String)"otSequence"));
                this.priorities.pop();
            } else if (r instanceof ASMCollection) {
                Iterator i = ((ASMCollection)r).iterator();
                while (i.hasNext()) {
                    this.serialize((ASMModelElement)i.next());
                }
            } else if (!isUnary) {
                this.serialize((ASMModelElement)r);
            }
            this.priorities.pop();
            if (paren) {
                this.printSymbol(")");
            }
        } else {
            this.error("unsupported template type: " + templateTypeName);
        }
        if (this.serializeComments) {
            try {
                Iterator i = AMN.getCol((ASMModelElement)ame, (String)"commentsAfter");
                while (i.hasNext()) {
                    String c = ((ASMString)i.next()).getSymbol();
                    if (c.equals("\n")) continue;
                    this.printComment(c);
                    this.printWS(String.valueOf(this.lineFeed) + this.curIndent);
                }
            }
            catch (Exception e) {
                System.out.println("Warning: could not get comments of " + ame + ", disabling further comments serialization");
                this.serializeComments = false;
            }
        }
        this.popSep();
    }

    private void serializeSeq(ASMModelElement ame, ASMModelElement seq) {
        if (seq != null) {
            Iterator i = AMN.getCol((ASMModelElement)seq, (String)"elements");
            while (i.hasNext()) {
                ASMModelElement e = (ASMModelElement)i.next();
                this.serializeSeqElem(ame, e);
            }
        }
    }

    private String getLineFeeds(int n) {
        String ret = "";
        int i = 0;
        while (i < n) {
            ret = String.valueOf(ret) + this.lineFeed;
            ++i;
        }
        return ret;
    }

    private void serializeSeqElem(ASMModelElement element, ASMModelElement seqElem) {
        String tn = AMN.getTypeName((ASMModelElement)seqElem);
        this.debug("serializing seq elem " + tn);
        if (tn.equals("LiteralRef")) {
            ASMModelElement literal = AMN.getME((ASMModelElement)seqElem, (String)"referredLiteral");
            this.printLiteral(literal);
        } else if (tn.equals("CustomSeparator")) {
            String name = AMN.getString((ASMModelElement)seqElem, (String)"name");
            if (name.equals("no_space")) {
                this.typeLast = 130;
            } else if (name.equals("space")) {
                this.printWS(" ");
            } else if (name.equals("newline")) {
                this.printWS(this.lineFeed);
            } else if (name.equals("tab")) {
                this.printWS("\t");
            }
        } else if (tn.equals("Property")) {
            ASMOclAny v = AMN.get((ASMModelElement)element, (String)AMN.getName((ASMModelElement)seqElem));
            this.serializeProperty(element, v, seqElem);
        } else if (tn.equals("Block")) {
            if (this.debugws) {
                this.out.print("<block>");
            }
            ASMModelElement nbNLBArg = EBNFExtractor.getBArg(seqElem, "NbNL");
            ASMModelElement startNbNLBArg = EBNFExtractor.getBArg(seqElem, "StartNbNL");
            ASMModelElement indentIncrBArg = EBNFExtractor.getBArg(seqElem, "IndentIncr");
            ASMModelElement startNLBArg = EBNFExtractor.getBArg(seqElem, "StartNL");
            ASMModelElement endNLBArg = EBNFExtractor.getBArg(seqElem, "EndNL");
            int indentIncr = 1;
            int nbNL = 1;
            boolean startNL = true;
            boolean endNL = true;
            if (nbNLBArg != null) {
                nbNL = AMN.getInt((ASMModelElement)nbNLBArg, (String)"value");
            }
            int startNbNL = nbNL;
            if (startNbNLBArg != null) {
                startNbNL = AMN.getInt((ASMModelElement)startNbNLBArg, (String)"value");
            }
            if (indentIncrBArg != null) {
                indentIncr = AMN.getInt((ASMModelElement)indentIncrBArg, (String)"value");
            }
            if (startNLBArg != null) {
                startNL = AMN.getBool((ASMModelElement)startNLBArg, (String)"value");
            }
            if (endNLBArg != null) {
                endNL = AMN.getBool((ASMModelElement)endNLBArg, (String)"value");
            }
            this.debug("nbNL = " + nbNL + " ; indentIncr = " + indentIncr);
            this.indentLevel += indentIncr;
            int i = 0;
            while (i < indentIncr) {
                this.curIndent = String.valueOf(this.curIndent) + this.indentString;
                ++i;
            }
            String nls = this.getLineFeeds(nbNL);
            this.pushSep(String.valueOf(nls) + (nbNL == 0 ? this.standardSeparator : this.curIndent));
            if (this.debugws) {
                this.out.print("<BeforeFirstWS/>");
            }
            if (startNL) {
                if (startNbNL == 0) {
                    this.printWS("");
                } else if (nbNL == startNbNL) {
                    this.printWS();
                } else {
                    this.printWS(String.valueOf(this.getLineFeeds(startNbNL)) + this.curIndent);
                }
            } else {
                if (this.debugws) {
                    this.out.print("<BeforeNonStartNLWS/>");
                }
                this.printWS("");
                if (this.debugws) {
                    this.out.print("<AfterNonStartNLWS/>");
                }
            }
            if (this.debugws) {
                this.out.print("<blockContent>");
            }
            this.serializeSeq(element, AMN.getME((ASMModelElement)seqElem, (String)"blockSequence"));
            if (this.debugws) {
                this.out.print("</blockContent>");
            }
            this.indentLevel -= indentIncr;
            this.curIndent = this.curIndent.substring(0, this.curIndent.length() - this.indentString.length() * indentIncr);
            if (endNL) {
                this.printWS(String.valueOf(this.lineFeed) + this.curIndent);
            }
            this.popSep();
            if (this.debugws) {
                this.out.print("</block>");
            }
        } else if (tn.equals("FunctionCall")) {
            this.serializeSeq(element, AMN.getME((ASMModelElement)AMN.getME((ASMModelElement)seqElem, (String)"calledFunction"), (String)"functionSequence"));
        } else if (tn.equals("ConditionalElement")) {
            ASMModelElement condition = AMN.getME((ASMModelElement)seqElem, (String)"condition");
            if (this.eval(element, condition)) {
                ASMModelElement tseq = AMN.getME((ASMModelElement)seqElem, (String)"thenSequence");
                if (tseq != null) {
                    this.printWSBlockNoDup();
                }
                this.serializeSeq(element, tseq);
            } else {
                ASMModelElement eseq = AMN.getME((ASMModelElement)seqElem, (String)"elseSequence");
                this.debug("ELSE SEQ = " + eseq);
                if (eseq != null) {
                    this.printWSBlockNoDup();
                }
                this.serializeSeq(element, eseq);
            }
        } else {
            this.error("unsupported: " + tn);
        }
    }

    private boolean eval(ASMModelElement context, ASMModelElement condition) {
        boolean ret = true;
        String ctn = AMN.getTypeName((ASMModelElement)condition);
        if (ctn.equals("AndExp")) {
            ret = true;
            Iterator i = AMN.getCol((ASMModelElement)condition, (String)"expressions");
            while (i.hasNext()) {
                ret &= this.eval(context, (ASMModelElement)i.next());
            }
        } else if (ctn.equals("BooleanPropertyExp")) {
            ret = AMN.getBool((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName"));
        } else if (ctn.equals("IsDefinedExp")) {
            ASMOclAny val = AMN.get((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName"));
            ret = val instanceof ASMOclUndefined || val == null ? false : (val instanceof ASMCollection ? ((ASMCollection)val).collection().size() > 0 : true);
            if (AMN.getString((ASMModelElement)condition, (String)"propertyName").equals("superRule")) {
                this.debug("!!!superRule: " + ret + " " + val);
            }
        } else if (ctn.equals("OneExp")) {
            ASMOclAny val = AMN.get((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName"));
            ret = val instanceof ASMOclUndefined || val == null ? false : (val instanceof ASMCollection ? ((ASMCollection)val).collection().size() == 1 : true);
            if (AMN.getString((ASMModelElement)condition, (String)"propertyName").equals("superRule")) {
                this.debug("!!!superRule: " + ret + " " + val);
            }
        } else if (ctn.equals("EqualsExp")) {
            ASMModelElement value = AMN.getME((ASMModelElement)condition, (String)"value");
            String vtn = AMN.getTypeName((ASMModelElement)value);
            if (vtn.equals("IntegerVal")) {
                int pv;
                int lv = AMN.getInt((ASMModelElement)value, (String)"symbol");
                ret = lv == (pv = AMN.getInt((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName")));
            } else if (vtn.equals("NegativeIntegerVal")) {
                int pv;
                int lv = -AMN.getInt((ASMModelElement)value, (String)"symbol");
                ret = lv == (pv = AMN.getInt((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName")));
            } else if (vtn.equals("StringVal")) {
                String lv = AMN.getString((ASMModelElement)value, (String)"symbol");
                String pv = AMN.getString((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName"));
                ret = lv.equals(pv);
            } else if (vtn.equals("EnumLiteralVal")) {
                String lv = AMN.getString((ASMModelElement)value, (String)"name");
                String pv = AMN.getString((ASMModelElement)context, (String)AMN.getString((ASMModelElement)condition, (String)"propertyName"));
                ret = lv.equals(pv);
            } else {
                this.error(String.valueOf(vtn) + " unsupported.");
            }
        }
        return ret;
    }

    private void serializeProperty(ASMModelElement element, ASMOclAny value, ASMModelElement property) {
        if (value == null) {
            return;
        }
        if (value instanceof ASMCollection) {
            ASMModelElement sep = EBNFExtractor.getPArg(property, "Separator");
            if (sep != null) {
                sep = AMN.getME((ASMModelElement)sep, (String)"separatorSequence");
            }
            boolean first = true;
            Iterator i = ((ASMCollection)value).iterator();
            while (i.hasNext()) {
                if (first) {
                    this.printWSBlockNoDup();
                    first = false;
                } else {
                    this.printWS();
                }
                this.serializeProperty(element, (ASMOclAny)i.next(), property);
                if (!i.hasNext() || sep == null) continue;
                this.serializeSeq(null, sep);
            }
        } else if (value instanceof ASMEnumLiteral) {
            String enumName = AMN.getName((ASMModelElement)element.getMetaobject().getPropertyType(AMN.getName((ASMModelElement)property)));
            Map mappings = (Map)this.templates.get(enumName);
            ASMModelElement seqElem = (ASMModelElement)mappings.get(((ASMEnumLiteral)value).getName());
            this.serializeSeqElem(element, seqElem);
        } else if (value instanceof ASMModelElement) {
            this.printWSBlockNoDup();
            ASMModelElement refersTo = EBNFExtractor.getPArg(property, "RefersTo");
            if (refersTo == null) {
                this.serialize((ASMModelElement)value);
            } else {
                ASMOclAny v = AMN.get((ASMModelElement)((ASMModelElement)value), (String)AMN.getString((ASMModelElement)refersTo, (String)"propertyName"));
                ASMModelElement asp = EBNFExtractor.getPArg(property, "As");
                String as = null;
                if (asp != null) {
                    as = AMN.getString((ASMModelElement)asp, (String)"value");
                }
                this.serializePrimitive(v, as);
            }
        } else if (value instanceof ASMString || value instanceof ASMBoolean || value instanceof ASMReal || value instanceof ASMInteger) {
            this.printWSBlockNoDup();
            ASMModelElement asp = EBNFExtractor.getPArg(property, "As");
            String as = null;
            if (asp != null) {
                as = AMN.getString((ASMModelElement)asp, (String)"value");
            }
            this.serializePrimitive(value, as);
        } else {
            this.error("unsupported " + (value == null ? null : value.getClass()));
        }
    }

    private void serializePrimitive(ASMOclAny value, String as) {
        if (value instanceof ASMString) {
            boolean doDefault = true;
            if (this.usePrimitiveTemplates) {
                Collection c = (Collection)this.templates.get("String");
                ASMModelElement t = null;
                Iterator i = c.iterator();
                while (i.hasNext() && t == null) {
                    ASMModelElement ame = (ASMModelElement)i.next();
                    if (as == null && AMN.getBool((ASMModelElement)ame, (String)"isDefault")) {
                        t = ame;
                        continue;
                    }
                    if (!AMN.getString((ASMModelElement)ame, (String)"name").equals(as)) continue;
                    t = ame;
                }
                if (t == null) {
                    System.out.println("warning: no primitive template found for String" + (as == null ? "" : "as " + as));
                } else {
                    String tokenName = AMN.getString(t, (String)"tokenName");
                    ASMModelElement token = (ASMModelElement)this.tokens.get(tokenName);
                    if (token != null) {
                        System.out.println("Token found: " + tokenName);
                        ASMModelElement pattern = AMN.getME((ASMModelElement)token, (String)"pattern");
                        String regex = "^" + this.buildRegex(pattern) + "$";
                        System.out.println(regex);
                        String val = ((ASMString)value).getSymbol();
                        System.out.println(val);
                        System.out.println(val.matches(regex));
                    }
                }
            }
            if (doDefault) {
                if ("stringSymbol".equals(as)) {
                    this.printStringLiteral(((ASMString)value).cString());
                } else {
                    ASMModelElement template = (ASMModelElement)this.primitiveTemplates.get(as);
                    boolean orKeyword = false;
                    if (template != null) {
                        orKeyword = AMN.getBoolUndefinedIsFalse((ASMModelElement)template, (String)"orKeyword");
                    }
                    this.printIdentifier(((ASMString)value).getSymbol(), orKeyword);
                }
            }
        } else if (value instanceof ASMInteger) {
            this.printIntegerLiteral(((ASMInteger)value).getSymbol());
        } else if (value instanceof ASMReal) {
            this.printRealLiteral(((ASMReal)value).getSymbol());
        } else if (value instanceof ASMBoolean) {
            this.printBooleanLiteral(((ASMBoolean)value).getSymbol());
        }
    }

    private String buildRegex(ASMModelElement pattern) {
        String ret = null;
        String typeName = AMN.getTypeName((ASMModelElement)pattern);
        if (typeName.equals("OrPattern")) {
            boolean paren = false;
            Iterator i = AMN.getCol((ASMModelElement)pattern, (String)"simplePatterns");
            while (i.hasNext()) {
                ASMModelElement p = (ASMModelElement)i.next();
                if (ret == null) {
                    ret = this.buildRegex(p);
                    continue;
                }
                paren = true;
                ret = String.valueOf(ret) + "|" + this.buildRegex(p);
            }
            if (paren) {
                ret = "(" + ret + ")";
            }
        } else if (typeName.equals("RulePattern")) {
            ASMModelElement rule = AMN.getME((ASMModelElement)pattern, (String)"rule");
            String rtn = AMN.getTypeName((ASMModelElement)rule);
            if (rtn.equals("WordRule")) {
                ret = "(";
                ret = String.valueOf(ret) + this.buildRegex(AMN.getME((ASMModelElement)rule, (String)"start"));
                ret = String.valueOf(ret) + this.buildRegex(AMN.getME((ASMModelElement)rule, (String)"part")) + "*";
                ASMModelElement end = AMN.getME((ASMModelElement)rule, (String)"end");
                if (end != null) {
                    ret = String.valueOf(ret) + this.buildRegex(end);
                }
                ret = String.valueOf(ret) + ")";
            } else if (rtn.equals("MultiLineRule")) {
                ret = "(";
                String endRegex = this.buildRegex(AMN.getME((ASMModelElement)rule, (String)"end"));
                String middleRegex = "[^" + endRegex + "]";
                ASMModelElement esc = AMN.getME((ASMModelElement)rule, (String)"esc");
                if (esc != null) {
                    String escRegex = this.buildRegex(esc);
                    middleRegex = "(" + middleRegex + "|" + escRegex + ".)";
                }
                ret = String.valueOf(ret) + middleRegex + "*";
                ret = String.valueOf(ret) + ")";
            } else {
                this.error("unsupported rule type: " + rtn);
            }
        } else if (typeName.equals("StringPattern")) {
            String name = AMN.getString((ASMModelElement)pattern, (String)"name");
            ret = name.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\*", "\\\\*").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+");
        } else if (typeName.equals("ClassPattern")) {
            String name = AMN.getString((ASMModelElement)pattern, (String)"name");
            ret = "\\p{" + ("" + name.charAt(0)).toUpperCase() + name.substring(1) + "}";
        } else {
            this.error("unsupported pattern type: " + typeName);
        }
        return ret;
    }

    private void printLiteral(ASMModelElement literal) {
        String s = AMN.getString((ASMModelElement)literal, (String)"value");
        String ltn = AMN.getTypeName((ASMModelElement)literal);
        if (ltn.equals("Keyword")) {
            this.printKeyword(s);
        } else {
            this.printSymbol(s);
        }
    }

    private void printWS(String ws) {
        this.debug("printing WS = \"" + ws + "\"");
        this.out.print(ws);
        this.typeLast = 8;
    }

    private void printWS() {
        this.printWS((String)this.currentSeparator.peek());
    }

    private boolean isSymbol(int type, int test) {
        return (type & (test += 2)) == test;
    }

    private void printDisambiguationWS() {
        if (this.typeLast == 1 || this.typeLast == 3 || this.typeLast == 5 || this.typeLast == 6 || this.typeLast == 7 || this.typeLast == 4 || this.isSymbol(this.typeLast, 48) || this.isSymbol(this.typeLast, 32)) {
            this.printWS();
        }
    }

    private void printWSBlockNoDup() {
        if (this.typeLast != 8 && !this.currentSeparator.peek().equals(" ")) {
            this.printWS();
        }
    }

    private void printWSNoDup() {
        if (this.typeLast != 8) {
            this.printWS();
        }
    }

    private void printKeyword(String keyword) {
        this.printDisambiguationWS();
        this.out.print(keyword);
        this.typeLast = 1;
    }

    private void printSymbol(String symbol) {
        Integer type = (Integer)this.symbols.get(symbol);
        int typeCurrent = -1;
        typeCurrent = type == null ? 2 : type;
        if ((this.isSymbol(typeCurrent, 16) || this.isSymbol(typeCurrent, 48)) && !this.isSymbol(this.typeLast, 128) || (this.isSymbol(this.typeLast, 32) || this.isSymbol(this.typeLast, 48)) && !this.isSymbol(typeCurrent, 64)) {
            this.printWSNoDup();
        }
        this.out.print(symbol);
        this.typeLast = typeCurrent;
    }

    private void printIdentifier(String ident, boolean orKeyword) {
        this.printDisambiguationWS();
        boolean simpleIdent = ident.matches("[_a-zA-Z][_a-zA-Z0-9]*");
        if (simpleIdent && !orKeyword) {
            boolean bl = simpleIdent = !this.keywords.contains(ident);
        }
        if (!orKeyword && this.kwCheckIgnoreCase && this.keywords.contains(ident.toUpperCase())) {
            simpleIdent = false;
        }
        if (simpleIdent) {
            this.out.print(ident);
        } else {
            this.out.print(this.identEscStart);
            this.out.print(ident);
            this.out.print(this.identEscEnd);
        }
        this.typeLast = 3;
    }

    private void printBooleanLiteral(boolean v) {
        this.printDisambiguationWS();
        this.out.print(v);
        this.typeLast = 4;
    }

    private void printIntegerLiteral(int v) {
        this.printDisambiguationWS();
        this.out.print(v);
        this.typeLast = 5;
    }

    private void printRealLiteral(double v) {
        this.printDisambiguationWS();
        this.out.print(this.df.format(v));
        this.typeLast = 6;
    }

    private void printStringLiteral(String v) {
        this.printDisambiguationWS();
        this.out.print(this.stringDelim);
        this.out.print(v);
        this.out.print(this.stringDelim);
        this.typeLast = 7;
    }

    private void printComment(String c) {
        this.printDisambiguationWS();
        this.out.print(c);
        this.typeLast = 9;
    }

    private static ASMModelElement getPArg(ASMModelElement ame, String name) {
        ASMModelElement ret = null;
        Iterator i = AMN.getCol((ASMModelElement)ame, (String)"propertyArgs");
        while (i.hasNext() && ret == null) {
            ASMModelElement arg = (ASMModelElement)i.next();
            if (!AMN.getTypeName((ASMModelElement)arg).equals(String.valueOf(name) + "PArg")) continue;
            ret = arg;
        }
        return ret;
    }

    private static ASMModelElement getBArg(ASMModelElement ame, String name) {
        ASMModelElement ret = null;
        Iterator i = AMN.getCol((ASMModelElement)ame, (String)"blockArgs");
        while (i.hasNext() && ret == null) {
            ASMModelElement arg = (ASMModelElement)i.next();
            if (!AMN.getTypeName((ASMModelElement)arg).equals(String.valueOf(name) + "BArg")) continue;
            ret = arg;
        }
        return ret;
    }

    public void extract(ASMModel format, ASMModel extent, OutputStream out) {
    }

    public String getPrefix() {
        return "ebnf";
    }
}

