/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.engine.Atl2004Compiler;
import org.eclipse.m2m.atl.engine.AtlStandaloneCompiler;
import org.eclipse.m2m.atl.engine.CompilerNotFoundException;

public class AtlCompiler {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static AtlCompiler defaultCompiler = null;
    private static final int MAX_LINE_LENGTH = 1000;
    private static Map compilers = new HashMap();

    public static AtlCompiler getDefault() {
        if (defaultCompiler == null) {
            defaultCompiler = new AtlCompiler();
        }
        return defaultCompiler;
    }

    public EObject[] compile(InputStream in, IFile out) {
        EObject[] ret = null;
        String atlcompiler = null;
        in = new BufferedInputStream(in, 1000);
        in.mark(1000);
        byte[] buffer = new byte[1000];
        try {
            int length = in.read(buffer);
            BufferedReader brin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer, 0, length)));
            String firstLine = brin.readLine();
            atlcompiler = firstLine.replaceFirst("^\\p{Space}*--\\p{Space}*@atlcompiler\\p{Space}+([^\\p{Space}]*)\\p{Space}*$", "$1");
            if (atlcompiler.equals(firstLine)) {
                atlcompiler = "atl2004";
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        try {
            in.reset();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ret = AtlCompiler.getCompiler(atlcompiler).compileWithProblemModel(in, out.getLocation().toString());
        try {
            out.refreshLocal(0, null);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    private static AtlStandaloneCompiler getCompiler(String compilerName) {
        AtlStandaloneCompiler ret = (AtlStandaloneCompiler)compilers.get(compilerName);
        if (ret == null) {
            if ("atl2004".equals(compilerName)) {
                ret = new Atl2004Compiler();
                compilers.put(compilerName, ret);
            } else {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                if (registry == null) {
                    throw new RuntimeException("Eclipse platform extension registry not found. Dynamic repository lookup does not work outside Eclipse.");
                }
                IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.atlcompiler");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                block2: while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        try {
                            if (elements[j].getAttribute("name").equals(compilerName)) {
                                ret = (AtlStandaloneCompiler)elements[j].createExecutableExtension("class");
                                compilers.put(compilerName, ret);
                                break block2;
                            }
                        }
                        catch (CoreException e) {
                            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (ret == null) {
                throw new CompilerNotFoundException("ATL compiler " + compilerName + " not found. You may need to install an ATL compiler plugin.");
            }
        }
        return ret;
    }
}

