/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.deploy.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.diagram.deploy.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;

public class DeploymentReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public DeploymentReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Deployment)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof DeploymentTarget) || !(this.newEnd instanceof DeploymentTarget)) {
            return false;
        }
        if (this.getLink().getDeployedArtifacts().size() != 1) {
            return false;
        }
        DeployedArtifact target = (DeployedArtifact)this.getLink().getDeployedArtifacts().get(0);
        if (!(this.getLink().eContainer() instanceof DeploymentTarget)) {
            return false;
        }
        DeploymentTarget container = (DeploymentTarget)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistDeployment_4001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof DeployedArtifact) || !(this.newEnd instanceof DeployedArtifact)) {
            return false;
        }
        DeploymentTarget source = this.getLink().getLocation();
        if (!(this.getLink().eContainer() instanceof DeploymentTarget)) {
            return false;
        }
        DeploymentTarget container = (DeploymentTarget)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistDeployment_4001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setLocation(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getDeployedArtifacts().remove((Object)this.getOldTarget());
        this.getLink().getDeployedArtifacts().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Deployment getLink() {
        return (Deployment)this.getElementToEdit();
    }

    protected DeploymentTarget getOldSource() {
        return (DeploymentTarget)this.oldEnd;
    }

    protected DeploymentTarget getNewSource() {
        return (DeploymentTarget)this.newEnd;
    }

    protected DeployedArtifact getOldTarget() {
        return (DeployedArtifact)this.oldEnd;
    }

    protected DeployedArtifact getNewTarget() {
        return (DeployedArtifact)this.newEnd;
    }
}

