/**
 * Copyright (c) 2007-2015, 2021 Borland Software Corporation, Montages, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Anatolyi Tischenko - Initial API and implementation
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package xpt.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.Common;
import xpt.diagram.Utils_qvto;
import xpt.diagram.editpolicies.BaseItemSemanticEditPolicy;

@Singleton
@SuppressWarnings("all")
public class ReorientLinkUtils {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private BaseItemSemanticEditPolicy xptBaseItemSemanticEditPolicy;

  /**
   * Expands to all accessor methods for link and it's ends.
   */
  public CharSequence accessors(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _linkAccessor = this.linkAccessor(it.getModelFacet());
    _builder.append(_linkAccessor);
    _builder.newLineIfNotEmpty();
    CharSequence _oldSourceAccessor = this.oldSourceAccessor(it.getModelFacet());
    _builder.append(_oldSourceAccessor);
    _builder.newLineIfNotEmpty();
    CharSequence _newSourceAccessor = this.newSourceAccessor(it.getModelFacet());
    _builder.append(_newSourceAccessor);
    _builder.newLineIfNotEmpty();
    CharSequence _oldTargetAccessor = this.oldTargetAccessor(it.getModelFacet());
    _builder.append(_oldTargetAccessor);
    _builder.newLineIfNotEmpty();
    CharSequence _newTargetAccessor = this.newTargetAccessor(it.getModelFacet());
    _builder.append(_newTargetAccessor);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _linkAccessor(final LinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _linkAccessor(final TypeLinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(xptSelf.getMetaClass());
    _builder.append(_QualifiedClassName);
    _builder.append(" getLink() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(xptSelf.getMetaClass(), "getElementToEdit()");
    _builder.append(_CastEObject, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _oldSourceAccessor(final LinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _oldSourceAccessor(final TypeLinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(xptSelf.getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" getOldSource() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(xptSelf.getSourceType(), "oldEnd");
    _builder.append(_CastEObject, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _oldSourceAccessor(final FeatureLinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(xptSelf.getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" getOldSource() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(xptSelf.getSourceType(), "referenceOwner");
    _builder.append(_CastEObject, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence newSourceAccessor(final LinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(xptSelf.getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" getNewSource() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(xptSelf.getSourceType(), "newEnd");
    _builder.append(_CastEObject, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence oldTargetAccessor(final LinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(xptSelf.getTargetType());
    _builder.append(_QualifiedClassName);
    _builder.append(" getOldTarget() {");
    _builder.newLineIfNotEmpty();
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(xptSelf.getTargetType(), "oldEnd");
    _builder.append(_CastEObject);
    _builder.append("; ");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence newTargetAccessor(final LinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(xptSelf.getTargetType());
    _builder.append(_QualifiedClassName);
    _builder.append(" getNewTarget() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _CastEObject = this.xptMetaModel.CastEObject(xptSelf.getTargetType(), "newEnd");
    _builder.append(_CastEObject, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * Generates canExecute() method for the command that reorients link.
   * Implementation should perform all static checks that command can be executed.
   */
  public CharSequence canReorient(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canExecute() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkLinkValidity = this.checkLinkValidity(it);
    _builder.append(_checkLinkValidity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_SOURCE) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return canReorientSource();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_TARGET) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return canReorientTarget();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean canReorientSource() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkSourceRequestValidity = this.checkSourceRequestValidity(it, link);
    _builder.append(_checkSourceRequestValidity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean canReorientTarget() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _checkTargetRequestValidity = this.checkTargetRequestValidity(it, link);
    _builder.append(_checkTargetRequestValidity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _checkLinkValidity(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _checkLinkValidity(final TypeLinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _NotInstance = this.xptMetaModel.NotInstance(xptSelf.getMetaClass(), "getElementToEdit()");
    _builder.append(_NotInstance);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _checkLinkValidity(final FeatureLinkModelFacet xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _NotInstance = this.xptMetaModel.NotInstance(xptSelf.getSourceType(), "referenceOwner");
    _builder.append(_NotInstance);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _checkSourceRequestValidity(final LinkModelFacet xptSelf, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _checkSourceRequestValidity(final TypeLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (!(");
    CharSequence _IsInstance = this.xptMetaModel.IsInstance(it.getSourceType(), "oldEnd");
    _builder.append(_IsInstance);
    _builder.append(" && ");
    CharSequence _IsInstance_1 = this.xptMetaModel.IsInstance(it.getSourceType(), "newEnd");
    _builder.append(_IsInstance_1);
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    CharSequence _extractFeatureWithCheck = this.extractFeatureWithCheck(it.getTargetMetaFeature(), "getLink()", it.getMetaClass(), "target", it.getTargetType());
    _builder.append(_extractFeatureWithCheck);
    _builder.newLineIfNotEmpty();
    CharSequence _checkLinkConstraint = this.checkLinkConstraint(it, link, "getNewSource()", "target");
    _builder.append(_checkLinkConstraint);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * When feature source is being reoriented oldEnd is the link target.
   */
  protected CharSequence _checkSourceRequestValidity(final FeatureLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (!(");
    CharSequence _IsInstance = this.xptMetaModel.IsInstance(it.getTargetType(), "oldEnd");
    _builder.append(_IsInstance);
    _builder.append(" && ");
    CharSequence _IsInstance_1 = this.xptMetaModel.IsInstance(it.getSourceType(), "newEnd");
    _builder.append(_IsInstance_1);
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("return ");
    CharSequence _canExistCall = this.xptBaseItemSemanticEditPolicy.canExistCall(it, link, "getNewSource()", "getOldTarget()");
    _builder.append(_canExistCall);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _checkTargetRequestValidity(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _checkTargetRequestValidity(final TypeLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (!(");
    CharSequence _IsInstance = this.xptMetaModel.IsInstance(it.getTargetType(), "oldEnd");
    _builder.append(_IsInstance);
    _builder.append(" && ");
    CharSequence _IsInstance_1 = this.xptMetaModel.IsInstance(it.getTargetType(), "newEnd");
    _builder.append(_IsInstance_1);
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    {
      GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
      boolean _tripleNotEquals = (_sourceMetaFeature != null);
      if (_tripleNotEquals) {
        CharSequence _extractFeatureWithCheck = this.extractFeatureWithCheck(it.getSourceMetaFeature(), "getLink()", it.getMetaClass(), "source", it.getSourceType());
        _builder.append(_extractFeatureWithCheck);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("if (!(");
        CharSequence _IsContainerInstance = this.xptMetaModel.IsContainerInstance(it.getSourceType(), "getLink()", it.getMetaClass());
        _builder.append(_IsContainerInstance);
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssignContainer = this.xptMetaModel.DeclareAndAssignContainer(it.getSourceType(), "source", "getLink()", it.getMetaClass());
        _builder.append(_DeclareAndAssignContainer);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _checkLinkConstraint = this.checkLinkConstraint(it, link, "source", "getNewTarget()");
    _builder.append(_checkLinkConstraint);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _checkTargetRequestValidity(final FeatureLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (!(");
    CharSequence _IsInstance = this.xptMetaModel.IsInstance(it.getTargetType(), "oldEnd");
    _builder.append(_IsInstance);
    _builder.append(" && ");
    CharSequence _IsInstance_1 = this.xptMetaModel.IsInstance(it.getTargetType(), "newEnd");
    _builder.append(_IsInstance_1);
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("return ");
    CharSequence _canExistCall = this.xptBaseItemSemanticEditPolicy.canExistCall(it, link, "getOldSource()", "getNewTarget()");
    _builder.append(_canExistCall);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence extractFeatureWithCheck(final GenFeature it, final String containerVar, final GenClass containerMetaClass, final String _var, final GenClass varMetaClass) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isMany = it.getEcoreFeature().isMany();
      if (_isMany) {
        _builder.append("if (");
        CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it, containerVar, containerMetaClass);
        _builder.append(_featureValue);
        _builder.append(".size() != 1) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssign2 = this.xptMetaModel.DeclareAndAssign2(varMetaClass, _var, containerVar, containerMetaClass, it, "get(0)", true);
        _builder.append(_DeclareAndAssign2);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(varMetaClass, _var, containerVar, containerMetaClass, it);
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence checkLinkConstraint(final TypeLinkModelFacet it, final GenLink link, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.append("if (!(");
        CharSequence _IsContainerInstance = this.xptMetaModel.IsContainerInstance(it.getContainmentMetaFeature().getGenClass(), "getLink()", it.getMetaClass());
        _builder.append(_IsContainerInstance);
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssignContainer = this.xptMetaModel.DeclareAndAssignContainer(it.getContainmentMetaFeature().getGenClass(), "container", "getLink()", it.getMetaClass());
        _builder.append(_DeclareAndAssignContainer);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _canExistCall = this.xptBaseItemSemanticEditPolicy.canExistCall(it, link, "container", "getLink()", sourceVar, targetVar);
    _builder.append(_canExistCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * Generates doExecuteWithResult() method for the command that reorients link.
   * Implementation should throw ExecutionException if it can't execute the command.
   */
  public CharSequence reorient(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!canExecute()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Invalid arguments in reorient link command\"); ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_SOURCE) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return reorientSource();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (reorientDirection == org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRequest.REORIENT_TARGET) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return reorientTarget();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("throw new IllegalStateException();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult reorientSource() throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _reorientSource = this.reorientSource(it);
    _builder.append(_reorientSource, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult reorientTarget() throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _reorientTarget = this.reorientTarget(it);
    _builder.append(_reorientTarget, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _reorientSource(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  /**
   * Shouldn't we change link container here?
   * [artem] especially when there's explicit childMetaFeature and
   * we changed source to another, but didn't change the container. Perhaps,
   * makes sense to deduceContainer() using new source?
   */
  protected CharSequence _reorientSource(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenFeature _xifexpression = null;
      GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
      boolean _tripleEquals = (_sourceMetaFeature == null);
      if (_tripleEquals) {
        _xifexpression = it.getContainmentMetaFeature();
      } else {
        _xifexpression = it.getSourceMetaFeature();
      }
      boolean _isChangeable = _xifexpression.getEcoreFeature().isChangeable();
      if (_isChangeable) {
        {
          GenFeature _sourceMetaFeature_1 = it.getSourceMetaFeature();
          boolean _tripleNotEquals = (_sourceMetaFeature_1 != null);
          if (_tripleNotEquals) {
            CharSequence _changeTarget = this.changeTarget(it.getSourceMetaFeature(), "getLink()", it.getMetaClass(), "getOldSource()", "getNewSource()");
            _builder.append(_changeTarget);
            _builder.newLineIfNotEmpty();
          } else {
            GenFeature _xifexpression_1 = null;
            boolean _hasExplicitChildFeature = this._utils_qvto.hasExplicitChildFeature(it);
            if (_hasExplicitChildFeature) {
              _xifexpression_1 = it.getChildMetaFeature();
            } else {
              _xifexpression_1 = it.getContainmentMetaFeature();
            }
            CharSequence _changeSource = this.changeSource(_xifexpression_1, "getLink()", 
              "getOldSource()", "getNewSource()", it.getSourceType());
            _builder.append(_changeSource);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(getLink());");
        _builder.newLine();
      } else {
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
      }
    }
    return _builder;
  }

  /**
   * When feature source is being reoriented oldEnd is the link target.
   */
  protected CharSequence _reorientSource(final FeatureLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isChangeable = it.getMetaFeature().getEcoreFeature().isChangeable();
      if (_isChangeable) {
        CharSequence _changeSource = this.changeSource(it.getMetaFeature(), "getOldTarget()", "getOldSource()", "getNewSource()", it.getSourceType());
        _builder.append(_changeSource);
        _builder.newLineIfNotEmpty();
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(referenceOwner);");
        _builder.newLine();
      } else {
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _reorientTarget(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _reorientTarget(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isChangeable = it.getTargetMetaFeature().getEcoreFeature().isChangeable();
      if (_isChangeable) {
        CharSequence _changeTarget = this.changeTarget(it.getTargetMetaFeature(), "getLink()", it.getMetaClass(), "getOldTarget()", "getNewTarget()");
        _builder.append(_changeTarget);
        _builder.newLineIfNotEmpty();
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(getLink());");
        _builder.newLine();
      } else {
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _reorientTarget(final FeatureLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isChangeable = it.getMetaFeature().getEcoreFeature().isChangeable();
      if (_isChangeable) {
        CharSequence _changeTarget = this.changeTarget(it.getMetaFeature(), "getOldSource()", it.getSourceType(), "getOldTarget()", "getNewTarget()");
        _builder.append(_changeTarget);
        _builder.newLineIfNotEmpty();
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(referenceOwner);");
        _builder.newLine();
      } else {
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
      }
    }
    return _builder;
  }

  /**
   * Replace old target with the new one in the source.
   */
  public CharSequence changeTarget(final GenFeature it, final String sourceVar, final GenClass sourceVarGenClass, final String oldTargetVar, final String newTargetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _replaceFeatureValue = this.xptMetaModel.replaceFeatureValue(it, sourceVar, sourceVarGenClass, oldTargetVar, newTargetVar);
    _builder.append(_replaceFeatureValue);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * Move target from old source to the new one.
   */
  public CharSequence changeSource(final GenFeature it, final String targetVar, final String oldSourceVar, final String newSourceVar, final GenClass sourceVarGenClass) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _moveFeatureValue = this.xptMetaModel.moveFeatureValue(it, oldSourceVar, newSourceVar, sourceVarGenClass, targetVar);
    _builder.append(_moveFeatureValue);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @XbaseGenerated
  public CharSequence linkAccessor(final LinkModelFacet xptSelf) {
    if (xptSelf instanceof TypeLinkModelFacet) {
      return _linkAccessor((TypeLinkModelFacet)xptSelf);
    } else if (xptSelf != null) {
      return _linkAccessor(xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }

  @XbaseGenerated
  public CharSequence oldSourceAccessor(final LinkModelFacet xptSelf) {
    if (xptSelf instanceof FeatureLinkModelFacet) {
      return _oldSourceAccessor((FeatureLinkModelFacet)xptSelf);
    } else if (xptSelf instanceof TypeLinkModelFacet) {
      return _oldSourceAccessor((TypeLinkModelFacet)xptSelf);
    } else if (xptSelf != null) {
      return _oldSourceAccessor(xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkLinkValidity(final LinkModelFacet xptSelf) {
    if (xptSelf instanceof FeatureLinkModelFacet) {
      return _checkLinkValidity((FeatureLinkModelFacet)xptSelf);
    } else if (xptSelf instanceof TypeLinkModelFacet) {
      return _checkLinkValidity((TypeLinkModelFacet)xptSelf);
    } else if (xptSelf != null) {
      return _checkLinkValidity(xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkSourceRequestValidity(final LinkModelFacet it, final GenLink link) {
    if (it instanceof FeatureLinkModelFacet) {
      return _checkSourceRequestValidity((FeatureLinkModelFacet)it, link);
    } else if (it instanceof TypeLinkModelFacet) {
      return _checkSourceRequestValidity((TypeLinkModelFacet)it, link);
    } else if (it != null) {
      return _checkSourceRequestValidity(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkTargetRequestValidity(final LinkModelFacet it, final GenLink link) {
    if (it instanceof FeatureLinkModelFacet) {
      return _checkTargetRequestValidity((FeatureLinkModelFacet)it, link);
    } else if (it instanceof TypeLinkModelFacet) {
      return _checkTargetRequestValidity((TypeLinkModelFacet)it, link);
    } else if (it != null) {
      return _checkTargetRequestValidity(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }

  @XbaseGenerated
  public CharSequence reorientSource(final LinkModelFacet it) {
    if (it instanceof FeatureLinkModelFacet) {
      return _reorientSource((FeatureLinkModelFacet)it);
    } else if (it instanceof TypeLinkModelFacet) {
      return _reorientSource((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _reorientSource(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence reorientTarget(final LinkModelFacet it) {
    if (it instanceof FeatureLinkModelFacet) {
      return _reorientTarget((FeatureLinkModelFacet)it);
    } else if (it instanceof TypeLinkModelFacet) {
      return _reorientTarget((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _reorientTarget(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
