/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.classification;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.junit.framework.classification.TestCategory;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

public enum ClassificationConfig implements Set<TestCategory>
{
    CI_TESTS_CONFIG(TestCategory.NotImplemented, TestCategory.InvalidTest, TestCategory.FailingTest, TestCategory.InteractiveTest, TestCategory.GeneratedTest),
    FAILING_TESTS_CONFIG(TestCategory.Standard, TestCategory.InteractiveTest, TestCategory.GeneratedTest, TestCategory.ExpensiveTest),
    LIGTHWEIGHT_TESTS_CONFIG(TestCategory.InteractiveTest, TestCategory.NotImplemented, TestCategory.FailingTest, TestCategory.InvalidTest, TestCategory.ExpensiveTest, TestCategory.GeneratedTest),
    GENERATED_TESTS_CONFIG(TestCategory.InteractiveTest, TestCategory.NotImplemented, TestCategory.FailingTest, TestCategory.InvalidTest, TestCategory.ExpensiveTest, TestCategory.Standard),
    FULL_CI_TESTS_CONFIG(TestCategory.InteractiveTest),
    FULL_TESTS_CONFIG(new TestCategory[0]);

    public static final Set<TestCategory> excludedTestCategories;
    private final Set<TestCategory> categories;

    static {
        excludedTestCategories = new HashSet<TestCategory>();
        ClassificationConfig.setTestsConfiguration(CI_TESTS_CONFIG);
        String[] stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.contains("-testConfig=")) {
                String configName = arg.substring("-testConfig=".length());
                ClassificationConfig testsConfig = ClassificationConfig.valueOf(configName);
                if (testsConfig == null) break;
                ClassificationConfig.setTestsConfiguration(testsConfig);
                break;
            }
            ++n2;
        }
    }

    private ClassificationConfig(TestCategory ... exclusions) {
        HashSet categories = Sets.newHashSet((Object[])TestCategory.values());
        categories.removeAll(Arrays.asList(exclusions));
        this.categories = ImmutableSet.copyOf((Collection)categories);
    }

    public static void setTestsConfiguration(Set<TestCategory> predefinedConfiguration) {
        ClassificationConfig.setIncludedTestCategories(predefinedConfiguration);
    }

    public static void setExcludedTestCategories(TestCategory ... categories) {
        ClassificationConfig.setExcludedTestCategories(Arrays.asList(categories));
    }

    public static void setIncludedTestCategories(TestCategory ... categories) {
        ClassificationConfig.setIncludedTestCategories(Arrays.asList(categories));
    }

    public static void setExcludedTestCategories(Collection<TestCategory> categoriesToExclude) {
        excludedTestCategories.clear();
        excludedTestCategories.addAll(categoriesToExclude);
    }

    public static void setIncludedTestCategories(Collection<TestCategory> categoriesToInclude) {
        excludedTestCategories.clear();
        List categoriesToExclude = ListHelper.asList((Object[])TestCategory.values());
        categoriesToExclude.removeAll(categoriesToInclude);
        excludedTestCategories.addAll(categoriesToExclude);
    }

    public static boolean shouldRun(Annotation[] annotations) {
        Annotation annotation;
        Object[] objectArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            annotation = objectArray[n2];
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (annotationClass == Ignore.class || ClassificationConfig.isExcluded(annotationClass)) {
                return false;
            }
            ++n2;
        }
        if (excludedTestCategories.contains((Object)TestCategory.Standard)) {
            objectArray = annotations;
            n = annotations.length;
            n2 = 0;
            while (n2 < n) {
                RunWith runWith;
                Class runner;
                annotation = objectArray[n2];
                if (RunWith.class.isInstance(annotation) && Suite.class.isAssignableFrom(runner = (runWith = (RunWith)annotation).value()) && !Parameterized.class.isAssignableFrom(runner)) {
                    return true;
                }
                ++n2;
            }
            objectArray = TestCategory.values();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Annotation testCategory = objectArray[n2];
                if (testCategory != TestCategory.Standard) {
                    Annotation[] annotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation annotation2 = annotationArray[n4];
                        if (((TestCategory)((Object)testCategory)).match(annotation2.annotationType())) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public static boolean isExcluded(Class<? extends Annotation> annotationClass) {
        for (TestCategory testCategory : excludedTestCategories) {
            if (!testCategory.match(annotationClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.categories.size();
    }

    @Override
    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.categories.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.categories.containsAll(c);
    }

    @Override
    public Iterator<TestCategory> iterator() {
        return this.categories.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.categories.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.categories.toArray(a);
    }

    @Override
    public boolean add(TestCategory e) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean addAll(Collection<? extends TestCategory> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }
}

