/**
 * Copyright (c) 2008, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Artem Tikhomirov (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package xpt.providers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Metrics_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;

  public Iterable<GenMetricRule> getNotationMetrics(final GenMetricContainer c) {
    return this.filterNotationMetricsByTargetType(c, GenNotationElementTarget.class);
  }

  public Iterable<GenMetricRule> getDiagramMetrics(final GenMetricContainer c) {
    return this.filterNotationMetricsByTargetType(c, GenDiagramElementTarget.class);
  }

  public Iterable<GenMetricRule> getDomainMetrics(final GenMetricContainer c) {
    return this.filterNotationMetricsByTargetType(c, GenDomainElementTarget.class);
  }

  protected Iterable<GenMetricRule> filterNotationMetricsByTargetType(final GenMetricContainer c, final Class<?> targetType) {
    final Function1<GenMetricRule, Boolean> _function = (GenMetricRule m) -> {
      return Boolean.valueOf(this._common_qvto.oclIsKindOf(m.getTarget(), targetType));
    };
    return IterableExtensions.<GenMetricRule>filter(c.getMetrics(), _function);
  }

  @MetaDef
  public String calcMethodName(final GenMetricRule m) {
    String _firstUpper = StringExtensions.toFirstUpper(CodeGenUtil.validJavaIdentifier(m.getKey()));
    return ("calc" + _firstUpper);
  }
}
