/**
 * Copyright (c) 2008, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	 Artem Tikhomirov (Borland) - initial API and implementation
 * 	 Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * 	 Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 * 	 Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package impl.actions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAction;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommandAction;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContextMenu;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContributionItem;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContributionManager;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomAction;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenGroupMarker;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMenuManager;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenSeparator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenToolBarManager;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.editparts.EditPartFactory;

@Singleton
@SuppressWarnings("all")
public class extensions {
  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private MenuAction_qvto _menuAction_qvto;

  @Inject
  private EditPartFactory xptEditPartFactory;

  @Inject
  private PredefinedAction predefinedAction;

  public CharSequence Main(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(1);
    _builder.append(_tripleSpace);
    _builder.append("<extension point=\"org.eclipse.ui.menus\" id=\"context-menus\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
    _builder.append(_xmlGeneratedTag);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_2);
    _builder.append("<!-- menuContribution locationURI=\"menu:org.eclipse.ui.main.menu?after=\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_3);
    _builder.append("</menuContribution>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_4);
    _builder.append("<menuContribution locationURI=\"toolbar:org.eclipse.ui.main.toolbar?after=\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_5);
    _builder.append("</menuContribution -->");
    _builder.newLineIfNotEmpty();
    {
      EList<GenContextMenu> _contextMenus = it.getContextMenus();
      for(final GenContextMenu cm : _contextMenus) {
        CharSequence _menuContribution = this.menuContribution(cm);
        _builder.append(_menuContribution);
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_6 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_6);
    _builder.append("</extension>");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _hasCommandsToContribute = this._menuAction_qvto.hasCommandsToContribute(it);
      if (_hasCommandsToContribute) {
        String _tripleSpace_7 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_7);
        _builder.append("<extension point=\"org.eclipse.ui.commands\" id=\"menu-commands\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_8 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_8);
        CharSequence _xmlGeneratedTag_1 = this._common.xmlGeneratedTag();
        _builder.append(_xmlGeneratedTag_1);
        _builder.newLineIfNotEmpty();
        String _tripleSpace_9 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_9);
        _builder.append("<category id=\"");
        String _iD = it.getEditor().getID();
        _builder.append(_iD);
        _builder.append("\" name=\"%cmdcategory.name\" description=\"%cmdcategory.desc\"/>");
        _builder.newLineIfNotEmpty();
        {
          EList<GenContextMenu> _contextMenus_1 = it.getContextMenus();
          for(final GenContextMenu cm_1 : _contextMenus_1) {
            String _tripleSpace_10 = this._common.tripleSpace(2);
            _builder.append(_tripleSpace_10);
            CharSequence _commandContribution = this.commandContribution(cm_1);
            _builder.append(_commandContribution);
            _builder.newLineIfNotEmpty();
          }
        }
        String _tripleSpace_11 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_11);
        _builder.append("</extension>");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _hasHandlersToContribute = this._menuAction_qvto.hasHandlersToContribute(it);
      if (_hasHandlersToContribute) {
        String _tripleSpace_12 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_12);
        _builder.append("<extension point=\"org.eclipse.ui.handlers\" id=\"menu-handlers\">");
        _builder.newLineIfNotEmpty();
        String _tripleSpace_13 = this._common.tripleSpace(2);
        _builder.append(_tripleSpace_13);
        CharSequence _xmlGeneratedTag_2 = this._common.xmlGeneratedTag();
        _builder.append(_xmlGeneratedTag_2);
        _builder.newLineIfNotEmpty();
        {
          EList<GenContextMenu> _contextMenus_2 = it.getContextMenus();
          for(final GenContextMenu cm_2 : _contextMenus_2) {
            CharSequence _handlerContribution = this.handlerContribution(cm_2);
            _builder.append(_handlerContribution);
            _builder.newLineIfNotEmpty();
          }
        }
        String _tripleSpace_14 = this._common.tripleSpace(1);
        _builder.append(_tripleSpace_14);
        _builder.append("</extension>");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    String _tripleSpace_15 = this._common.tripleSpace(1);
    _builder.append(_tripleSpace_15);
    _builder.append("<!-- optionally, specify keybindings -->");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence menuContribution(final GenContextMenu it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _menuContribution3 = this.menuContribution3(it, it, "popup:org.eclipse.gmf.runtime.diagram.ui.DiagramEditorContextMenu");
    _builder.append(_menuContribution3);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _menuContribution(final GenContributionManager it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(
      ("Abstract menuContribution for " + it));
    return _builder;
  }

  protected CharSequence _menuContribution(final GenMenuManager it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    String _iD = it.getID();
    String _plus = ("popup:" + _iD);
    CharSequence _menuContribution3 = this.menuContribution3(it, contextMenu, _plus);
    _builder.append(_menuContribution3);
    return _builder;
  }

  protected CharSequence _menuContribution(final GenToolBarManager it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    String _iD = it.getID();
    String _plus = ("toolbar:" + _iD);
    CharSequence _menuContribution3 = this.menuContribution3(it, contextMenu, _plus);
    _builder.append(_menuContribution3);
    return _builder;
  }

  public CharSequence menuContribution3(final GenContributionManager it, final GenContextMenu contextMenu, final String locationURI) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(2);
    _builder.append(_tripleSpace);
    _builder.append("<menuContribution locationURI=\"");
    _builder.append(locationURI);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    {
      EList<GenContributionItem> _items = it.getItems();
      for(final GenContributionItem i : _items) {
        CharSequence _menuEntry = this.menuEntry(i, contextMenu);
        _builder.append(_menuEntry);
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_1 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_1);
    _builder.append("</menuContribution>");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenContributionManager> _filter = Iterables.<GenContributionManager>filter(it.getItems(), GenContributionManager.class);
      for(final GenContributionManager m : _filter) {
        CharSequence _menuContribution = this.menuContribution(m, contextMenu);
        _builder.append(_menuContribution);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _commandContribution(final GenContributionManager it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<GenCustomAction> _filter = Iterables.<GenCustomAction>filter(it.getItems(), GenCustomAction.class);
      for(final GenCustomAction ca : _filter) {
        CharSequence _commandContribution = this.commandContribution(ca);
        _builder.append(_commandContribution);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenAction> _filter_1 = Iterables.<GenAction>filter(it.getItems(), GenAction.class);
      for(final GenAction a : _filter_1) {
        CharSequence _commandContribution_1 = this.commandContribution(a);
        _builder.append(_commandContribution_1);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenContributionManager> _filter_2 = Iterables.<GenContributionManager>filter(it.getItems(), GenContributionManager.class);
      for(final GenContributionManager cm : _filter_2) {
        CharSequence _commandContribution_2 = this.commandContribution(cm);
        _builder.append(_commandContribution_2);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _handlerContribution(final GenContributionManager it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<GenCustomAction> _filter = Iterables.<GenCustomAction>filter(it.getItems(), GenCustomAction.class);
      for(final GenCustomAction ca : _filter) {
        CharSequence _handlerContribution = this.handlerContribution(ca);
        _builder.append(_handlerContribution);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenContributionManager> _filter_1 = Iterables.<GenContributionManager>filter(it.getItems(), GenContributionManager.class);
      for(final GenContributionManager cm : _filter_1) {
        CharSequence _handlerContribution_1 = this.handlerContribution(cm);
        _builder.append(_handlerContribution_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _commandContribution(final GenCustomAction it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<command id=\"");
    CharSequence _commandIdentifier = this.commandIdentifier(it);
    _builder.append(_commandIdentifier);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("name=\"");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_1);
    _builder.append("categoryId=\"");
    String _iD = it.getOwner().getEditorGen().getEditor().getID();
    _builder.append(_iD);
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _commandContribution(final GenAction it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<command id=\"");
    CharSequence _commandIdentifier = this.commandIdentifier(it);
    _builder.append(_commandIdentifier);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("name=\"");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_1);
    _builder.append("categoryId=\"");
    String _iD = it.getOwner().getEditorGen().getEditor().getID();
    _builder.append(_iD);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_2);
    _builder.append("defaultHandler=\"");
    CharSequence _qualifiedClassName = this.predefinedAction.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _handlerContribution(final GenCustomAction it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(2);
    _builder.append(_tripleSpace);
    _builder.append("<handler");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("commandId=\"");
    CharSequence _commandIdentifier = this.commandIdentifier(it);
    _builder.append(_commandIdentifier);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("class=\"");
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("<enabledWhen>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_4 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_4);
    _builder.append("<with variable=\"activePartId\"><equals value=\"");
    String _iD = it.getOwner().getEditorGen().getEditor().getID();
    _builder.append(_iD);
    _builder.append("\"/></with>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_5);
    _builder.append("</enabledWhen>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_6 = this._common.tripleSpace(2);
    _builder.append(_tripleSpace_6);
    _builder.append("</handler>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _commandIdentifier(final GenCustomAction it) {
    StringConcatenation _builder = new StringConcatenation();
    String _iD = it.getOwner().getEditorGen().getPlugin().getID();
    _builder.append(_iD);
    _builder.append(".");
    String _lastSegment = this._common_qvto.lastSegment(
      it.getQualifiedClassName());
    _builder.append(_lastSegment);
    return _builder;
  }

  protected CharSequence _commandIdentifier(final GenAction it) {
    StringConcatenation _builder = new StringConcatenation();
    String _iD = it.getOwner().getEditorGen().getPlugin().getID();
    _builder.append(_iD);
    _builder.append(".");
    CharSequence _className = this.predefinedAction.className(it);
    _builder.append(_className);
    return _builder;
  }

  protected CharSequence _menuEntry(final GenContributionItem it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _menuEntry(final GenSeparator it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<separator name=");
    {
      String _groupName = it.getGroupName();
      boolean _tripleNotEquals = (_groupName != null);
      if (_tripleNotEquals) {
        _builder.append("\"");
        String _groupName_1 = it.getGroupName();
        _builder.append(_groupName_1);
        _builder.append("\"");
      } else {
        _builder.append("\"withoutname\"");
      }
    }
    _builder.append(" visible=\"true\"/>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _menuEntry(final GenGroupMarker it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<separator name=\"");
    String _groupName = it.getGroupName();
    _builder.append(_groupName);
    _builder.append("\"/>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _menuEntry(final GenCommandAction it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("<command commandId=\"");
    String _commandIdentifier = it.getCommandIdentifier();
    _builder.append(_commandIdentifier);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("<visibleWhen>");
    _builder.newLineIfNotEmpty();
    CharSequence _menuCondition = this.menuCondition(contextMenu);
    _builder.append(_menuCondition);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("</visibleWhen>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("</command>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _menuEntry(final GenCustomAction it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("<command commandId=\"");
    CharSequence _commandIdentifier = this.commandIdentifier(it);
    _builder.append(_commandIdentifier);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("<visibleWhen>");
    _builder.newLineIfNotEmpty();
    CharSequence _menuCondition = this.menuCondition(contextMenu);
    _builder.append(_menuCondition);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("</visibleWhen>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("</command>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _menuEntry(final GenAction it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("<command commandId=\"");
    CharSequence _commandIdentifier = this.commandIdentifier(it);
    _builder.append(_commandIdentifier);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("<visibleWhen>");
    _builder.newLineIfNotEmpty();
    CharSequence _menuCondition = this.menuCondition(contextMenu);
    _builder.append(_menuCondition);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("</visibleWhen>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("</command>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _menuEntry(final GenMenuManager it, final GenContextMenu contextMenu) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(3);
    _builder.append(_tripleSpace);
    _builder.append("<menu id=\"");
    String _iD = it.getID();
    _builder.append(_iD);
    _builder.append("\" label=\"");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append("\">");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_1);
    _builder.append("<visibleWhen>");
    _builder.newLineIfNotEmpty();
    CharSequence _menuCondition = this.menuCondition(contextMenu);
    _builder.append(_menuCondition);
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(4);
    _builder.append(_tripleSpace_2);
    _builder.append("</visibleWhen>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_3 = this._common.tripleSpace(3);
    _builder.append(_tripleSpace_3);
    _builder.append("</menu>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence menuCondition(final GenContextMenu it) {
    StringConcatenation _builder = new StringConcatenation();
    String _tripleSpace = this._common.tripleSpace(5);
    _builder.append(_tripleSpace);
    _builder.append("<and>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_1 = this._common.tripleSpace(6);
    _builder.append(_tripleSpace_1);
    _builder.append("<with variable=\"activePartId\"><equals value=\"");
    String _iD = it.getEditorGen().getEditor().getID();
    _builder.append(_iD);
    _builder.append("\"/></with>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_2 = this._common.tripleSpace(6);
    _builder.append(_tripleSpace_2);
    _builder.append("<with variable=\"selection\"><iterate ifEmpty=\"false\">");
    {
      int _size = it.getContext().size();
      boolean _greaterThan = (_size > 1);
      if (_greaterThan) {
        _builder.append("<or>");
      }
    }
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    {
      EList<GenCommonBase> _context = it.getContext();
      for(final GenCommonBase de : _context) {
        String _tripleSpace_3 = this._common.tripleSpace(7);
        _builder.append(_tripleSpace_3);
        _builder.append("<instanceof value=\"");
        CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(de);
        _builder.append(_editPartQualifiedClassName);
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
      }
    }
    String _tripleSpace_4 = this._common.tripleSpace(6);
    _builder.append(_tripleSpace_4);
    {
      int _size_1 = it.getContext().size();
      boolean _greaterThan_1 = (_size_1 > 1);
      if (_greaterThan_1) {
        _builder.append("</or>");
      }
    }
    _builder.append("</iterate></with>");
    _builder.newLineIfNotEmpty();
    String _tripleSpace_5 = this._common.tripleSpace(5);
    _builder.append(_tripleSpace_5);
    _builder.append("</and>");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public CharSequence i18n(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasCommandsToContribute = this._menuAction_qvto.hasCommandsToContribute(it);
      if (_hasCommandsToContribute) {
        _builder.append("# Commands and menu actions");
        _builder.newLine();
        _builder.append("cmdcategory.name=");
        String _modelID = it.getModelID();
        _builder.append(_modelID);
        _builder.append(" Editor Commands");
        _builder.newLineIfNotEmpty();
        _builder.append("cmdcategory.desc=");
        String _modelID_1 = it.getModelID();
        _builder.append(_modelID_1);
        _builder.append(" Editor Commands");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence menuContribution(final GenContributionManager it, final GenContextMenu contextMenu) {
    if (it instanceof GenMenuManager) {
      return _menuContribution((GenMenuManager)it, contextMenu);
    } else if (it instanceof GenToolBarManager) {
      return _menuContribution((GenToolBarManager)it, contextMenu);
    } else if (it != null) {
      return _menuContribution(it, contextMenu);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, contextMenu).toString());
    }
  }

  public CharSequence commandContribution(final EObject it) {
    if (it instanceof GenAction) {
      return _commandContribution((GenAction)it);
    } else if (it instanceof GenCustomAction) {
      return _commandContribution((GenCustomAction)it);
    } else if (it instanceof GenContributionManager) {
      return _commandContribution((GenContributionManager)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence handlerContribution(final EObject it) {
    if (it instanceof GenCustomAction) {
      return _handlerContribution((GenCustomAction)it);
    } else if (it instanceof GenContributionManager) {
      return _handlerContribution((GenContributionManager)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence commandIdentifier(final GenContributionItem it) {
    if (it instanceof GenAction) {
      return _commandIdentifier((GenAction)it);
    } else if (it instanceof GenCustomAction) {
      return _commandIdentifier((GenCustomAction)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence menuEntry(final GenContributionItem it, final GenContextMenu contextMenu) {
    if (it instanceof GenAction) {
      return _menuEntry((GenAction)it, contextMenu);
    } else if (it instanceof GenCommandAction) {
      return _menuEntry((GenCommandAction)it, contextMenu);
    } else if (it instanceof GenCustomAction) {
      return _menuEntry((GenCustomAction)it, contextMenu);
    } else if (it instanceof GenGroupMarker) {
      return _menuEntry((GenGroupMarker)it, contextMenu);
    } else if (it instanceof GenMenuManager) {
      return _menuEntry((GenMenuManager)it, contextMenu);
    } else if (it instanceof GenSeparator) {
      return _menuEntry((GenSeparator)it, contextMenu);
    } else if (it != null) {
      return _menuEntry(it, contextMenu);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, contextMenu).toString());
    }
  }
}
