/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DateParser;

public class TimeParser
extends DateParser {
    public TimeParser() {
        this(DateFormat.getTimeInstance(3));
    }

    public TimeParser(DateFormat dateFormat) {
        super(dateFormat);
    }

    public Class getType() {
        return Time.class;
    }

    public boolean canParse(String val) {
        try {
            this.parseTime(val);
            return true;
        }
        catch (DataParseException e) {
            return false;
        }
    }

    public Object parse(String val) throws DataParseException {
        return this.parseTime(val);
    }

    public Time parseTime(String text) throws DataParseException {
        Date d1;
        this.m_pos.setErrorIndex(0);
        this.m_pos.setIndex(0);
        Time t = null;
        try {
            t = Time.valueOf(text);
            this.m_pos.setIndex(text.length());
        }
        catch (IllegalArgumentException e) {
            t = null;
        }
        if (t == null && (d1 = this.m_dfmt.parse(text, this.m_pos)) != null) {
            t = new Time(d1.getTime());
        }
        if (t == null || this.m_pos.getIndex() < text.length()) {
            throw new DataParseException("Could not parse Date: " + text);
        }
        return t;
    }
}

