/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.util.ResourceSetConfigurer;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.assembly.impl.AssemblyImpl;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.AssemblyDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.LMViewProvider;
import org.eclipse.emf.cdo.lm.internal.client.SystemDescriptor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.ViewResourceSetConfigurer;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;

public class LMResourceSetConfigurer
extends ViewResourceSetConfigurer {
    public static final String TYPE = "lm";
    private static final ThreadLocal<Boolean> BYPASS_CONFIGURE = new ThreadLocal();

    protected Result configureViewResourceSet(ResourceSet resourceSet, CDOView view) {
        if (BYPASS_CONFIGURE.get() == Boolean.TRUE) {
            return null;
        }
        CDOSession session = view.getSession();
        ISystemDescriptor systemDescriptor = SystemDescriptor.getSystemDescriptor(session);
        if (systemDescriptor == null) {
            return null;
        }
        String moduleName = SystemDescriptor.getModuleName(session);
        if (moduleName == null) {
            return null;
        }
        return this.configureViewResourceSet(resourceSet, view, systemDescriptor);
    }

    private Result configureViewResourceSet(ResourceSet resourceSet, CDOView view, ISystemDescriptor systemDescriptor) {
        final CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)view);
        if (checkout != null) {
            final CheckoutResult result = new CheckoutResult(resourceSet, systemDescriptor);
            IAssemblyDescriptor assemblyDescriptor = IAssemblyManager.INSTANCE.getDescriptor(checkout);
            if (assemblyDescriptor != null) {
                result.setAssemblyDescriptor(assemblyDescriptor);
            } else {
                IAssemblyManager.INSTANCE.addListener((IListener)new ContainerEventAdapter<IAssemblyDescriptor>(){

                    protected void onAdded(IContainer<IAssemblyDescriptor> container, IAssemblyDescriptor assemblyDescriptor) {
                        if (assemblyDescriptor.getCheckout() == checkout) {
                            result.setAssemblyDescriptor(assemblyDescriptor);
                        }
                    }
                });
            }
            return result;
        }
        try {
            Map<String, CDOView> moduleViews = systemDescriptor.configureModuleResourceSet(view);
            return new StandaloneResult(resourceSet, systemDescriptor, moduleViews);
        }
        catch (ISystemDescriptor.ResolutionException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static void bypassConfigure(boolean on) {
        if (on) {
            BYPASS_CONFIGURE.set(Boolean.TRUE);
        } else {
            BYPASS_CONFIGURE.remove();
        }
    }

    public static final class CheckoutResult
    extends Result {
        private IAssemblyDescriptor assemblyDescriptor;

        public CheckoutResult(ResourceSet resourceSet, ISystemDescriptor systemDescriptor) {
            super(resourceSet, systemDescriptor);
        }

        public void setAssemblyDescriptor(IAssemblyDescriptor assemblyDescriptor) {
            this.assemblyDescriptor = assemblyDescriptor;
            ((AssemblyDescriptor)assemblyDescriptor).addResourceSet(this);
            AssemblyImpl assembly = (AssemblyImpl)this.getAssembly();
            assembly.forEachDependency(this::addDependencyView);
            CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)this.getResourceSet());
            if (viewSet != null) {
                assembly.associateView(viewSet.getViews()[0]);
            }
            CDOCheckout checkout = this.getCheckout();
            checkout.waitUntilPrefetched();
        }

        public Assembly getAssembly() {
            return this.assemblyDescriptor.getAssembly();
        }

        public CDOCheckout getCheckout() {
            return this.assemblyDescriptor.getCheckout();
        }

        public void reconfigure(List<BranchPointDelta> deltas) {
            for (BranchPointDelta delta : deltas) {
                AssemblyModule module = delta.getModule();
                if (module.isRoot()) continue;
                switch (delta.getKind()) {
                    case ADDITION: {
                        this.addDependencyView(module);
                        break;
                    }
                    case REMOVAL: {
                        this.removeDependencyView(module);
                        break;
                    }
                    case MODIFICATION: {
                        this.modifyDependencyView(module, delta.getNewBranchPoint());
                    }
                }
            }
            CDOCheckout checkout = this.getCheckout();
            checkout.waitUntilPrefetched();
        }

        @Override
        public Exception deactivate() {
            try {
                super.deactivate();
            }
            finally {
                ((AssemblyDescriptor)this.assemblyDescriptor).removeResourceSet(this);
            }
            return null;
        }

        public static final class BranchPointDelta {
            private final AssemblyModule module;
            private final CDOBranchPointRef oldBranchPoint;
            private final CDOBranchPointRef newBranchPoint;

            public BranchPointDelta(AssemblyModule module, CDOBranchPointRef oldBranchPoint, CDOBranchPointRef newBranchPoint) {
                this.module = module;
                this.oldBranchPoint = oldBranchPoint;
                this.newBranchPoint = newBranchPoint;
            }

            public AssemblyModule getModule() {
                return this.module;
            }

            public CDOBranchPointRef getOldBranchPoint() {
                return this.oldBranchPoint;
            }

            public CDOBranchPointRef getNewBranchPoint() {
                return this.newBranchPoint;
            }

            public Kind getKind() {
                if (this.oldBranchPoint == null) {
                    return Kind.ADDITION;
                }
                if (this.newBranchPoint == null) {
                    return Kind.REMOVAL;
                }
                return Kind.MODIFICATION;
            }

            public String toString() {
                return "BranchPointDelta[module=" + String.valueOf(this.module) + ", oldBranchPoint=" + String.valueOf(this.oldBranchPoint) + ", newBranchPoint=" + String.valueOf(this.newBranchPoint) + "]";
            }

            public static enum Kind {
                ADDITION,
                REMOVAL,
                MODIFICATION;

            }
        }
    }

    public static class Factory
    extends ResourceSetConfigurer.Factory {
        public Factory() {
            super(LMResourceSetConfigurer.TYPE);
        }

        public LMResourceSetConfigurer create(String description) throws ProductCreationException {
            return new LMResourceSetConfigurer();
        }
    }

    public static abstract class Result
    implements IDeactivateable {
        private final ResourceSet resourceSet;
        private final ISystemDescriptor systemDescriptor;
        private final Map<String, CDOView> dependencyViews = new HashMap<String, CDOView>();

        public Result(ResourceSet resourceSet, ISystemDescriptor systemDescriptor) {
            this.resourceSet = resourceSet;
            this.systemDescriptor = systemDescriptor;
        }

        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        public CDOView getDependencyView(AssemblyModule assemblyModule) {
            return this.getDependencyView(assemblyModule.getName());
        }

        public CDOView getDependencyView(String moduleName) {
            return this.dependencyViews.get(moduleName);
        }

        public Exception deactivate() {
            Exception exception = null;
            for (CDOView view : this.dependencyViews.values()) {
                try {
                    view.close();
                }
                catch (Exception ex) {
                    if (exception != null) continue;
                    exception = ex;
                }
            }
            this.dependencyViews.clear();
            return exception;
        }

        protected final void registerDependencyView(String moduleName, CDOView view) {
            this.dependencyViews.put(moduleName, view);
        }

        protected final CDOView addDependencyView(AssemblyModule module) {
            CDOView view = Result.openDependencyView(this.systemDescriptor, module, this.resourceSet);
            if (view != null) {
                this.registerDependencyView(module.getName(), view);
            }
            return view;
        }

        protected final CDOView removeDependencyView(AssemblyModule module) {
            CDOView view = this.dependencyViews.remove(module.getName());
            if (view != null) {
                view.close();
            }
            return view;
        }

        protected final CDOView modifyDependencyView(AssemblyModule module, CDOBranchPointRef branchPointRef) {
            CDOView view = this.getDependencyView(module.getName());
            if (view != null) {
                CDOBranchPoint branchPoint = branchPointRef.resolve(view.getSession().getBranchManager());
                view.setBranchPoint(branchPoint);
            }
            return view;
        }

        public static Result of(ResourceSet resourceSet) {
            ResourceSetConfigurer.Registry.ResourceSetConfiguration resourceSetConfiguration = ResourceSetConfigurer.Registry.ResourceSetConfiguration.of((ResourceSet)resourceSet);
            if (resourceSetConfiguration == null) {
                return null;
            }
            Map configurerResults = resourceSetConfiguration.getConfigurerResults();
            return (Result)configurerResults.get(LMResourceSetConfigurer.TYPE);
        }

        public static CDOView openDependencyView(ISystemDescriptor systemDescriptor, AssemblyModule module, ResourceSet resourceSet) {
            LMResourceSetConfigurer.bypassConfigure(true);
            try {
                URI viewURI = LMViewProvider.createViewURI(module);
                CDOView cDOView = CDOUtil.getView((ResourceSet)resourceSet, (URI)viewURI);
                return cDOView;
            }
            finally {
                LMResourceSetConfigurer.bypassConfigure(false);
            }
        }
    }

    public static final class StandaloneResult
    extends Result {
        public StandaloneResult(ResourceSet resourceSet, ISystemDescriptor systemDescriptor, Map<String, CDOView> moduleViews) {
            super(resourceSet, systemDescriptor);
            moduleViews.forEach(this::registerDependencyView);
        }
    }
}

