/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.PrintStream;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStore;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.model1.Supplier;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

public class MongoDBInitialTest
extends AbstractCDOTest {
    public void testGetContentsClearedCache() throws Exception {
        MongoDBInitialTest.msg((Object)"Opening session");
        CDOSession session = this.openSession();
        MongoDBInitialTest.msg((Object)"Opening transaction");
        CDOTransaction transaction = session.openTransaction();
        MongoDBInitialTest.msg((Object)"Creating resource");
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        MongoDBInitialTest.msg((Object)"Creating supplier");
        Supplier supplier = this.getModel1Factory().createSupplier();
        MongoDBInitialTest.msg((Object)"Setting name");
        supplier.setName("Stepper");
        MongoDBInitialTest.msg((Object)"Adding supplier");
        resource.getContents().add((Object)supplier);
        MongoDBInitialTest.msg((Object)"Committing");
        transaction.commit();
        session.close();
        this.clearCache((CDORevisionManager)this.getRepository().getRevisionManager());
        MongoDBInitialTest.msg((Object)"Opening session");
        session = this.openSession();
        MongoDBInitialTest.msg((Object)"Opening transaction");
        transaction = session.openTransaction();
        MongoDBInitialTest.msg((Object)"Getting resource");
        resource = transaction.getResource(this.getResourcePath("/test1"));
        MongoDBInitialTest.msg((Object)"Getting contents");
        EList contents = resource.getContents();
        MongoDBInitialTest.assertNotNull((Object)contents);
        Supplier supplier2 = (Supplier)contents.get(0);
        String name = supplier2.getName();
        MongoDBInitialTest.assertEquals((String)"Stepper", (String)name);
    }

    public void testGetResourceClearedCache() throws Exception {
        Supplier supplier = this.getModel1Factory().createSupplier();
        supplier.setName("Stepper");
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/test1"));
        resource.getContents().add((Object)supplier);
        transaction.commit();
        this.clearCache((CDORevisionManager)this.getRepository().getRevisionManager());
        transaction = session.openTransaction();
        MongoDBInitialTest.msg((Object)"Getting resource");
        resource = transaction.getResource(this.getResourcePath("/test1"), true);
        MongoDBInitialTest.assertNotNull((Object)resource);
        MongoDBInitialTest.assertEquals((Object)URI.createURI((String)("cdo://" + session.getRepositoryInfo().getUUID() + this.getResourcePath("/test1"))), (Object)resource.getURI());
        MongoDBInitialTest.assertEquals((Object)transaction.getResourceSet(), (Object)resource.getResourceSet());
        MongoDBInitialTest.assertEquals((int)1, (int)transaction.getResourceSet().getResources().size());
        MongoDBInitialTest.assertEquals((Object)CDOState.CLEAN, (Object)resource.cdoState());
        MongoDBInitialTest.assertEquals((Object)transaction, (Object)resource.cdoView());
        MongoDBInitialTest.assertNotNull((Object)resource.cdoRevision());
    }

    protected void query(DBObject query) {
        System.err.println();
        System.err.println("Query:");
        this.showDocument(query, "");
        System.err.println();
        System.err.println("Results:");
        MongoDBStore store = (MongoDBStore)this.getRepository().getStore();
        DBCollection collection = store.getCommits().getCollection();
        DBCursor cursor = collection.find(query);
        int i = 0;
        while (cursor.hasNext()) {
            System.out.println(++i + " = ");
            this.showDocument(cursor.next(), "    ");
        }
        ConcurrencyUtil.sleep((long)1000000L);
    }

    protected void showDocument(DBObject doc, String level) {
        PrintStream pout = System.out;
        for (String key : doc.keySet()) {
            pout.print(level);
            pout.print(key);
            pout.print(" = ");
            Object value = doc.get(key);
            if (value instanceof DBObject) {
                DBObject child = (DBObject)value;
                pout.println();
                this.showDocument(child, level + "    ");
                continue;
            }
            if (value instanceof String) {
                pout.print("\"");
            }
            pout.print(value);
            if (value instanceof String) {
                pout.print("\"");
            }
            pout.println();
        }
    }
}

