/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common;

import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.net4j.util.event.IEvent;

public interface CDOCommonRepository
extends CDOTimeProvider,
IAdaptable {
    public String getName();

    public String getUUID();

    default public Mode getMode() {
        return this.isSupportingBranches() ? Mode.BRANCHING : (this.isSupportingAudits() ? Mode.AUDITING : Mode.NORMAL);
    }

    public Type getType();

    public State getState();

    public long getCreationTime();

    public String getStoreType();

    public Set<CDOID.ObjectType> getObjectIDTypes();

    public IDGenerationLocation getIDGenerationLocation();

    public String getLobDigestAlgorithm();

    public CommitInfoStorage getCommitInfoStorage();

    public CDOID getRootResourceID();

    public boolean isAuthenticating();

    public boolean isSupportingLoginPeeks();

    public boolean isSupportingAudits();

    public boolean isSupportingBranches();

    public boolean isSupportingUnits();

    @Deprecated
    public boolean isSupportingEcore();

    public boolean isSerializingCommits();

    public boolean isEnsuringReferentialIntegrity();

    public boolean isAuthorizingOperations();

    public boolean waitWhileInitial(IProgressMonitor var1);

    public static enum CommitInfoStorage {
        NO,
        YES,
        WITH_MERGE_SOURCE;

    }

    public static enum IDGenerationLocation {
        STORE,
        CLIENT;

    }

    public static enum ListOrdering {
        ORDERED{

            @Override
            public boolean isOrdered(EReference reference) {
                return true;
            }
        }
        ,
        UNORDERED{

            @Override
            public boolean isOrdered(EReference reference) {
                return false;
            }
        }
        ,
        BY_ECORE{

            @Override
            public boolean isOrdered(EReference reference) {
                return reference.isOrdered();
            }
        }
        ,
        BY_ANNOTATED_ECORE{

            @Override
            public boolean isOrdered(EReference reference) {
                return reference.isOrdered();
            }
        };


        public abstract boolean isOrdered(EReference var1);
    }

    public static enum Mode {
        NORMAL{

            @Override
            public boolean isSupportingAudits() {
                return false;
            }

            @Override
            public boolean isSupportingBranches() {
                return false;
            }
        }
        ,
        AUDITING{

            @Override
            public boolean isSupportingAudits() {
                return true;
            }

            @Override
            public boolean isSupportingBranches() {
                return false;
            }
        }
        ,
        BRANCHING{

            @Override
            public boolean isSupportingAudits() {
                return true;
            }

            @Override
            public boolean isSupportingBranches() {
                return true;
            }
        };


        public abstract boolean isSupportingAudits();

        public abstract boolean isSupportingBranches();

        public static Mode parse(String name) {
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mode mode = modeArray[n2];
                if (mode.name().equalsIgnoreCase(name)) {
                    return mode;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum State {
        INITIAL,
        OFFLINE,
        SYNCING,
        ONLINE;


        public boolean isConnected() {
            return this == SYNCING || this == ONLINE;
        }
    }

    public static interface StateChangedEvent
    extends IEvent {
        public State getOldState();

        public State getNewState();
    }

    public static enum Type {
        MASTER,
        BACKUP,
        CLONE;

    }

    public static interface TypeChangedEvent
    extends IEvent {
        public Type getOldType();

        public Type getNewType();
    }
}

