/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class XactXAResourceManager
implements XAResourceManager {
    private TransactionTable transaction_table;
    private RawStoreFactory rsf;

    public XactXAResourceManager(RawStoreFactory rsf, TransactionTable tt) {
        this.rsf = rsf;
        this.transaction_table = tt;
    }

    @Override
    public void commit(ContextManager cm, Xid xid, boolean onePhase) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        if (rawtran == null) {
            throw StandardException.newException("XSAX0.S", new Object[0]);
        }
        SanityManager.ASSERT(rawtran != null);
        SanityManager.ASSERT(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        rawtran.xa_commit(onePhase);
    }

    @Override
    public ContextManager find(Xid xid) {
        return this.transaction_table.findTransactionContextByGlobalId(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()));
    }

    @Override
    public void forget(ContextManager cm, Xid xid) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        SanityManager.ASSERT(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        throw StandardException.newException("XSAX0.S", new Object[0]);
    }

    @Override
    public Xid[] recover(int flags) throws StandardException {
        Xid[] ret_xid_list;
        if ((flags & 0x1000000) != 0) {
            final ArrayList xid_list = new ArrayList();
            TransactionTable.EntryVisitor visitor = new TransactionTable.EntryVisitor(){

                @Override
                public boolean visit(TransactionTableEntry entry) {
                    Xact xact = entry.getXact();
                    if (xact.isPrepared()) {
                        GlobalXactId xa_id = (GlobalXactId)xact.getGlobalId();
                        xid_list.add(new XAXactId(xa_id.getFormat_Id(), xa_id.getGlobalTransactionId(), xa_id.getBranchQualifier()));
                    }
                    return true;
                }
            };
            this.transaction_table.visitEntries(visitor);
            ret_xid_list = new XAXactId[xid_list.size()];
            ret_xid_list = (XAXactId[])xid_list.toArray(ret_xid_list);
        } else {
            ret_xid_list = new XAXactId[]{};
        }
        return ret_xid_list;
    }

    @Override
    public void rollback(ContextManager cm, Xid xid) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        if (rawtran == null) {
            throw StandardException.newException("XSAX0.S", new Object[0]);
        }
        SanityManager.ASSERT(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        rawtran.xa_rollback();
    }
}

