/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.optimizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionInterner;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.db.IndexWriter;
import org.eclipse.emf.cdo.server.internal.lissome.file.Vob;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.Optimizer;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.OptimizerTask;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.ecore.EClass;

public class CommitTransactionTask
implements OptimizerTask {
    protected final CDOBranchPoint branchPoint;
    protected final long previousTimeStamp;
    protected final String userID;
    protected final String commitComment;
    protected final InternalCDOPackageUnit[] newPackageUnits;
    protected final InternalCDORevision[] newObjects;
    protected final InternalCDORevisionDelta[] dirtyObjectDeltas;
    protected final InternalCDORevision[] dirtyObjects;
    protected final CDOID[] detachedObjects;
    protected final Map<CDOID, EClass> detachedObjectTypes;
    protected final CDOBranchVersion[] detachedObjectVersions;
    protected final List<byte[]> lobs = new ArrayList<byte[]>();
    private long newCommitPointer;
    private long newPackageUnitPointer;
    private Map<CDORevision, Long> newObjectPointers = new HashMap<CDORevision, Long>();
    private InternalCDORevision[] detachedRevisions;

    public CommitTransactionTask(InternalCommitContext context) {
        this.branchPoint = context.getBranchPoint();
        this.previousTimeStamp = context.getPreviousTimeStamp();
        this.userID = context.getUserID();
        this.commitComment = context.getCommitComment();
        this.newPackageUnits = context.getNewPackageUnits();
        this.newObjects = context.getNewObjects();
        this.dirtyObjectDeltas = context.getDirtyObjectDeltas();
        this.dirtyObjects = context.getDirtyObjects();
        this.detachedObjects = context.getDetachedObjects();
        this.detachedObjectTypes = context.getDetachedObjectTypes();
        this.detachedObjectVersions = context.getDetachedObjectVersions();
    }

    public CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    public boolean isValid(CDOBranchPoint branchPoint) {
        long timeStamp = branchPoint.getTimeStamp();
        if (timeStamp != 0L && timeStamp < this.branchPoint.getTimeStamp()) {
            return false;
        }
        return branchPoint.getBranch() == this.branchPoint.getBranch();
    }

    public void setDetachedRevisions(InternalCDORevision[] detachedRevisions) {
        this.detachedRevisions = detachedRevisions;
    }

    public long getNewCommitPointer() {
        return this.newCommitPointer;
    }

    public void setNewCommitPointer(long newCommitPointer) {
        this.newCommitPointer = newCommitPointer;
    }

    public long getNewPackageUnitPointer() {
        return this.newPackageUnitPointer;
    }

    public Map<CDORevision, Long> getNewObjectPointers() {
        return this.newObjectPointers;
    }

    public List<byte[]> getLobs() {
        return this.lobs;
    }

    public CDOCommitInfo createCommitInfo(InternalCDOCommitInfoManager commitInfoManager) {
        CDOBranch branch = this.branchPoint.getBranch();
        long timeStamp = this.branchPoint.getTimeStamp();
        return commitInfoManager.createCommitInfo(branch, timeStamp, this.previousTimeStamp, this.userID, this.commitComment, null, null);
    }

    @Override
    public void execute(Optimizer optimizer) throws IOException {
        LissomeStore store = optimizer.getStore();
        IndexWriter indexWriter = store.getIndex().getWriter();
        Vob vob = store.getVob();
        indexWriter.addCommitInfo(this.branchPoint, this.newCommitPointer);
        this.addObjects(indexWriter);
        this.updateObjects(indexWriter, vob);
        this.detachObjects(indexWriter, vob);
        indexWriter.commit();
    }

    protected void addObjects(IndexWriter indexWriter) {
        if (this.newObjects.length != 0) {
            long[] pointers = new long[this.newObjects.length];
            int i = 0;
            while (i < this.newObjects.length) {
                InternalCDORevision revision = this.newObjects[i];
                pointers[i] = -this.newObjectPointers.get(revision).longValue();
                ++i;
            }
            indexWriter.addObjects(this.newObjects, pointers);
        }
    }

    protected void updateObjects(IndexWriter indexWriter, Vob vob) {
        if (this.dirtyObjects.length != 0) {
            long[] pointers = new long[this.dirtyObjects.length];
            int i = 0;
            while (i < this.dirtyObjects.length) {
                InternalCDORevision revision = this.dirtyObjects[i];
                pointers[i] = vob.addRevision((CDORevision)revision);
                ++i;
            }
            indexWriter.updateObjects(this.dirtyObjects, pointers);
        }
    }

    protected void detachObjects(IndexWriter indexWriter, Vob vob) {
        if (this.detachedObjects.length != 0) {
            long[] pointers = new long[this.detachedRevisions.length];
            int i = 0;
            while (i < this.detachedRevisions.length) {
                InternalCDORevision revision = this.detachedRevisions[i];
                pointers[i] = vob.addRevision((CDORevision)revision);
                ++i;
            }
            indexWriter.detachObjects(this.branchPoint, this.detachedObjects, this.detachedRevisions, pointers);
        }
    }

    public void cacheRevisions(CDORevisionInterner interner) {
        int i = 0;
        while (i < this.newObjects.length) {
            this.newObjects[i] = (InternalCDORevision)interner.internRevision((CDORevision)this.newObjects[i]);
            ++i;
        }
        i = 0;
        while (i < this.dirtyObjects.length) {
            this.dirtyObjects[i] = (InternalCDORevision)interner.internRevision((CDORevision)this.dirtyObjects[i]);
            ++i;
        }
        i = 0;
        while (i < this.detachedObjects.length) {
            CDOID id = this.detachedObjects[i];
            EClass eClass = this.detachedObjectTypes.get(id);
            CDOBranchVersion branchVersion = this.detachedObjectVersions[i];
            CDOBranch branch = branchVersion.getBranch();
            int version = branchVersion.getVersion();
            long timeStamp = this.branchPoint.getTimeStamp();
            DetachedCDORevision revision = new DetachedCDORevision(eClass, id, branch, version, timeStamp);
            interner.internRevision((CDORevision)revision);
            ++i;
        }
    }
}

