/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Arrays;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectUUIDImpl
extends AbstractCDOID
implements InternalCDOIDObject {
    private static final long serialVersionUID = 1L;
    private static final UUIDInterner INTERNER = new UUIDInterner();
    private final byte[] value;

    private CDOIDObjectUUIDImpl(byte[] value) {
        CheckUtil.checkArg((Object)value, (String)"Null not allowed");
        this.value = value;
    }

    private CDOIDObjectUUIDImpl() {
        this.value = null;
    }

    public byte[] getByteArrayValue() {
        return this.value;
    }

    @Override
    public void write(CDODataOutput out) throws IOException {
        out.writeByteArray(this.value);
    }

    @Override
    public String toURIFragment() {
        return CDOIDUtil.encodeUUID(this.value);
    }

    @Override
    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    @Override
    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.UUID;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public int hashCode() {
        return CDOIDObjectUUIDImpl.getHashCode(this.value);
    }

    @Override
    protected int doCompareTo(CDOID o) throws ClassCastException {
        byte[] thatValue = ((CDOIDObjectUUIDImpl)o).value;
        int minLength = Math.min(this.value.length, thatValue.length);
        int i = 0;
        while (i < minLength) {
            byte thisByte = this.value[i];
            byte thatByte = thatValue[i];
            int result = Byte.compare(thisByte, thatByte);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return Integer.compare(this.value.length, thatValue.length);
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectUUIDImpl.create(this.value);
    }

    private static int getHashCode(byte[] value) {
        return Arrays.hashCode(value);
    }

    public static CDOIDObjectUUIDImpl create(byte[] value) {
        return INTERNER.intern(value);
    }

    public static CDOIDObjectUUIDImpl create(CDODataInput in) throws IOException {
        byte[] value = in.readByteArray();
        return CDOIDObjectUUIDImpl.create(value);
    }

    public static CDOIDObjectUUIDImpl create(String fragmentPart) {
        byte[] value = CDOIDUtil.decodeUUID(fragmentPart);
        return CDOIDObjectUUIDImpl.create(value);
    }

    /* synthetic */ CDOIDObjectUUIDImpl(byte[] byArray, CDOIDObjectUUIDImpl cDOIDObjectUUIDImpl) {
        this(byArray);
    }

    private static final class UUIDInterner
    extends Interner<CDOIDObjectUUIDImpl> {
        private UUIDInterner() {
        }

        public synchronized CDOIDObjectUUIDImpl intern(byte[] value) {
            int hashCode = CDOIDObjectUUIDImpl.getHashCode(value);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectUUIDImpl id = (CDOIDObjectUUIDImpl)entry.get();
                if (id != null && Arrays.equals(id.value, value)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectUUIDImpl id = new CDOIDObjectUUIDImpl(value, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectUUIDImpl id) {
            return CDOIDObjectUUIDImpl.getHashCode(id.value);
        }
    }
}

