/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.RWLock;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.StringCompressor;

public final class Entity
implements Comparable<Entity> {
    public static final char NAME_SEPARATOR = '/';
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_\\-./]*");
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_\\-.]*");
    private final String namespace;
    private final String name;
    private final int version;
    private final Map<String, String> properties;

    private Entity(String namespace, String name, int version, Map<String, String> properties) {
        this.namespace = Entity.requireValidNamespace(namespace).intern();
        this.name = Entity.requireValidName(name);
        this.version = Math.min(version, 1);
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return Entity.formatID(this.namespace, this.name);
    }

    public int version() {
        return this.version;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String name) {
        return this.properties.get(Entity.requireValidName(name));
    }

    public Entity filter(String ... propertyNames) {
        return this.filter(Arrays.asList(propertyNames));
    }

    public Entity filter(Collection<String> propertyNames) {
        return this.filter((String propertyName) -> propertyNames.contains(propertyName));
    }

    public Entity filter(Predicate<String> propertyNameFilter) {
        return Entity.builder(this).retain(propertyNameFilter).build();
    }

    @Override
    public int compareTo(Entity o) {
        int result = this.namespace.compareTo(o.namespace);
        if (result == 0) {
            result = this.name.compareTo(o.name);
        }
        if (result == 0) {
            result = Integer.compare(this.version, o.version);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.name, other.name) && this.version == other.version;
    }

    public String toString() {
        return String.valueOf(this.id()) + "[v" + this.version + "]";
    }

    public void write(ExtendedDataOutput out) throws IOException {
        this.write(out, null);
    }

    public void write(ExtendedDataOutput out, StringCompressor compressor) throws IOException {
        if (compressor == null) {
            out.writeString(this.namespace);
        } else {
            compressor.write(out, this.namespace);
        }
        out.writeString(this.name);
        out.writeVarInt(this.version);
        out.writeVarInt(this.properties.size());
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (compressor == null) {
                out.writeString(key);
            } else {
                compressor.write(out, key);
            }
            String value = entry.getValue();
            out.writeString(value);
        }
    }

    public static Entity read(ExtendedDataInput in) throws IOException {
        return Entity.read(in, null);
    }

    public static Entity read(ExtendedDataInput in, StringCompressor compressor) throws IOException {
        String namespace = compressor == null ? in.readString() : compressor.read(in);
        String name = in.readString();
        int version = in.readVarInt();
        int size = in.readVarInt();
        HashMap<String, String> properties = new HashMap<String, String>(size);
        int i = 0;
        while (i < size) {
            String key = compressor == null ? in.readString() : compressor.read(in);
            String value = in.readString();
            properties.put(key, value);
            ++i;
        }
        return new Entity(namespace, name, version, properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String namespace) {
        return Entity.builder().namespace(namespace);
    }

    public static Builder builder(String namespace, String name) {
        return Entity.builder(namespace).name(name);
    }

    public static Builder builder(Builder source) {
        return Entity.builder(source.build());
    }

    public static Builder builder(Entity source) {
        return new Builder().namespace(source.namespace).name(source.name).version(source.version).properties(source.properties);
    }

    public static String formatID(String namespace, String name) {
        return String.valueOf(namespace) + '/' + name;
    }

    public static Pair<String, String> parseID(String id) {
        int lastSep = id.lastIndexOf(47);
        CheckUtil.checkArg(lastSep != -1, "Illegal id");
        return Pair.create(id.substring(0, lastSep), id.substring(lastSep + 1));
    }

    public static String requireValidNamespace(String namespace) {
        return Entity.requireValidString(namespace, NAMESPACE_PATTERN, "namespace");
    }

    public static String requireValidName(String name) {
        return Entity.requireValidString(name, NAME_PATTERN, "name");
    }

    private static String requireValidString(String string, Pattern pattern, String arg) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Missing " + arg);
        }
        if (!pattern.matcher(string).matches()) {
            throw new IllegalArgumentException("Illegal " + arg + ": " + string);
        }
        return string;
    }

    /* synthetic */ Entity(String string, String string2, int n, Map map, Entity entity) {
        this(string, string2, n, map);
    }

    public static final class Builder {
        private String namespace;
        private String name;
        private int version = 1;
        private final Map<String, String> properties = new HashMap<String, String>();
        private List<Consumer<Builder>> preBuildHandlers;
        private List<Consumer<Entity>> postBuildHandlers;

        private Builder() {
        }

        public String namespace() {
            return this.namespace;
        }

        public Builder namespace(String namespace) {
            this.namespace = Entity.requireValidNamespace(namespace);
            return this;
        }

        public String name() {
            return this.name;
        }

        public Builder name(String name) {
            this.name = Entity.requireValidName(name);
            return this;
        }

        public int version() {
            return this.version;
        }

        public Builder version(int version) {
            CheckUtil.checkArg(version >= 1, "Illegal version");
            this.version = version;
            return this;
        }

        public Map<String, String> properties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public Builder properties(Map<String, String> properties) {
            if (properties != null) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public String property(String name) {
            return this.properties.get(Entity.requireValidName(name));
        }

        public Builder property(String name, String value) {
            Entity.requireValidName(name);
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
            return this;
        }

        public Builder remove(Predicate<String> namePredicate) {
            Iterator<String> it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                if (!namePredicate.test(name)) continue;
                it.remove();
            }
            return this;
        }

        public Builder retain(Predicate<String> namePredicate) {
            Iterator<String> it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                if (namePredicate.test(name)) continue;
                it.remove();
            }
            return this;
        }

        public Builder preBuild(Consumer<Builder> handler) {
            if (this.preBuildHandlers == null) {
                this.preBuildHandlers = new ArrayList<Consumer<Builder>>(1);
            }
            this.preBuildHandlers.add(handler);
            return this;
        }

        public Builder postBuild(Consumer<Entity> handler) {
            if (this.postBuildHandlers == null) {
                this.postBuildHandlers = new ArrayList<Consumer<Entity>>(1);
            }
            this.postBuildHandlers.add(handler);
            return this;
        }

        public Entity build() {
            if (this.preBuildHandlers != null) {
                for (Consumer<Builder> handler : this.preBuildHandlers) {
                    handler.accept(this);
                }
            }
            Entity entity = new Entity(this.namespace, this.name, this.version, this.properties, null);
            if (this.postBuildHandlers != null) {
                for (Consumer<Entity> handler : this.postBuildHandlers) {
                    handler.accept(entity);
                }
            }
            return entity;
        }
    }

    public static final class ComposedStore
    implements Store {
        private final List<Store> stores = new ArrayList<Store>();
        private final Map<String, List<Store>> storesByNamespace = new HashMap<String, List<Store>>();

        public ComposedStore addStore(Store store) {
            if (store != null && this.stores.add(store)) {
                store.namespaces().forEach(namespace -> this.storesByNamespace.computeIfAbsent((String)namespace, k -> new ArrayList()).add(store));
            }
            return this;
        }

        public ComposedStore removeStore(Store store) {
            if (store != null && this.stores.remove(store)) {
                store.namespaces().forEach(namespace -> {
                    List<Store> namespaceStores = this.storesByNamespace.get(namespace);
                    if (namespaceStores != null) {
                        namespaceStores.remove(store);
                    }
                });
            }
            return this;
        }

        @Override
        public Stream<String> namespaces() {
            return this.storesByNamespace.keySet().stream();
        }

        @Override
        public Stream<String> names(String namespace) {
            int size;
            Entity.requireValidNamespace(namespace);
            List<Store> namespaceStores = this.storesByNamespace.get(namespace);
            int n = size = namespaceStores == null ? 0 : namespaceStores.size();
            if (size == 0) {
                return Stream.empty();
            }
            if (size == 1) {
                return namespaceStores.get(0).names(namespace);
            }
            ArrayList streams = new ArrayList(size);
            for (Store store : namespaceStores) {
                streams.add(store.names(namespace));
            }
            return CollectionUtil.concat(streams).distinct();
        }

        @Override
        public Stream<Entity> entities() {
            int size = this.stores.size();
            if (size == 0) {
                return Stream.empty();
            }
            if (size == 1) {
                return this.stores.get(0).entities();
            }
            ArrayList streams = new ArrayList(size);
            for (Store store : this.stores) {
                streams.add(store.entities());
            }
            return CollectionUtil.concat(streams).distinct();
        }

        @Override
        public Stream<Entity> entities(String namespace) {
            int size;
            Entity.requireValidNamespace(namespace);
            List<Store> namespaceStores = this.storesByNamespace.get(namespace);
            int n = size = namespaceStores == null ? 0 : namespaceStores.size();
            if (size == 0) {
                return Stream.empty();
            }
            if (size == 1) {
                return namespaceStores.get(0).entities(namespace);
            }
            ArrayList streams = new ArrayList(size);
            for (Store store : namespaceStores) {
                streams.add(store.entities(namespace));
            }
            return CollectionUtil.concat(streams).distinct();
        }

        @Override
        public Entity entity(String namespace, String name) {
            Entity.requireValidNamespace(namespace);
            Entity.requireValidName(name);
            return this.entities(namespace).filter(entity -> entity.name().equals(name)).findFirst().orElse(null);
        }
    }

    public static final class ConcurrentStore
    implements Store {
        private final Store delegate;
        private final RWLock lock;

        public ConcurrentStore(Store delegate) {
            this(delegate, 1000L);
        }

        public ConcurrentStore(Store delegate, long timeoutMillis) {
            this.delegate = delegate;
            this.lock = new RWLock(timeoutMillis);
        }

        @Override
        public Stream<String> namespaces() {
            return this.read(() -> this.delegate.namespaces());
        }

        @Override
        public Stream<String> names(String namespace) {
            return this.read(() -> this.delegate.names(namespace));
        }

        @Override
        public Stream<Entity> entities() {
            return this.read(() -> this.delegate.entities());
        }

        @Override
        public Stream<Entity> entities(String namespace) {
            return this.read(() -> this.delegate.entities(namespace));
        }

        @Override
        public Entity entity(String namespace, String name) {
            return this.read(() -> this.delegate.entity(namespace, name));
        }

        @Override
        public Entity entity(String id) {
            return this.read(() -> this.delegate.entity(id));
        }

        public <V> V read(Callable<V> callable) {
            return this.lock.read(callable);
        }

        public void read(Runnable runnable) {
            this.lock.read(runnable);
        }

        public <V> V write(Callable<V> callable) {
            return this.lock.write(callable);
        }

        public void write(Runnable runnable) {
            this.lock.write(runnable);
        }
    }

    public static abstract class SingleNamespace
    implements Store {
        private final String namespace;

        public SingleNamespace(String namespace) {
            this.namespace = Entity.requireValidNamespace(namespace);
        }

        public final String namespace() {
            return this.namespace;
        }

        @Override
        public final boolean namespace(String namespace) {
            return this.namespace.equals(namespace);
        }

        @Override
        public final Stream<String> namespaces() {
            return Stream.of(this.namespace);
        }

        public final Stream<String> names() {
            return this.names(this.namespace);
        }

        @Override
        public final Stream<Entity> entities(String namespace) {
            if (!this.namespace.equals(namespace)) {
                return Stream.empty();
            }
            return this.entities();
        }

        public final Builder entityBuilder() {
            return Entity.builder(this.namespace);
        }

        public final Builder entityBuilder(String name) {
            return this.entityBuilder().name(name);
        }

        @Override
        public final Store store(String namespace) {
            if (!this.namespace.equals(namespace)) {
                return null;
            }
            return this;
        }
    }

    public static abstract class SingleNamespaceComputer
    extends SingleNamespace {
        public SingleNamespaceComputer(String namespace) {
            super(namespace);
        }

        @Override
        public final Stream<String> names(String namespace) {
            return this.computeNames().stream();
        }

        @Override
        public final Stream<Entity> entities() {
            return this.names().map(this::computeEntity);
        }

        @Override
        public final Entity entity(String namespace, String name) {
            if (!this.namespace().equals(namespace)) {
                return null;
            }
            return this.computeEntity(Entity.requireValidName(name));
        }

        protected abstract Collection<String> computeNames();

        protected abstract Entity computeEntity(String var1);
    }

    public static final class SingleNamespaceStore
    extends SingleNamespace {
        private final Map<String, Entity> entities = new HashMap<String, Entity>();

        public SingleNamespaceStore(String namespace) {
            super(namespace);
        }

        public Builder addEntity() {
            return this.entityBuilder().postBuild(this::addEntity);
        }

        public Builder addEntity(String name) {
            return this.addEntity().name(name);
        }

        public Entity addEntity(Entity entity) {
            if (!this.namespace().equals(entity.namespace)) {
                throw new IllegalArgumentException("Namespace mismatch");
            }
            return this.entities.put(entity.name(), entity);
        }

        public Entity removeEntity(String name) {
            return this.entities.remove(name);
        }

        @Override
        public Stream<String> names(String namespace) {
            if (!this.namespace().equals(namespace)) {
                return Stream.empty();
            }
            return this.entities.keySet().stream();
        }

        @Override
        public Stream<Entity> entities() {
            return this.entities.values().stream();
        }

        @Override
        public Entity entity(String namespace, String name) {
            if (!this.namespace().equals(namespace)) {
                return null;
            }
            return this.entities.get(name);
        }
    }

    public static interface Store {
        default public boolean namespace(String namespace) {
            Entity.requireValidNamespace(namespace);
            return this.namespaces().anyMatch(n -> n.equals(namespace));
        }

        default public Stream<String> namespaces() {
            return this.entities().map(Entity::namespace).distinct();
        }

        default public Stream<String> names(String namespace) {
            Entity.requireValidNamespace(namespace);
            return this.entities(namespace).map(Entity::name).distinct();
        }

        public Stream<Entity> entities();

        default public Stream<Entity> entities(String namespace) {
            Entity.requireValidNamespace(namespace);
            return this.entities().filter(entity -> entity.namespace().equals(namespace));
        }

        default public Entity entity(String namespace, String name) {
            Entity.requireValidNamespace(namespace);
            Entity.requireValidName(name);
            return this.entities(namespace).filter(entity -> entity.name().equals(name)).findFirst().orElse(null);
        }

        default public Entity entity(String id) {
            Pair<String, String> pair = Entity.parseID(id);
            return this.entity(pair.getElement1(), pair.getElement2());
        }

        default public Store store(final String namespace) {
            Entity.requireValidNamespace(namespace);
            return new Store(){

                @Override
                public boolean namespace(String n) {
                    return namespace.equals(n);
                }

                @Override
                public Stream<String> namespaces() {
                    return Stream.of(namespace);
                }

                @Override
                public Stream<String> names(String n) {
                    if (!namespace.equals(n)) {
                        return Stream.empty();
                    }
                    return Store.super.names(n);
                }

                @Override
                public Stream<Entity> entities() {
                    return this.entities(namespace);
                }

                @Override
                public Entity entity(String n, String name) {
                    if (!namespace.equals(n)) {
                        return null;
                    }
                    return Store.super.entity(n, name);
                }

                @Override
                public Store store(String n) {
                    if (!namespace.equals(n)) {
                        return null;
                    }
                    return this;
                }
            };
        }

        public static Store of(Object object) {
            if (object instanceof Store) {
                return (Store)object;
            }
            if (object instanceof Provider) {
                return ((Provider)object).getEntityStore();
            }
            return null;
        }

        public static interface Provider {
            public Store getEntityStore();
        }
    }
}

