/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class CDOViewSetHandler
extends Lifecycle {
    private final CDOViewSet viewSet;
    private final Adapter viewSetAdapter = new AdapterImpl(){

        public boolean isAdapterForType(Object type) {
            return type == CDOViewSet.class;
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getEventType()) {
                case 3: {
                    CDOView view = (CDOView)msg.getNewValue();
                    CDOViewSetHandler.this.addView(view);
                    break;
                }
                case 4: {
                    CDOView view = (CDOView)msg.getOldValue();
                    CDOViewSetHandler.this.removeView(view);
                    break;
                }
            }
        }
    };
    private final IListener viewListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOViewTargetChangedEvent) {
                CDOViewTargetChangedEvent e = (CDOViewTargetChangedEvent)event;
                CDOViewSetHandler.this.viewChanged(e.getSource(), e.getOldBranchPoint(), e.getBranchPoint());
            } else {
                CDOViewSetHandler.this.notifyViewEvent(event);
            }
        }
    };

    public CDOViewSetHandler(CDOViewSet viewSet) {
        this.viewSet = viewSet;
    }

    public CDOViewSetHandler(ResourceSet resourceSet) {
        this(CDOUtil.getViewSet((Notifier)resourceSet));
    }

    public final CDOViewSet getViewSet() {
        return this.viewSet;
    }

    protected void viewAdded(CDOView view) {
    }

    protected void viewChanged(CDOView view, CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
    }

    protected void viewRemoved(CDOView view) {
    }

    protected void notifyViewEvent(IEvent event) {
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        CDOView[] cDOViewArray = this.viewSet.getViews();
        int n = cDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view = cDOViewArray[n2];
            this.addView(view);
            ++n2;
        }
        this.viewSet.eAdapters().add((Object)this.viewSetAdapter);
    }

    protected void doDeactivate() throws Exception {
        this.viewSet.eAdapters().remove((Object)this.viewSetAdapter);
        CDOView[] cDOViewArray = this.viewSet.getViews();
        int n = cDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view = cDOViewArray[n2];
            this.removeView(view);
            ++n2;
        }
        super.doDeactivate();
    }

    private void addView(CDOView view) {
        view.addListener(this.viewListener);
        this.viewAdded(view);
    }

    private void removeView(CDOView view) {
        view.removeListener(this.viewListener);
        this.viewRemoved(view);
    }
}

