/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.etypes.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.AnnotationValidator;
import org.eclipse.emf.cdo.etypes.EtypesFactory;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.internal.cdo.bundle.OM;

public abstract class BasicAnnotationValidator
implements AnnotationValidator {
    public static final int INVALID_LOCATION = 1;
    public static final int INVALID_DUPLICATE = 2;
    public static final int INVALID_REFERENCE_LITERAL = 3;
    public static final int INVALID_DETAIL_VALUE = 4;
    public static final int INVALID_VALUE_LITERAL = 5;
    public static final int IGNORED_ANNOTATIONS = 6;
    public static final int IGNORED_CONTENTS = 7;
    public static final int IGNORED_REFERENCES = 8;
    public static final int INVALID_REFERENCE = 9;
    public static final int INVALID_ANNOTATION = 10;
    public static final int INVALID_CONTENT = 11;
    public static final int IGNORED_ENTRY = 12;
    public static final int MISSING_ENTRY = 13;
    public static final int MISSING_REQUIRED_ENTRY_VALUE = 14;
    public static final int TOO_FEW_VALUES = 15;
    public static final int TOO_MANY_VALUES = 16;
    protected final String annotationSource;
    protected final String annotationName;
    protected final String diagnosticSource;
    protected final Assistant assistant;

    public BasicAnnotationValidator(String annotationSource, String annotationName, String diagnosticSource) {
        this.annotationSource = annotationSource;
        this.annotationName = annotationName;
        this.diagnosticSource = diagnosticSource;
        this.assistant = this.createAssistant();
    }

    @Override
    public String getAnnotationSource() {
        return this.annotationSource;
    }

    protected abstract ResourceLocator getResourceLocator();

    protected abstract List<EClass> getPropertyClasses(ModelElement var1);

    public Assistant getAssistant() {
        return this.assistant;
    }

    protected Assistant createAssistant() {
        return new Assistant(this){};
    }

    @Override
    public boolean isValidLocation(Annotation annotation) {
        ModelElement modelElement = annotation.getModelElement();
        if (modelElement == null || !this.isValidLocation(annotation, modelElement)) {
            return false;
        }
        Annotation otherAnnotation = modelElement.getAnnotation(this.annotationSource);
        return otherAnnotation == null || otherAnnotation == annotation || this.isDuplicateValid(modelElement, otherAnnotation, annotation);
    }

    protected boolean isValidLocation(Annotation annotation, ModelElement modelElement) {
        return true;
    }

    protected boolean isDuplicateValid(ModelElement modelElement, Annotation primaryAnnotation, Annotation secondaryAnnotation) {
        return false;
    }

    @Override
    public boolean validate(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        ModelElement modelElement = annotation.getModelElement();
        if (modelElement != null && this.isValidLocation(annotation, modelElement)) {
            Annotation otherAnnotation = modelElement.getAnnotation(this.annotationSource);
            if (otherAnnotation == annotation || this.isDuplicateValid(modelElement, otherAnnotation, annotation)) {
                result = this.validateReferences(annotation, modelElement, diagnostics, context);
                if (result || diagnostics != null) {
                    result &= this.validateContents(annotation, modelElement, diagnostics, context);
                }
                if (result || diagnostics != null) {
                    result &= this.validateAnnotations(annotation, modelElement, diagnostics, context);
                }
                if (result || diagnostics != null) {
                    result &= this.validateDetails(annotation, modelElement, diagnostics, context);
                }
            } else {
                result = false;
                if (diagnostics != null) {
                    this.reportDuplicate(otherAnnotation, annotation, modelElement, diagnostics, context);
                }
            }
        } else {
            result = false;
            if (diagnostics != null) {
                this.reportInvalidLocation(annotation, diagnostics, context);
            }
        }
        return result;
    }

    protected boolean validateReferences(Annotation annotation, ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<EObject> references = annotation.getReferences();
        if (!this.isReferencesSupported(annotation, modelElement)) {
            boolean result = references.isEmpty();
            if (!result && diagnostics != null) {
                this.reportIgnoredReferences(annotation, modelElement, (Collection<? extends EObject>)references, diagnostics, context);
            }
            return result;
        }
        boolean result = true;
        Collection<?> validReferences = this.getValidReferences(annotation, modelElement, (Collection<?>)references);
        for (EObject reference : references) {
            if (validReferences.contains(reference)) continue;
            result = false;
            if (diagnostics == null) break;
            this.reportInvalidReference(annotation, modelElement, reference, diagnostics, context);
        }
        return result;
    }

    protected boolean isReferencesSupported(Annotation annotation, ModelElement modelElement) {
        return false;
    }

    protected Collection<?> getValidReferences(Annotation annotation, ModelElement modelElement, Collection<?> references) {
        return this.isReferencesSupported(annotation, modelElement) ? references : Collections.emptyList();
    }

    protected boolean validateContents(Annotation annotation, ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<EObject> contents = annotation.getContents();
        if (!this.isContentsSupported(annotation, modelElement)) {
            boolean result = contents.isEmpty();
            if (!result && diagnostics != null) {
                this.reportIgnoredContents(annotation, modelElement, (Collection<? extends EObject>)contents, diagnostics, context);
            }
            return result;
        }
        boolean result = true;
        Collection<? extends EObject> validContents = this.getValidContents(annotation, modelElement, (Collection<? extends EObject>)contents);
        for (EObject content : contents) {
            if (validContents.contains(content)) continue;
            result = false;
            if (diagnostics == null) break;
            this.reportInvalidContent(annotation, modelElement, content, diagnostics, context);
        }
        return result;
    }

    protected boolean isContentsSupported(Annotation annotation, ModelElement modelElement) {
        return false;
    }

    protected Collection<? extends EObject> getValidContents(Annotation annotation, ModelElement modelElement, Collection<? extends EObject> contents) {
        return this.isContentsSupported(annotation, modelElement) ? contents : Collections.emptyList();
    }

    protected boolean validateAnnotations(Annotation annotation, ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<Annotation> annotations = annotation.getAnnotations();
        if (!annotations.isEmpty()) {
            Collection<? extends Annotation> validAnnotations = this.getValidAnnotations(annotation, modelElement, (Collection<? extends Annotation>)annotations);
            if (!this.isAnnotationsSupported(annotation, modelElement)) {
                if (!validAnnotations.containsAll((Collection<?>)annotations)) {
                    if (diagnostics != null) {
                        ArrayList<Annotation> ignoredAnnotations = new ArrayList<Annotation>((Collection<Annotation>)annotations);
                        ignoredAnnotations.removeAll(validAnnotations);
                        this.reportIgnoredAnnotations(annotation, modelElement, ignoredAnnotations, diagnostics, context);
                    }
                    return false;
                }
                return true;
            }
            boolean result = true;
            for (Annotation nestedAnnotation : annotations) {
                if (validAnnotations.contains(nestedAnnotation)) continue;
                result = false;
                if (diagnostics == null) break;
                this.reportInvalidAnnotation(annotation, modelElement, nestedAnnotation, diagnostics, context);
            }
            return result;
        }
        return true;
    }

    protected boolean isAnnotationsSupported(Annotation annotation, ModelElement modelElement) {
        return false;
    }

    protected Collection<? extends Annotation> getValidAnnotations(Annotation annotation, ModelElement modelElement, Collection<? extends Annotation> annotations) {
        ArrayList<? extends Annotation> result = new ArrayList<Annotation>(annotations);
        for (Annotation annotation2 : annotations) {
            AnnotationValidator annotationValidator = AnnotationValidator.Registry.INSTANCE.getAnnotationValidator(annotation2.getSource());
            if (annotationValidator instanceof BasicAnnotationValidator && ((BasicAnnotationValidator)annotationValidator).isValidLocation(annotation2, annotation)) continue;
            result.remove(annotation2);
        }
        return result;
    }

    protected Collection<? extends Annotation> getAllValidAnnotations(Annotation annotation, ModelElement modelElement, Collection<? extends Annotation> annotations) {
        ArrayList<? extends Annotation> result = new ArrayList<Annotation>(this.getValidAnnotations(annotation, modelElement, annotations));
        for (String annotationSource : AnnotationValidator.Registry.INSTANCE.getAnnotationSources()) {
            AnnotationValidator annotationValidator;
            try {
                annotationValidator = AnnotationValidator.Registry.INSTANCE.getAnnotationValidator(annotationSource);
            }
            catch (RuntimeException exception) {
                annotationValidator = null;
                OM.LOG.error((Throwable)exception);
            }
            if (!(annotationValidator instanceof BasicAnnotationValidator)) continue;
            BasicAnnotationValidator basicAnnotationValidator = (BasicAnnotationValidator)annotationValidator;
            Annotation nestedAnnotation = EtypesFactory.eINSTANCE.createAnnotation();
            nestedAnnotation.setSource(annotationSource);
            Annotation otherAnnotation = annotation.getAnnotation(annotationSource);
            if (otherAnnotation != null && !basicAnnotationValidator.isDuplicateValid(annotation, otherAnnotation, nestedAnnotation) || !((BasicAnnotationValidator)annotationValidator).isValidLocation(nestedAnnotation, annotation)) continue;
            result.add(nestedAnnotation);
        }
        return result;
    }

    protected boolean validateDetails(Annotation annotation, ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        LinkedHashMap<String, EStructuralFeature> properties = new LinkedHashMap<String, EStructuralFeature>(this.getProperties(modelElement));
        for (Map.Entry<String, String> entry : annotation.getDetails()) {
            String key = (String)entry.getKey();
            EStructuralFeature feature = (EStructuralFeature)properties.remove(key);
            result = feature == null ? (result &= this.validateDetail(annotation, modelElement, entry, diagnostics, context)) : (result &= this.validateFeatureDetail(annotation, modelElement, entry, feature, diagnostics, context));
            if (result || diagnostics != null) continue;
            return false;
        }
        if (result) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                EStructuralFeature feature = (EStructuralFeature)entry.getValue();
                if (!feature.isRequired()) continue;
                result = false;
                if (diagnostics == null) break;
                this.reportMissingEntry(annotation, modelElement, entry.getKey(), feature, diagnostics, context);
            }
        }
        return result;
    }

    protected Map<String, EStructuralFeature> getProperties(ModelElement modelElement) {
        LinkedHashMap<String, EStructuralFeature> properties = new LinkedHashMap<String, EStructuralFeature>();
        for (EClass eClass : this.getPropertyClasses(modelElement)) {
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                if (!this.isIncludedProperty(modelElement, eClass, eStructuralFeature)) continue;
                properties.put(eStructuralFeature.getName(), eStructuralFeature);
            }
        }
        return Collections.unmodifiableMap(properties);
    }

    protected boolean isIncludedProperty(ModelElement modelElement, EClass eClass, EStructuralFeature eStructuralFeature) {
        return true;
    }

    protected EObject createInstance(EClass eClass, Annotation annotation) {
        ModelElement modelElement = annotation.getModelElement();
        if (!this.getPropertyClasses(modelElement).contains(eClass)) {
            throw new IllegalArgumentException("The eClass is not a property class of the model element");
        }
        return this.initialize(EcoreUtil.create((EClass)eClass), annotation);
    }

    protected EObject initialize(EObject eObject, Annotation annotation) {
        ModelElement modelElement = annotation.getModelElement();
        Map<String, EStructuralFeature> properties = this.getProperties(modelElement);
        for (Map.Entry entry : annotation.getDetails()) {
            String key = (String)entry.getKey();
            EStructuralFeature eStructuralFeature = properties.get(key);
            if (eStructuralFeature instanceof EAttribute) {
                EDataType eDataType = (EDataType)eStructuralFeature.getEType();
                String literalValue = (String)entry.getValue();
                if (eStructuralFeature.isMany()) {
                    List<String> literalValues = this.split(annotation, modelElement, entry, literalValue, eStructuralFeature, null, null);
                    ArrayList<Object> value = new ArrayList<Object>();
                    if (literalValues != null) {
                        for (String itemLiteralValue : literalValues) {
                            value.add(EcoreUtil.createFromString((EDataType)eDataType, (String)itemLiteralValue));
                        }
                    }
                    eObject.eSet(eStructuralFeature, value);
                    continue;
                }
                eObject.eSet(eStructuralFeature, EcoreUtil.createFromString((EDataType)eDataType, (String)literalValue));
                continue;
            }
            if (eStructuralFeature == null) continue;
            throw new UnsupportedOperationException("Initializing of references is not supported");
        }
        return eObject;
    }

    protected String convertPropertyValueToLiteral(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature.isMany()) {
            ArrayList<String> result = new ArrayList<String>();
            if (value != null) {
                List values = (List)value;
                for (Object valueItem : values) {
                    result.add(this.convertPropertyValueToLiteralItem(eObject, eStructuralFeature, valueItem));
                }
            }
            return this.join(eObject, eStructuralFeature, result);
        }
        return this.convertPropertyValueToLiteralItem(eObject, eStructuralFeature, value);
    }

    protected String convertPropertyValueToLiteralItem(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature instanceof EAttribute) {
            return this.convertPropertyAttributeValueToLiteralItem(eObject, (EAttribute)eStructuralFeature, value);
        }
        return this.convertPropertyReferenceValueToLiteralItem(eObject, (EReference)eStructuralFeature, value);
    }

    protected String convertPropertyAttributeValueToLiteralItem(EObject eObject, EAttribute eAttribute, Object value) {
        return EcoreUtil.convertToString((EDataType)eAttribute.getEAttributeType(), (Object)value);
    }

    protected String convertPropertyReferenceValueToLiteralItem(EObject eObject, EReference eReference, Object value) {
        Object name;
        EObject valueEObject;
        EStructuralFeature eStructuralFeature;
        if (value == null) {
            return null;
        }
        if (value instanceof EObject && (eStructuralFeature = (valueEObject = (EObject)value).eClass().getEStructuralFeature("name")) != null && (name = valueEObject.eGet(eStructuralFeature)) instanceof String) {
            return name.toString();
        }
        throw new UnsupportedOperationException("Unable to convert '" + value + "' to a literal value for feature " + eReference + " of " + eObject);
    }

    protected String join(EObject eObject, EStructuralFeature eStructuralFeature, List<String> literalValues) {
        return XMLTypeFactory.eINSTANCE.convertENTITIESBase(literalValues);
    }

    protected boolean isApplicable(EObject eObject, EStructuralFeature eStructuralFeature) {
        return true;
    }

    protected boolean validateDetail(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            this.reportIgnoredEntry(annotation, modelElement, entry, diagnostics, context);
        }
        return false;
    }

    protected boolean validateFeatureDetail(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EStructuralFeature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        BasicDiagnostic badValueDiagnostic = diagnostics == null ? null : this.createValueDiagnostic(annotation, modelElement, entry, feature);
        ArrayList<Object> values = new ArrayList<Object>();
        boolean bl = result = feature instanceof EAttribute ? this.validateAttributeDetailLiteralValue(annotation, modelElement, entry, (EAttribute)feature, values, (DiagnosticChain)badValueDiagnostic, context) : this.validateReferenceDetailLiteralValue(annotation, modelElement, entry, (EReference)feature, values, (DiagnosticChain)badValueDiagnostic, context);
        if (result) {
            result &= this.validateFeatureDetailValue(annotation, modelElement, entry, feature, values, (DiagnosticChain)badValueDiagnostic, context);
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)badValueDiagnostic);
        }
        return result;
    }

    protected boolean validateFeatureDetailValue(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        int size = values.size();
        if (feature.isMany()) {
            int upperBound;
            int lowerBound = feature.getLowerBound();
            if (lowerBound > 0 && size < lowerBound) {
                if (diagnostics != null) {
                    this.reportTooFewValues(annotation, modelElement, entry, feature, values, size, lowerBound, diagnostics, context);
                }
                result = false;
            }
            if ((upperBound = feature.getUpperBound()) > 0 && size > upperBound) {
                if (diagnostics != null) {
                    this.reportTooManyValues(annotation, modelElement, entry, feature, values, size, upperBound, diagnostics, context);
                }
                result = false;
            }
        } else if (feature.isRequired() && (size == 0 || values.get(0) == null)) {
            result = false;
            if (diagnostics != null) {
                this.reportMissingRequiredEntryValue(annotation, modelElement, feature, values, diagnostics, context);
            }
        }
        return result;
    }

    protected boolean validateAttributeDetailLiteralValue(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EAttribute attribute, List<Object> dataValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String literalValue = entry.getValue();
        if (attribute.isMany()) {
            List<String> literalValues = this.split(annotation, modelElement, entry, literalValue, (EStructuralFeature)attribute, diagnostics, context);
            if (literalValues != null) {
                for (String literalValueItem : literalValues) {
                    if ((result &= this.validateAttributeDetailValueLiteral(annotation, modelElement, entry, attribute, literalValueItem, dataValues, diagnostics, context)) || diagnostics != null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = this.validateAttributeDetailValueLiteral(annotation, modelElement, entry, attribute, literalValue, dataValues, diagnostics, context);
        }
        return result;
    }

    protected boolean validateAttributeDetailValueLiteral(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EAttribute attribute, String literalValue, List<Object> dataValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        block5: {
            EDataType dataType = attribute.getEAttributeType();
            try {
                Object value = EcoreUtil.createFromString((EDataType)dataType, (String)literalValue);
                dataValues.add(value);
                EValidator rootEValidator = this.getRootEValidator(context);
                ValidationContext validationContext = new ValidationContext(annotation, modelElement, entry, attribute);
                context.put("EANNOTATION_VALIDATION_CONTEXT", validationContext);
                try {
                    result = rootEValidator == null || rootEValidator.validate(dataType, value, diagnostics, context);
                }
                finally {
                    context.remove("EANNOTATION_VALIDATION_CONTEXT");
                }
            }
            catch (RuntimeException exception) {
                result = false;
                if (diagnostics == null) break block5;
                this.reportInvalidValueLiteral(annotation, modelElement, entry, attribute, literalValue, dataType, diagnostics, exception, context);
            }
        }
        return result;
    }

    protected boolean validateReferenceDetailLiteralValue(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EReference reference, List<Object> referenceValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String literalValue = entry.getValue();
        if (reference.isMany()) {
            List<String> literalValues = this.split(annotation, modelElement, entry, literalValue, (EStructuralFeature)reference, diagnostics, context);
            if (literalValues != null) {
                for (String literalValueItem : literalValues) {
                    if ((result &= this.validateReferenceDetailValueLiteral(annotation, modelElement, entry, reference, literalValueItem, referenceValues, diagnostics, context)) || diagnostics != null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = this.validateReferenceDetailValueLiteral(annotation, modelElement, entry, reference, literalValue, referenceValues, diagnostics, context);
        }
        return result;
    }

    protected boolean validateReferenceDetailValueLiteral(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EReference reference, String literalValue, List<Object> referenceValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            this.reportInvalidReferenceLiteral(annotation, modelElement, entry, reference, literalValue, diagnostics, context);
        }
        return false;
    }

    protected List<String> split(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, String literalValue, EStructuralFeature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return XMLTypeFactory.eINSTANCE.createENTITIESBase(literalValue);
    }

    protected void reportInvalidReferenceLiteral(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EReference reference, String literalValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 3, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValue_diagnostic", literalValue, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidReferenceValue_substitution", reference.getEReferenceType().getName())), literalValue, reference.getEReferenceType()));
    }

    protected void reportInvalidValueLiteral(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EAttribute attribute, String literalValue, EDataType dataType, DiagnosticChain diagnostics, RuntimeException exception, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 5, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValue_diagnostic", literalValue, exception.getLocalizedMessage()), literalValue, dataType));
    }

    protected void reportMissingRequiredEntryValue(Annotation annotation, ModelElement modelElement, EStructuralFeature feature, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 14, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValueRequiredFeatureMustBeSet_diagnostic", new Object[0]), new Object[]{null}));
    }

    protected void reportTooFewValues(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, int size, int lowerBound, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 15, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValueFeatureHasTooFewValues_diagnostic", size, lowerBound), values));
    }

    protected void reportTooManyValues(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, int size, int upperBound, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 16, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValueFeatureHasTooManyValues_diagnostic", size, upperBound), values));
    }

    protected void reportInvalidLocation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 1, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationLocation_diagnostic", this.annotationName, this.getValidLocationDescription()), annotation, EcorePackage.Literals.EANNOTATION__SOURCE));
    }

    protected void reportDuplicate(Annotation primaryAnnotation, Annotation secondaryAnnotation, ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 2, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidDuplicateAnnotation_diagnostic", this.annotationName, this.getValidLocationDescription()), secondaryAnnotation, EcorePackage.Literals.EANNOTATION__SOURCE, primaryAnnotation));
    }

    protected void reportIgnoredEntry(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 12, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationEntryKey_diagnostic", this.annotationName, entry.getKey()), entry, EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__KEY));
    }

    protected void reportMissingEntry(Annotation annotation, ModelElement modelElement, String key, EStructuralFeature property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 13, this.getString(this.getEcoreResourceLocator(), "_UI_MissingAnnotationEntryKey_diagnostic", key), annotation, EcorePackage.Literals.EANNOTATION__DETAILS));
    }

    protected void reportIgnoredReferences(Annotation annotation, ModelElement modelElement, Collection<? extends EObject> ignoredReferences, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<? extends EObject> data = new ArrayList<EObject>();
        data.add(annotation);
        data.add((EObject)EcorePackage.Literals.EANNOTATION__REFERENCES);
        data.addAll(ignoredReferences);
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 8, this.getString(this.getEcoreResourceLocator(), "_UI_IgnoredAnnotationReferences_diagnostic", this.annotationName), data.toArray()));
    }

    protected void reportInvalidReference(Annotation annotation, ModelElement modelElement, EObject reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 9, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationReference_diagnostic", this.annotationName, EObjectValidator.getObjectLabel((EObject)reference, context)), annotation, EcorePackage.Literals.EANNOTATION__REFERENCES, reference));
    }

    protected void reportIgnoredContents(Annotation annotation, ModelElement modelElement, Collection<? extends EObject> ignoredContents, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<? extends EObject> data = new ArrayList<EObject>();
        data.add(annotation);
        data.add((EObject)EcorePackage.Literals.EANNOTATION__CONTENTS);
        data.addAll(ignoredContents);
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 9, this.getString(this.getEcoreResourceLocator(), "_UI_IgnoredAnnotationContents_diagnostic", this.annotationName), data.toArray()));
    }

    protected void reportInvalidContent(Annotation annotation, ModelElement modelElement, EObject content, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 11, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationContent_diagnostic", this.annotationName, EObjectValidator.getObjectLabel((EObject)content, context)), annotation, EcorePackage.Literals.EANNOTATION__CONTENTS, content));
    }

    protected void reportIgnoredAnnotations(Annotation annotation, ModelElement modelElement, Collection<? extends Annotation> ignoredAnnotations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<? extends Annotation> data = new ArrayList<Annotation>();
        data.add(annotation);
        data.add((Annotation)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
        data.addAll(ignoredAnnotations);
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 6, this.getString(this.getEcoreResourceLocator(), "_UI_IgnoredAnnotationAnnotations_diagnostic", this.annotationName), data.toArray()));
    }

    protected void reportInvalidAnnotation(Annotation annotation, ModelElement modelElement, Annotation nestedAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 10, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationAnnotation_diagnostic", this.annotationName, EObjectValidator.getObjectLabel((EObject)nestedAnnotation, context)), annotation, EcorePackage.Literals.EANNOTATION__CONTENTS, nestedAnnotation));
    }

    protected String getValidLocationDescription() {
        String description;
        try {
            description = this.getString(this.getResourceLocator(), "_UI_Valid" + this.annotationName + "AnnotationLocation_substitution", new Object[0]);
        }
        catch (MissingResourceException exception) {
            OM.LOG.error((Throwable)exception);
            description = "unknown; Implementation error for " + this.getClass().getName() + ":" + exception.getLocalizedMessage();
        }
        return description;
    }

    protected BasicDiagnostic createValueDiagnostic(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EStructuralFeature feature) {
        return this.createDiagnostic(0, 4, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationEntryValue_diagnostic", this.annotationName, entry.getKey()), entry, EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE, feature);
    }

    protected ResourceLocator getEcoreResourceLocator() {
        return EcorePlugin.INSTANCE;
    }

    protected BasicDiagnostic createDiagnostic(int severity, int code, String message, Object ... data) {
        return new BasicDiagnostic(severity, this.diagnosticSource, code, message, data);
    }

    protected String getString(ResourceLocator resourceLocator, String key, Object ... substitutions) {
        return substitutions == null ? resourceLocator.getString(key) : resourceLocator.getString(key, substitutions);
    }

    protected EValidator getRootEValidator(Map<Object, Object> context) {
        EValidator result;
        if (context != null && (result = (EValidator)context.get(EValidator.class)) != null) {
            return result;
        }
        return Diagnostician.INSTANCE;
    }

    protected static EPackage loadEPackage(String uri) {
        Resource resource = new EPackageImpl(){

            public Resource createResource(String uri) {
                Resource resource = super.createResource(uri);
                resource.getContents().clear();
                resource.unload();
                return resource;
            }
        }.createResource(uri);
        try {
            resource.load(null);
            EPackage ePackage = (EPackage)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
            if (ePackage != null) {
                String nsURI = ePackage.getNsURI();
                EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)ePackage);
                resource.setURI(URI.createURI((String)nsURI));
            }
            return ePackage;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static abstract class Assistant {
        protected final BasicAnnotationValidator annotationValidator;

        public Assistant(BasicAnnotationValidator annotationValidator) {
            this.annotationValidator = annotationValidator;
        }

        public boolean isValidLocation(Annotation annotation) {
            return this.annotationValidator.isValidLocation(annotation);
        }

        public Map<String, EStructuralFeature> getProperties(ModelElement modelElement) {
            return this.annotationValidator.getProperties(modelElement);
        }

        public List<EClass> getPropertyClasses(ModelElement modelElement) {
            return this.annotationValidator.getPropertyClasses(modelElement);
        }

        public EObject createInstance(EClass eClass, Annotation annotation) {
            return this.annotationValidator.createInstance(eClass, annotation);
        }

        public String convertPropertyValueToLiteral(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
            return this.annotationValidator.convertPropertyValueToLiteral(eObject, eStructuralFeature, value);
        }

        public Map<String, EStructuralFeature> getApplicableProperties(EObject eObject, Annotation annotation) {
            ModelElement modelElement = annotation.getModelElement();
            Map<String, EStructuralFeature> properties = this.getProperties(modelElement);
            LinkedHashMap<String, EStructuralFeature> result = new LinkedHashMap<String, EStructuralFeature>();
            for (Map.Entry<String, EStructuralFeature> entry : properties.entrySet()) {
                EStructuralFeature eStructuralFeature = entry.getValue();
                if (!this.annotationValidator.isApplicable(eObject, eStructuralFeature)) continue;
                result.put(entry.getKey(), eStructuralFeature);
            }
            return Collections.unmodifiableMap(result);
        }

        public boolean isReferencesSupported(Annotation annotation) {
            return this.annotationValidator.isReferencesSupported(annotation, annotation.getModelElement());
        }

        public Collection<?> getValidReferences(Annotation annotation, Collection<?> references) {
            return this.annotationValidator.getValidReferences(annotation, annotation.getModelElement(), references);
        }

        public boolean isContentsSupported(Annotation annotation) {
            return this.annotationValidator.isContentsSupported(annotation, annotation.getModelElement());
        }

        public Collection<? extends EObject> getValidContents(Annotation annotation, Collection<? extends EObject> contents) {
            return this.annotationValidator.getValidContents(annotation, annotation.getModelElement(), contents);
        }

        public boolean isAnnotationsSupported(Annotation annotation) {
            return this.annotationValidator.isAnnotationsSupported(annotation, annotation.getModelElement());
        }

        public Collection<? extends Annotation> getValidAnnotations(Annotation annotation, Collection<? extends Annotation> annotations) {
            return this.annotationValidator.getAllValidAnnotations(annotation, annotation.getModelElement(), annotations);
        }
    }

    public static class ValidationContext {
        public static final String CONTEXT_KEY = "EANNOTATION_VALIDATION_CONTEXT";
        private final Annotation annotation;
        private final ModelElement modelElement;
        private final Map.Entry<String, String> entry;
        private final EAttribute eAttribute;

        public ValidationContext(Annotation annotation, ModelElement modelElement, Map.Entry<String, String> entry, EAttribute eAttribute) {
            this.annotation = annotation;
            this.modelElement = modelElement;
            this.entry = entry;
            this.eAttribute = eAttribute;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public ModelElement getModelElement() {
            return this.modelElement;
        }

        public Map.Entry<String, String> getEntry() {
            return this.entry;
        }

        public EAttribute getEAttribute() {
            return this.eAttribute;
        }
    }
}

