/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.server.offline;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.examples.company.CompanyFactory;
import org.eclipse.emf.cdo.examples.company.Customer;
import org.eclipse.emf.cdo.examples.server.offline.OfflineExampleUtil;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class OfflineExampleClient {
    public static final int PORT = 2037;
    private static CDOTransaction tx;

    private static void addObject(CDOTransaction tx) {
        try {
            Customer customer = CompanyFactory.eINSTANCE.createCustomer();
            tx.getOrCreateResource("/r1").getContents().add((Object)customer);
            System.out.println("Committing an object to " + tx.getBranch().getPathName());
            CDOCommitInfo commitInfo = tx.commit();
            CDOBranch branch = commitInfo.getBranch();
            System.out.println("Committed an object to  " + branch.getPathName());
            tx.setBranch(branch);
        }
        catch (CommitException x) {
            throw new RuntimeException(x);
        }
    }

    private static void lockObject(CDOTransaction tx) {
        EList contents = tx.getOrCreateResource("/r1").getContents();
        int size = contents.size();
        if (size < 1) {
            System.out.println("There are no objects; can't lock anything.");
        }
        System.out.println("Locking last object");
        CDOObject firstObject = CDOUtil.getCDOObject((EObject)((EObject)contents.get(size - 1)));
        firstObject.cdoWriteLock().lock();
        System.out.println("Locked last object");
    }

    private static void unlockObject(CDOTransaction tx) {
        EList contents = tx.getOrCreateResource("/r1").getContents();
        int size = contents.size();
        if (size < 1) {
            System.out.println("There are no objects; can't unlock anything.");
        }
        System.out.println("Unlocking last object");
        CDOObject firstObject = CDOUtil.getCDOObject((EObject)((EObject)contents.get(size - 1)));
        firstObject.cdoWriteLock().unlock();
        System.out.println("Unlocked last object");
    }

    private static void createBranch(CDOTransaction tx) {
        CDOBranch subBranch = tx.getBranch().createBranch("sub.1");
        tx.setBranch(subBranch);
    }

    private static boolean isAutoMerge(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-automerge")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void createSessionListener(final CDONet4jSession session, final boolean autoMerging) {
        session.addListener(new IListener(){
            private boolean wasOffline;

            public void notifyEvent(IEvent event) {
                if (event instanceof CDOCommonRepository.StateChangedEvent) {
                    CDOCommonRepository.StateChangedEvent e = (CDOCommonRepository.StateChangedEvent)event;
                    CDOCommonRepository.State newState = e.getNewState();
                    System.out.println("State changed to " + newState);
                    if (autoMerging) {
                        this.merge(session, newState);
                    }
                }
            }

            private void merge(CDONet4jSession session2, CDOCommonRepository.State newState) {
                if (newState == CDOCommonRepository.State.ONLINE && this.wasOffline) {
                    try {
                        try {
                            CDOTransaction newTransaction = session2.openTransaction(session2.getBranchManager().getMainBranch());
                            newTransaction.merge(tx.getBranch().getHead(), (CDOMerger)new DefaultCDOMerger.PerFeature.ManyValued());
                            newTransaction.commit();
                            tx.close();
                            tx = newTransaction;
                        }
                        catch (CommitException ex) {
                            ex.printStackTrace();
                            this.wasOffline = false;
                        }
                    }
                    finally {
                        this.wasOffline = false;
                    }
                } else if (newState == CDOCommonRepository.State.OFFLINE) {
                    this.wasOffline = true;
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        boolean autoMerging = OfflineExampleClient.isAutoMerge(args);
        System.out.println("Client starting...");
        IManagedContainer container = OfflineExampleUtil.createContainer();
        IConnector connector = Net4jUtil.getConnector((IManagedContainer)container, (String)"tcp", (String)"localhost:2037");
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName("clone");
        CDONet4jSession session = configuration.openNet4jSession();
        CDORepositoryInfo repositoryInfo = session.getRepositoryInfo();
        System.out.println("Connected to " + repositoryInfo.getName());
        tx = session.openTransaction();
        tx.enableDurableLocking();
        OfflineExampleClient.createSessionListener(session, autoMerging);
        while (true) {
            System.out.println();
            System.out.println("Enter a command:");
            System.out.println("0 - exit");
            System.out.println("1 - add an object to the repository");
            System.out.println("2 - lock the last object in the repository");
            System.out.println("3 - unlock the last object in the repository");
            System.out.println("4 - create a branch");
            String command = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if ("0".equals(command)) break;
            if ("1".equals(command)) {
                OfflineExampleClient.addObject(tx);
                continue;
            }
            if ("2".equals(command)) {
                OfflineExampleClient.lockObject(tx);
                continue;
            }
            if ("3".equals(command)) {
                OfflineExampleClient.unlockObject(tx);
                continue;
            }
            if (!"4".equals(command)) continue;
            OfflineExampleClient.createBranch(tx);
        }
        session.close();
        LifecycleUtil.deactivate((Object)container);
    }
}

