/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.tests.lm.AbstractLMTest;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class LMFlowsTest
extends AbstractLMTest {
    private static final String INITIAL_STREAM = "InitialStream";
    private static final String CLIENT_MODULE = "ClientModule";
    private static final String SUPPLIER_MODULE = "SupplierModule";
    private static final String SUPPLIER_RESOURCE_A = "SupplierResourceA";
    private static final String SUPPLIER_RESOURCE_B = "SupplierResourceB";
    private static final String CHANGE_1 = "Change1";

    public void testEntireNormalFlow() throws Exception {
        ISystemDescriptor systemDescriptor = LMFlowsTest.createSystemRepository();
        System system = systemDescriptor.getSystem();
        AbstractLMTest.ModuleCreationResult supplierModuleCreationResult = this.createModule(systemDescriptor, system, SUPPLIER_MODULE, INITIAL_STREAM, 0, 1);
        IAssemblyDescriptor supplierStreamDescriptor = supplierModuleCreationResult.assemblyDescriptor;
        Stream supplierStream = supplierModuleCreationResult.stream;
        Change change1 = this.createChange(systemDescriptor, supplierStream, CHANGE_1, "SupplierModule - Change1", transaction -> transaction.createResource(SUPPLIER_RESOURCE_A));
        this.deliverChange(systemDescriptor, supplierStream, change1);
        CDOView view = supplierStreamDescriptor.getCheckout().openView();
        MatcherAssert.assertThat((Object)view.hasResource(SUPPLIER_RESOURCE_A), (Matcher)CoreMatchers.is((Object)true));
        view.close();
        AbstractLMTest.ModuleCreationResult clientModuleCreationResult = this.createModule(systemDescriptor, system, CLIENT_MODULE, INITIAL_STREAM, 0, 1);
        IAssemblyDescriptor clientStreamDescriptor = clientModuleCreationResult.assemblyDescriptor;
        this.createDependencyAndUpdate(clientStreamDescriptor, SUPPLIER_MODULE);
        this.editStream(supplierStreamDescriptor, transaction -> transaction.createResource(SUPPLIER_RESOURCE_B));
        URI uri = LMFlowsTest.createModuleResourceURI(SUPPLIER_MODULE, SUPPLIER_RESOURCE_B);
        this.publishTagUpdateClientAndCheckUri(systemDescriptor, system, supplierStream, clientStreamDescriptor, uri);
        this.removeDependencies(clientStreamDescriptor);
        this.createDependencyAndUpdate(clientStreamDescriptor, SUPPLIER_MODULE);
        Change change2 = this.createChange(systemDescriptor, supplierStream, "Change2", "SupplierModule - Change2", transaction -> transaction.createResource("To Be Deleted"));
        systemDescriptor.deleteChange(change2, (IProgressMonitor)new NullProgressMonitor());
        Change change3 = this.createChange(systemDescriptor, supplierStream, "Change3", "SupplierModule - Change3", transaction -> transaction.createResource("Not Deleteable"));
        this.deliverChange(systemDescriptor, supplierStream, change3);
        try {
            systemDescriptor.deleteChange(change3, (IProgressMonitor)new NullProgressMonitor());
            LMFlowsTest.fail((String)"ChangeDeletionException expected");
        }
        catch (ISystemDescriptor.ChangeDeletionException changeDeletionException) {
            // empty catch block
        }
    }
}

