/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.bugzilla;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.tests.AbstractCDOTest;
import org.eclipse.emf.cdo.tests.config.impl.ConfigTest;
import org.eclipse.emf.cdo.tests.model1.Company;
import org.eclipse.emf.cdo.tests.model1.Customer;
import org.eclipse.emf.cdo.tests.model1.SalesOrder;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.db.DBUtil;

@ConfigTest.Skips(value={"repository.auditing", "DB.inverse.lists"})
public class Bugzilla_351068_Test
extends AbstractCDOTest {
    @ConfigTest.CleanRepositoriesBefore(reason="Row counting")
    public void testDelete() throws Exception {
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/my/resource"));
        Company company = this.getModel1Factory().createCompany();
        resource.getContents().add((Object)company);
        transaction.commit();
        Bugzilla_351068_Test.assertEquals((int)1, (int)this.countRows("MODEL1_COMPANY"));
        Bugzilla_351068_Test.assertEquals((int)5, (int)this.countRows("CDO_OBJECTS"));
        URI uriC1 = EcoreUtil.getURI((EObject)company);
        CDOID id = CDOUtil.getCDOObject((EObject)company).cdoID();
        Bugzilla_351068_Test.assertEquals((Object)company, (Object)transaction.getResourceSet().getEObject(uriC1, false));
        resource.getContents().remove((Object)company);
        Bugzilla_351068_Test.assertTransient((EObject)company);
        Bugzilla_351068_Test.assertSame((Object)company, (Object)CDOUtil.getEObject((EObject)transaction.getObject(id)));
        Bugzilla_351068_Test.assertSame((Object)company, (Object)transaction.getResourceSet().getEObject(uriC1, false));
        transaction.commit();
        Bugzilla_351068_Test.assertTransient((EObject)company);
        try {
            transaction.getObject(id);
            Bugzilla_351068_Test.fail((String)"ObjectNotFoundException expected");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        Bugzilla_351068_Test.assertNull((Object)transaction.getResourceSet().getEObject(uriC1, false));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_COMPANY"));
        Bugzilla_351068_Test.assertEquals((int)4, (int)this.countRows("CDO_OBJECTS"));
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Row counting")
    public void testDeleteWithChildren() throws Exception {
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/my/resource"));
        Company company = this.getModel1Factory().createCompany();
        company.getCategories().add((Object)this.getModel1Factory().createCategory());
        company.getCategories().add((Object)this.getModel1Factory().createCategory());
        company.getCategories().add((Object)this.getModel1Factory().createCategory());
        resource.getContents().add((Object)company);
        transaction.commit();
        Bugzilla_351068_Test.assertEquals((int)1, (int)this.countRows("MODEL1_COMPANY"));
        Bugzilla_351068_Test.assertEquals((int)3, (int)this.countRows("MODEL1_COMPANY_CATEGORIES_LIST"));
        Bugzilla_351068_Test.assertEquals((int)3, (int)this.countRows("MODEL1_CATEGORY"));
        Bugzilla_351068_Test.assertEquals((int)8, (int)this.countRows("CDO_OBJECTS"));
        URI uriC1 = EcoreUtil.getURI((EObject)company);
        CDOID id = CDOUtil.getCDOObject((EObject)company).cdoID();
        Bugzilla_351068_Test.assertEquals((Object)company, (Object)transaction.getResourceSet().getEObject(uriC1, false));
        resource.getContents().remove((Object)company);
        Bugzilla_351068_Test.assertTransient((EObject)company);
        Bugzilla_351068_Test.assertSame((Object)company, (Object)CDOUtil.getEObject((EObject)transaction.getObject(id)));
        Bugzilla_351068_Test.assertSame((Object)company, (Object)transaction.getResourceSet().getEObject(uriC1, false));
        transaction.commit();
        Bugzilla_351068_Test.assertTransient((EObject)company);
        try {
            transaction.getObject(id);
            Bugzilla_351068_Test.fail((String)"ObjectNotFoundException expected");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        Bugzilla_351068_Test.assertNull((Object)transaction.getResourceSet().getEObject(uriC1, false));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_COMPANY"));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_COMPANY_CATEGORIES_LIST"));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_CATEGORY"));
        Bugzilla_351068_Test.assertEquals((int)4, (int)this.countRows("CDO_OBJECTS"));
    }

    @ConfigTest.CleanRepositoriesBefore(reason="Row counting")
    public void testDeleteWithReferences() throws Exception {
        CDOSession session = this.openSession();
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource(this.getResourcePath("/my/resource"));
        Company company = this.getModel1Factory().createCompany();
        Customer customer = this.getModel1Factory().createCustomer();
        SalesOrder salesOrder1 = this.getModel1Factory().createSalesOrder();
        SalesOrder salesOrder2 = this.getModel1Factory().createSalesOrder();
        SalesOrder salesOrder3 = this.getModel1Factory().createSalesOrder();
        customer.getSalesOrders().add((Object)salesOrder1);
        customer.getSalesOrders().add((Object)salesOrder2);
        customer.getSalesOrders().add((Object)salesOrder3);
        company.getCustomers().add((Object)customer);
        company.getSalesOrders().add((Object)salesOrder1);
        company.getSalesOrders().add((Object)salesOrder2);
        company.getSalesOrders().add((Object)salesOrder3);
        resource.getContents().add((Object)company);
        transaction.commit();
        Bugzilla_351068_Test.assertEquals((int)1, (int)this.countRows("MODEL1_COMPANY"));
        Bugzilla_351068_Test.assertEquals((int)1, (int)this.countRows("MODEL1_CUSTOMER"));
        Bugzilla_351068_Test.assertEquals((int)3, (int)this.countRows("MODEL1_CUSTOMER_SALESORDERS_LIST"));
        Bugzilla_351068_Test.assertEquals((int)3, (int)this.countRows("MODEL1_SALESORDER"));
        Bugzilla_351068_Test.assertEquals((int)9, (int)this.countRows("CDO_OBJECTS"));
        URI uriC1 = EcoreUtil.getURI((EObject)company);
        CDOID id = CDOUtil.getCDOObject((EObject)company).cdoID();
        Bugzilla_351068_Test.assertEquals((Object)company, (Object)transaction.getResourceSet().getEObject(uriC1, false));
        resource.getContents().remove((Object)company);
        Bugzilla_351068_Test.assertTransient((EObject)company);
        Bugzilla_351068_Test.assertSame((Object)company, (Object)CDOUtil.getEObject((EObject)transaction.getObject(id)));
        Bugzilla_351068_Test.assertSame((Object)company, (Object)transaction.getResourceSet().getEObject(uriC1, false));
        transaction.commit();
        Bugzilla_351068_Test.assertTransient((EObject)company);
        try {
            transaction.getObject(id);
            Bugzilla_351068_Test.fail((String)"ObjectNotFoundException expected");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        Bugzilla_351068_Test.assertNull((Object)transaction.getResourceSet().getEObject(uriC1, false));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_COMPANY"));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_CUSTOMER"));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_CUSTOMER_SALESORDERS_LIST"));
        Bugzilla_351068_Test.assertEquals((int)0, (int)this.countRows("MODEL1_SALESORDER"));
        Bugzilla_351068_Test.assertEquals((int)4, (int)this.countRows("CDO_OBJECTS"));
    }

    private int countRows(String table) throws SQLException {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block2: {
            int n;
            connection = null;
            statement = null;
            resultSet = null;
            try {
                InternalRepository repository = this.getRepository();
                IDBStore store = (IDBStore)repository.getStore();
                connection = store.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT COUNT(1) FROM " + table);
                if (!resultSet.next()) break block2;
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close(statement);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)statement);
            DBUtil.close((Connection)connection);
            return n;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)statement);
        DBUtil.close((Connection)connection);
        return 0;
    }
}

