/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import org.eclipse.net4j.util.ref.KeyedReference;
import org.eclipse.net4j.util.ref.ReferenceType;

public class KeyedSoftReference<K, T>
extends SoftReference<T>
implements KeyedReference<K, T> {
    private K key;

    public KeyedSoftReference(K key, T ref) {
        super(ref);
        this.key = key;
    }

    public KeyedSoftReference(K key, T ref, ReferenceQueue<T> queue) {
        super(ref, queue);
        this.key = key;
    }

    @Override
    public ReferenceType getType() {
        return ReferenceType.SOFT;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public String toString() {
        return MessageFormat.format("KeyedSoftReference[{0} -> {1}]", this.key, this.isEnqueued() ? "ENQUEUED" : this.get());
    }
}

