/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeatureType;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping3;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBIndexAnnotation;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.IMappingConstants;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class AbstractBasicListTableMapping
implements IListMapping3,
IMappingConstants {
    private IMappingStrategy mappingStrategy;
    private EClass containingClass;
    private EStructuralFeature feature;

    public AbstractBasicListTableMapping(IMappingStrategy mappingStrategy, EClass containingClass, EStructuralFeature feature) {
        this.mappingStrategy = mappingStrategy;
        this.containingClass = containingClass;
        this.feature = feature;
    }

    public final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public final EClass getContainingClass() {
        return this.containingClass;
    }

    @Override
    public final EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void addSimpleChunkWhere(IDBStoreAccessor accessor, CDOID cdoid, StringBuilder builder, int index) {
        builder.append("CDO_IDX");
        builder.append('=');
        builder.append(index);
    }

    @Override
    public void addRangedChunkWhere(IDBStoreAccessor accessor, CDOID cdoid, StringBuilder builder, int fromIndex, int toIndex) {
        builder.append("CDO_IDX");
        builder.append(" BETWEEN ");
        builder.append(fromIndex);
        builder.append(" AND ");
        builder.append(toIndex - 1);
    }

    @Override
    public void setClassMapping(IClassMapping classMapping) {
    }

    public abstract void rawDeleted(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, int var4);

    protected final boolean needsIndexOnValueField(EStructuralFeature feature) {
        IMappingStrategy mappingStrategy = this.getMappingStrategy();
        Set<CDOFeatureType> forceIndexes = AbstractMappingStrategy.getForceIndexes(mappingStrategy);
        if (CDOFeatureType.matchesCombination((EStructuralFeature)feature, forceIndexes)) {
            return true;
        }
        EClass eClass = this.getContainingClass();
        EStructuralFeature[] allPersistentFeatures = CDOModelUtil.getClassInfo((EClass)eClass).getAllPersistentFeatures();
        for (List<EStructuralFeature> features : DBIndexAnnotation.getIndices(eClass, allPersistentFeatures)) {
            if (features.size() != 1 || features.get(0) != feature) continue;
            return true;
        }
        return false;
    }

    public static abstract class AbstractListDeltaWriter
    implements CDOFeatureDeltaVisitor {
        private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractListDeltaWriter.class);
        private static final int UNBOUNDED_SHIFT = -1;
        private static final int NO_INDEX = Integer.MIN_VALUE;
        private static final int NONE = 0;
        private static final int SET = 2;
        private static final int MOVE = 4;
        private static final int INSERT = 8;
        private static final int DELETE = 16;
        protected final IDBStoreAccessor accessor;
        protected final CDOID id;
        private final List<CDOFeatureDelta> listChanges;
        private final List<Manipulation> manipulations;
        private boolean clearFirst;
        private int offsetBefore;
        private int tmpIndex = -1;
        private int newListSize;

        public AbstractListDeltaWriter(IDBStoreAccessor accessor, CDOID id, List<CDOFeatureDelta> listChanges, int oldListSize) {
            this.accessor = accessor;
            this.id = id;
            this.listChanges = listChanges;
            this.manipulations = this.createManipulations(id, listChanges, oldListSize);
            this.newListSize = oldListSize;
        }

        public void writeListDeltas() {
            if (TRACER.isEnabled()) {
                TRACER.trace("Processing list deltas...");
            }
            for (CDOFeatureDelta listDelta : this.listChanges) {
                listDelta.accept((CDOFeatureDeltaVisitor)this);
            }
            if (!this.isZeroBasedIndex()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Optimizing list indexes...");
                }
                this.optimizeListIndexes();
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Result to be written to DB:");
                for (Manipulation manipulation : this.manipulations) {
                    TRACER.trace(manipulation.toString());
                }
            }
            try {
                this.writeResultToDatabase();
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            throw new NewListSizeResult(this.newListSize);
        }

        public void visit(CDOAddFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - insert at {0} value {1}", new Object[]{delta.getIndex(), delta.getValue()});
            }
            this.shiftIndexes(delta.getIndex(), -1, 1);
            this.manipulations.add(Manipulation.createInsertedElement(delta.getIndex(), delta.getValue()));
            ++this.newListSize;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - remove at {0}", new Object[]{delta.getIndex()});
            }
            Manipulation e = this.findManipulation(delta.getIndex());
            this.deleteItem(e);
            this.shiftIndexes(delta.getIndex() + 1, -1, -1);
            --this.newListSize;
        }

        public void visit(CDOSetFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - set at {0} value {1}", new Object[]{delta.getIndex(), delta.getValue()});
            }
            Manipulation manipulation = this.findManipulation(delta.getIndex());
            manipulation.value = delta.getValue();
            if (!manipulation.is(8)) {
                manipulation.addType(2);
            }
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (!delta.getFeature().isUnsettable()) {
                throw new IllegalArgumentException("Feature is not unsettable: " + delta);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("  - unset list", new Object[0]);
            }
            this.clearFirst = true;
            this.manipulations.clear();
            this.newListSize = 0;
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - clear list", new Object[0]);
            }
            this.clearFirst = true;
            this.manipulations.clear();
            this.newListSize = 0;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("  - move {0} -> {1}", new Object[]{fromIdx, toIdx});
            }
            if (fromIdx == toIdx) {
                return;
            }
            Manipulation manipulation = this.findManipulation(fromIdx);
            if (fromIdx < toIdx) {
                this.shiftIndexes(fromIdx + 1, toIdx, -1);
            } else {
                this.shiftIndexes(toIdx, fromIdx - 1, 1);
            }
            manipulation.dstIndex = toIdx;
            if (!manipulation.is(8)) {
                manipulation.addType(4);
            }
        }

        @Deprecated
        public void visit(CDOListFeatureDelta delta) {
            throw new UnsupportedOperationException("Should never be called");
        }

        @Deprecated
        public void visit(CDOContainerFeatureDelta delta) {
            throw new UnsupportedOperationException("Should never be called");
        }

        protected boolean isZeroBasedIndex() {
            return false;
        }

        protected List<Manipulation> createManipulations(CDOID id, List<CDOFeatureDelta> listChanges, int oldListSize) {
            ArrayList<Manipulation> manipulations = new ArrayList<Manipulation>(oldListSize);
            int i = 0;
            while (i < oldListSize) {
                manipulations.add(Manipulation.createOriginalElement(i));
                ++i;
            }
            return manipulations;
        }

        private void shiftIndexes(int from, int to, int offset) {
            for (Manipulation manipulation : this.manipulations) {
                if (manipulation.dstIndex < from || to != -1 && manipulation.dstIndex > to) continue;
                manipulation.dstIndex += offset;
            }
        }

        private Manipulation findManipulation(int index) {
            for (Manipulation manipulation : this.manipulations) {
                if (manipulation.dstIndex != index) continue;
                return manipulation;
            }
            throw new IllegalStateException("Should never be reached");
        }

        private void deleteItem(Manipulation manipulation) {
            if (manipulation.is(8)) {
                this.manipulations.remove(manipulation);
            } else {
                manipulation.types = 16;
                manipulation.dstIndex = Integer.MIN_VALUE;
            }
        }

        private void optimizeListIndexes() {
            this.offsetBefore = this.getCurrentIndexOffset();
            if (TRACER.isEnabled()) {
                TRACER.trace("Offset optimization.");
                TRACER.trace("Current offset = " + this.offsetBefore);
            }
            this.applyOffsetToSourceIndexes(this.offsetBefore);
            int offsetAfter = (long)Math.abs(this.offsetBefore) + (long)this.manipulations.size() > Integer.MAX_VALUE ? 0 : this.calculateOptimalOffset();
            if (TRACER.isEnabled()) {
                TRACER.trace("New offset = " + offsetAfter);
            }
            this.applyOffsetToDestinationIndexes(offsetAfter);
            this.tmpIndex = Math.min(this.offsetBefore, offsetAfter) - 1;
        }

        private int calculateOptimalOffset() {
            HashMap<Integer, Integer> occurrences = new HashMap<Integer, Integer>();
            int bestOffset = 0;
            int bestOffsetOccurrence = 0;
            for (Manipulation manipulation : this.manipulations) {
                int srcIndex = manipulation.srcIndex;
                int dstIndex = manipulation.dstIndex;
                if (srcIndex == Integer.MIN_VALUE || dstIndex == Integer.MIN_VALUE) continue;
                int offset = dstIndex - srcIndex;
                Integer oldOccurrence = (Integer)occurrences.get(offset);
                int newOccurrence = oldOccurrence == null ? 1 : oldOccurrence + 1;
                occurrences.put(offset, newOccurrence);
                if (newOccurrence <= bestOffsetOccurrence) continue;
                bestOffsetOccurrence = newOccurrence;
                bestOffset = offset;
            }
            return -bestOffset;
        }

        private void applyOffsetToSourceIndexes(int offsetBefore) {
            if (offsetBefore != 0) {
                for (Manipulation manipulation : this.manipulations) {
                    if (manipulation.srcIndex == Integer.MIN_VALUE) continue;
                    manipulation.srcIndex += offsetBefore;
                }
            }
        }

        private void applyOffsetToDestinationIndexes(int offsetAfter) {
            if (offsetAfter != 0) {
                for (Manipulation manipulation : this.manipulations) {
                    if (manipulation.dstIndex == Integer.MIN_VALUE) continue;
                    manipulation.dstIndex += offsetAfter;
                }
            }
        }

        protected final int getOffsetBefore() {
            return this.offsetBefore;
        }

        protected final int getNextTmpIndex() {
            return --this.tmpIndex;
        }

        protected void writeResultToDatabase() throws SQLException {
            IIDHandler idHandler = this.accessor.getStore().getIDHandler();
            if (TRACER.isEnabled()) {
                TRACER.trace("Writing to database:");
            }
            if (this.clearFirst) {
                if (TRACER.isEnabled()) {
                    TRACER.trace(" - clear list");
                }
                this.clearList();
            }
            for (Manipulation manipulation : this.manipulations) {
                if (manipulation.is(16)) {
                    this.dbDelete(idHandler, manipulation.srcIndex);
                    if (TRACER.isEnabled()) {
                        TRACER.format(" - delete at {0} ", new Object[]{manipulation.srcIndex});
                    }
                }
                if (!manipulation.is(4)) continue;
                manipulation.tmpIndex = this.getNextTmpIndex();
                this.dbMove(idHandler, manipulation.srcIndex, manipulation.tmpIndex, manipulation.srcIndex);
                if (!TRACER.isEnabled()) continue;
                TRACER.format(" - move {0} -> {1} ", new Object[]{manipulation.srcIndex, manipulation.tmpIndex});
            }
            this.writeShifts(idHandler);
            ITypeMapping typeMapping = this.getTypeMapping();
            for (Manipulation manipulation : this.manipulations) {
                if (manipulation.is(4)) {
                    this.dbMove(idHandler, manipulation.tmpIndex, manipulation.dstIndex, manipulation.srcIndex);
                    if (TRACER.isEnabled()) {
                        TRACER.format(" - move {0} -> {1} ", new Object[]{manipulation.tmpIndex, manipulation.dstIndex});
                    }
                }
                if (manipulation.is(2)) {
                    this.dbSet(idHandler, typeMapping, manipulation.dstIndex, manipulation.value, manipulation.srcIndex);
                    if (TRACER.isEnabled()) {
                        TRACER.format(" - set value at {0} to {1} ", new Object[]{manipulation.dstIndex, manipulation.value});
                    }
                }
                if (!manipulation.is(8)) continue;
                this.dbInsert(idHandler, typeMapping, manipulation.dstIndex, manipulation.value);
                if (!TRACER.isEnabled()) continue;
                TRACER.format(" - insert value at {0} : value {1} ", new Object[]{manipulation.dstIndex, manipulation.value});
            }
        }

        protected void writeShifts(IIDHandler idHandler) throws SQLException {
            LinkedList<Shift> shiftOperations = new LinkedList<Shift>();
            int rangeStartIndex = Integer.MIN_VALUE;
            int rangeOffset = 0;
            int lastElementIndex = Integer.MIN_VALUE;
            for (Manipulation manipulation : this.manipulations) {
                if (manipulation.types == 0 || manipulation.types == 2) {
                    int elementOffset = manipulation.dstIndex - manipulation.srcIndex;
                    if (elementOffset != rangeOffset && rangeStartIndex != Integer.MIN_VALUE) {
                        shiftOperations.add(new Shift(rangeStartIndex, lastElementIndex, rangeOffset));
                        rangeStartIndex = Integer.MIN_VALUE;
                        rangeOffset = 0;
                    }
                    if (elementOffset != 0 && rangeStartIndex == Integer.MIN_VALUE) {
                        rangeStartIndex = manipulation.srcIndex;
                        rangeOffset = elementOffset;
                    }
                } else if (rangeStartIndex != Integer.MIN_VALUE) {
                    shiftOperations.add(new Shift(rangeStartIndex, lastElementIndex, rangeOffset));
                    rangeStartIndex = Integer.MIN_VALUE;
                    rangeOffset = 0;
                }
                lastElementIndex = manipulation.srcIndex;
            }
            if (rangeStartIndex != Integer.MIN_VALUE) {
                shiftOperations.add(new Shift(rangeStartIndex, lastElementIndex, rangeOffset));
            }
            ListIterator<Shift> operationIt = shiftOperations.listIterator();
            this.writeShiftsDown(idHandler, operationIt);
            this.writeShiftsUp(idHandler, operationIt);
        }

        protected void writeShiftsDown(IIDHandler idHandler, ListIterator<Shift> operationIt) throws SQLException {
            while (operationIt.hasNext()) {
                Shift operation = operationIt.next();
                if (operation.offset >= 0) continue;
                this.dbShiftDown(idHandler, operation.offset, operation.startIndex, operation.endIndex);
                if (TRACER.isEnabled()) {
                    TRACER.format(" - shift down {0} ", new Object[]{operation});
                }
                operationIt.remove();
            }
        }

        protected void writeShiftsUp(IIDHandler idHandler, ListIterator<Shift> operationIt) throws SQLException {
            while (operationIt.hasPrevious()) {
                Shift operation = operationIt.previous();
                this.dbShiftUp(idHandler, operation.offset, operation.startIndex, operation.endIndex);
                if (!TRACER.isEnabled()) continue;
                TRACER.format(" - shift up {0} ", new Object[]{operation});
            }
        }

        protected abstract void dbDelete(IIDHandler var1, int var2) throws SQLException;

        protected abstract void dbMove(IIDHandler var1, int var2, int var3, int var4) throws SQLException;

        protected abstract void dbSet(IIDHandler var1, ITypeMapping var2, int var3, Object var4, int var5) throws SQLException;

        protected abstract void dbInsert(IIDHandler var1, ITypeMapping var2, int var3, Object var4) throws SQLException;

        protected abstract void dbShiftDown(IIDHandler var1, int var2, int var3, int var4) throws SQLException;

        protected abstract void dbShiftUp(IIDHandler var1, int var2, int var3, int var4) throws SQLException;

        protected static void close(PreparedStatement ... stmts) {
            Throwable t = null;
            PreparedStatement[] preparedStatementArray = stmts;
            int n = stmts.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    PreparedStatement stmt = preparedStatementArray[n2];
                    try {
                        if (stmt == null) break block10;
                        try {
                            try {
                                stmt.clearBatch();
                            }
                            catch (SQLException e) {
                                throw new DBException((Throwable)e);
                            }
                        }
                        finally {
                            DBUtil.close((Statement)stmt);
                        }
                    }
                    catch (Throwable th) {
                        if (t == null) {
                            t = th;
                        }
                        OM.LOG.error(t);
                    }
                }
                ++n2;
            }
            if (t != null) {
                throw new DBException(t);
            }
        }

        protected abstract ITypeMapping getTypeMapping();

        protected abstract int getCurrentIndexOffset();

        protected abstract void clearList();

        public static final class Manipulation {
            private static final Object NIL = new Object(){

                public String toString() {
                    return "NIL";
                }
            };
            public int types;
            public int srcIndex;
            public int tmpIndex;
            public int dstIndex;
            public Object value;

            public Manipulation(int types, int srcIndex, int dstIndex, Object value) {
                this.types = types;
                this.srcIndex = srcIndex;
                this.tmpIndex = Integer.MIN_VALUE;
                this.dstIndex = dstIndex;
                this.value = value;
            }

            public boolean is(int type) {
                return type == 0 ? this.types == 0 : (this.types & type) != 0;
            }

            public void addType(int type) {
                this.types |= type;
            }

            public String toString() {
                return MessageFormat.format("Manipulation[types={0}, srcIndex={1}, tmpIndex={2}, dstIndex={3}, value={4}]", Manipulation.formatTypes(this.types), Manipulation.formatIndex(this.srcIndex), Manipulation.formatIndex(this.tmpIndex), Manipulation.formatIndex(this.dstIndex), String.valueOf(this.value));
            }

            public static Manipulation createOriginalElement(int index) {
                return new Manipulation(0, index, index, NIL);
            }

            public static Manipulation createInsertedElement(int index, Object value) {
                return new Manipulation(8, Integer.MIN_VALUE, index, value);
            }

            private static String formatTypes(int types) {
                StringBuilder builder = new StringBuilder();
                Manipulation.formatType(types, 16, "DELETE", builder);
                Manipulation.formatType(types, 8, "INSERT", builder);
                Manipulation.formatType(types, 4, "MOVE", builder);
                Manipulation.formatType(types, 2, "SET", builder);
                if (builder.length() != 0) {
                    return builder.toString();
                }
                return "NONE";
            }

            private static void formatType(int types, int type, String label, StringBuilder builder) {
                if ((types & type) != 0) {
                    StringUtil.appendSeparator((StringBuilder)builder, (char)'|');
                    builder.append(label);
                }
            }

            private static String formatIndex(int index) {
                if (index == Integer.MIN_VALUE) {
                    return "NONE";
                }
                return Integer.toString(index);
            }
        }

        public static final class NewListSizeResult
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final int newListSize;

            public NewListSizeResult(int newListSize) {
                this.newListSize = newListSize;
            }

            public int getNewListSize() {
                return this.newListSize;
            }
        }

        public static final class Shift {
            public final int startIndex;
            public final int endIndex;
            public final int offset;

            public Shift(int startIndex, int endIndex, int offset) {
                this.startIndex = startIndex;
                this.endIndex = endIndex;
                this.offset = offset;
            }

            public String toString() {
                return "Shift[" + this.startIndex + ".." + this.endIndex + ", offset=" + this.offset + "]";
            }
        }
    }
}

