/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.client;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Dependency;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamSpec;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.util.LMMerger;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.net4j.util.StringUtil;

public interface ISystemDescriptor
extends Comparable<ISystemDescriptor> {
    public CDORepository getSystemRepository();

    public String getSystemName();

    public System getSystem();

    public String getError();

    public State getState();

    public boolean isOpen();

    public void open();

    public void close();

    public <E extends ModelElement, R> R modify(E var1, Function<E, R> var2, IProgressMonitor var3) throws ConcurrentAccessException, CommitException;

    public <R> R modify(Function<System, R> var1, IProgressMonitor var2) throws ConcurrentAccessException, CommitException;

    public CDORepository getModuleRepository(String var1);

    public boolean withModuleSession(String var1, Consumer<CDOSession> var2);

    public ModuleDefinition extractModuleDefinition(Baseline var1);

    public ModuleDefinition extractModuleDefinition(FloatingBaseline var1, long var2);

    public ModuleDefinition extractModuleDefinition(CDOView var1);

    public Assembly resolve(ModuleDefinition var1, Baseline var2, IProgressMonitor var3) throws ResolutionException;

    public Module createModule(String var1, StreamSpec var2, IProgressMonitor var3) throws ConcurrentAccessException, CommitException;

    public Module createModule(String var1, ModuleType var2, StreamSpec var3, IProgressMonitor var4) throws ConcurrentAccessException, CommitException;

    public void deleteModule(Module var1, IProgressMonitor var2) throws ConcurrentAccessException, CommitException, ModuleDeletionException;

    public Stream createStream(Module var1, Drop var2, StreamSpec var3, IProgressMonitor var4) throws ConcurrentAccessException, CommitException;

    public Drop createDrop(Stream var1, DropType var2, long var3, String var5, IProgressMonitor var6) throws ConcurrentAccessException, CommitException;

    public Change createChange(Stream var1, FixedBaseline var2, String var3, IProgressMonitor var4) throws ConcurrentAccessException, CommitException;

    public void renameChange(Change var1, String var2, IProgressMonitor var3) throws ConcurrentAccessException, CommitException;

    public void deleteChange(Change var1, IProgressMonitor var2) throws ConcurrentAccessException, CommitException;

    public Delivery createDelivery(Stream var1, Change var2, LMMerger var3, IProgressMonitor var4) throws ConcurrentAccessException, CommitException;

    public static final class ModuleDeletionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ModuleDeletionException(String deletedModuleName, List<CDOObjectReference> references) {
            super(ModuleDeletionException.createMessage(deletedModuleName, references));
        }

        private static String createMessage(String deletedModuleName, List<CDOObjectReference> references) {
            StringBuilder builder = new StringBuilder();
            for (CDOObjectReference reference : references) {
                CDOObject sourceObject = (CDOObject)reference.getSourceObject();
                if (!(sourceObject instanceof Dependency)) continue;
                Dependency dep = (Dependency)sourceObject;
                String dependencyName = dep.getModule().getName();
                StringUtil.appendSeparator((StringBuilder)builder, (String)",\n");
                builder.append(dependencyName);
            }
            return MessageFormat.format("The module {0} can not be deleted because the following modules depend on it:\n{1}", deletedModuleName, builder);
        }
    }

    public static final class ResolutionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Reason[] reasons;

        public ResolutionException(Reason[] reasons) {
            super(ResolutionException.formatMessage(reasons));
            this.reasons = reasons;
        }

        public Reason[] getReasons() {
            return this.reasons;
        }

        private static String formatMessage(Reason[] reasons) {
            StringBuilder builder = new StringBuilder("The module definition could not be resolved");
            if (reasons != null && reasons.length != 0) {
                builder.append(':');
                Reason[] reasonArray = reasons;
                int n = reasons.length;
                int n2 = 0;
                while (n2 < n) {
                    Reason reason = reasonArray[n2];
                    builder.append(StringUtil.NL);
                    builder.append("   ");
                    builder.append(reason);
                    ++n2;
                }
            }
            return builder.toString();
        }

        public static abstract class Reason {

            public static final class Conflicting
            extends Reason {
                public final Module[] modules;

                public Conflicting(Module[] modules) {
                    this.modules = modules;
                }

                public Module[] getModules() {
                    return this.modules;
                }

                public String toString() {
                    return MessageFormat.format("Only one of the following can be installed at once: {0}", Arrays.asList(this.modules));
                }
            }

            public static final class Dependency {
                public final String name;
                public final VersionRange versionRange;

                public Dependency(String name, VersionRange versionRange) {
                    this.name = name;
                    this.versionRange = versionRange;
                }

                public String toString() {
                    return String.valueOf(this.name) + " " + this.versionRange;
                }
            }

            public static final class Missing
            extends Reason {
                public final Module module;
                public final Dependency dependency;

                public Missing(Module module, Dependency dependency) {
                    this.module = module;
                    this.dependency = dependency;
                }

                public Module getModule() {
                    return this.module;
                }

                public Dependency getDependency() {
                    return this.dependency;
                }

                public boolean isEntryPoint() {
                    return this.dependency == null;
                }

                public String toString() {
                    if (this.isEntryPoint()) {
                        return MessageFormat.format("You requested to install \"{0}\" but it could not be found", this.module);
                    }
                    return MessageFormat.format("Missing dependency: {0} requires \"{1}\" but it could not be found", this.module, this.dependency);
                }
            }

            public static final class Module {
                public final String name;
                public final Version version;

                public Module(String name, Version version) {
                    this.name = name;
                    this.version = version;
                }

                public String toString() {
                    return String.valueOf(this.name) + " " + this.version;
                }
            }
        }
    }

    public static enum State {
        Opening,
        Open,
        Closing,
        Closed;

    }
}

