/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.util.List;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.ecore.EStructuralFeature;

public interface IStoreChunkReader {
    public IStoreAccessor getAccessor();

    public CDORevision getRevision();

    public EStructuralFeature getFeature();

    public void addSimpleChunk(int var1);

    public void addRangedChunk(int var1, int var2);

    public List<Chunk> executeRead();

    public static class Chunk {
        private int startIndex;
        private Object ids;

        public Chunk(int startIndex) {
            this.startIndex = startIndex;
        }

        public Chunk(int startIndex, int size) {
            this(startIndex);
            this.ids = new Object[size];
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int size() {
            return this.ids instanceof Object[] ? ((Object[])this.ids).length : 1;
        }

        public Object get(int indexInChunk) {
            if (this.ids instanceof Object[]) {
                return ((Object[])this.ids)[indexInChunk];
            }
            if (indexInChunk == 0) {
                return this.ids;
            }
            throw new ArrayIndexOutOfBoundsException(indexInChunk);
        }

        public void add(int indexInChunk, Object value) {
            if (!(this.ids instanceof Object[])) {
                if (indexInChunk == 0) {
                    this.ids = value;
                    return;
                }
                throw new ArrayIndexOutOfBoundsException(indexInChunk);
            }
            ((Object[])this.ids)[indexInChunk] = value;
        }
    }
}

