/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.RunnableViewerRefresh;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ItemProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public abstract class CDOContentProvider<CONTEXT>
implements ITreeContentProvider {
    private static final Set<Object> LOADING_OBJECTS = new HashSet<Object>();
    private static final Method GET_CHILDREN_FEATURES_METHOD = CDOContentProvider.getMethod(ItemProviderAdapter.class, "getChildrenFeatures", Object.class);
    private static final Method FIND_ITEM_METHOD = CDOContentProvider.getMethod(StructuredViewer.class, "findItem", Object.class);
    private final Map<Object, Object[]> childrenCache = new ConcurrentHashMap<Object, Object[]>();
    private TreeViewer viewer;
    private Object input;
    private boolean hideObjects;

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    public final boolean isHideObjects() {
        return this.hideObjects;
    }

    public final void setHideObjects(boolean hideObjects) {
        boolean oldValue = this.hideObjects;
        if (hideObjects != oldValue) {
            this.hideObjects = hideObjects;
            if (this.viewer != null) {
                UIUtil.asyncExec((Display)this.viewer.getControl().getDisplay(), () -> UIUtil.refreshViewer((Viewer)this.viewer));
            }
        }
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        TreeViewer newTreeViewer = null;
        if (newViewer instanceof TreeViewer) {
            newTreeViewer = (TreeViewer)newViewer;
        }
        if (newTreeViewer != this.viewer) {
            if (this.viewer != null) {
                this.unhookViewer(this.viewer);
            }
            this.viewer = newTreeViewer;
            if (this.viewer != null) {
                this.hookViewer(this.viewer);
            }
        }
        this.input = newInput;
    }

    public Object getInput() {
        return this.input;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object object) {
        try {
            ITreeContentProvider contentProvider;
            InternalCDORevision revision;
            EObject eObject;
            InternalCDOObject cdoObject;
            CDOResource resource;
            if (object instanceof ViewerUtil.Pending) {
                return false;
            }
            if (this.hideObjects && object instanceof CDOResource && !(resource = (CDOResource)object).isRoot()) {
                return false;
            }
            if (this.isContext(object)) {
                Object context = object;
                switch (this.getContextState(context)) {
                    case Closed: {
                        return false;
                    }
                    case Opening: {
                        return true;
                    }
                    case Open: {
                        object = this.getRootObject(context);
                        break;
                    }
                }
            }
            if (object instanceof CDOElement) {
                CDOElement element = (CDOElement)object;
                return element.hasChildren();
            }
            if (GET_CHILDREN_FEATURES_METHOD != null && object instanceof EObject && (cdoObject = CDOContentProvider.getCDOObject(eObject = (EObject)object)) != null && (revision = cdoObject.cdoRevision(false)) != null) {
                try {
                    ITreeItemContentProvider provider = (ITreeItemContentProvider)this.adapt(object, ITreeItemContentProvider.class);
                    if (provider instanceof ItemProviderAdapter) {
                        return CDOContentProvider.hasChildren(cdoObject, revision, (ItemProviderAdapter)provider);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((contentProvider = this.getContentProvider(object)) == null) return false;
            return contentProvider.hasChildren(object);
        }
        catch (NoPermissionException | LifecycleException contentProvider) {
            return false;
        }
        catch (RuntimeException ex) {
            if (!LifecycleUtil.isActive((Object)object)) return false;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object) {
        block27: {
            try {
                boolean firstLoad;
                CDOResource resource;
                if (object instanceof ViewerUtil.Pending) {
                    return ViewerUtil.NO_CHILDREN;
                }
                if (this.hideObjects && object instanceof CDOResource && !(resource = (CDOResource)object).isRoot()) {
                    return ViewerUtil.NO_CHILDREN;
                }
                if (object instanceof CDOElement) {
                    CDOElement element = (CDOElement)object;
                    return element.getChildren();
                }
                final Object originalObject = object;
                Object[] children = this.childrenCache.remove(originalObject);
                if (children != null) {
                    return children;
                }
                Object openingContext = null;
                if (this.isContext(object)) {
                    Object context = object;
                    switch (this.getContextState(context)) {
                        case Closed: {
                            return ViewerUtil.NO_CHILDREN;
                        }
                        case Opening: {
                            openingContext = context;
                            break;
                        }
                        case Open: {
                            object = this.getRootObject(context);
                        }
                    }
                }
                final Object finalObject = object;
                final Object finalOpeningContext = openingContext;
                final ITreeContentProvider contentProvider = this.getContentProvider(finalObject);
                if (contentProvider == null) {
                    return ItemProvider.NO_ELEMENTS;
                }
                final ArrayList<CDORevision> loadedRevisions = new ArrayList<CDORevision>();
                final ArrayList<CDOID> missingIDs = new ArrayList<CDOID>();
                if (finalOpeningContext == null && (children = this.determineChildRevisions(object, loadedRevisions, missingIDs)) != null) {
                    return this.modifyChildren(object, children);
                }
                Set<Object> set = LOADING_OBJECTS;
                synchronized (set) {
                    firstLoad = LOADING_OBJECTS.add(originalObject);
                }
                if (firstLoad || finalOpeningContext == null) {
                    Job job = new Job("Load " + finalObject){

                        protected IStatus run(IProgressMonitor monitor) {
                            block8: {
                                CDOView view = null;
                                try {
                                    if (finalOpeningContext != null) {
                                        CDOContentProvider.this.openContext(finalOpeningContext);
                                        CDOContentProvider.this.determineChildRevisions(finalObject, loadedRevisions, missingIDs);
                                    }
                                    if (!missingIDs.isEmpty()) {
                                        InternalCDOObject cdoObject = CDOContentProvider.getCDOObject((EObject)finalObject);
                                        view = cdoObject.cdoView();
                                        CDORevisionManager revisionManager = view.getSession().getRevisionManager();
                                        List revisions = revisionManager.getRevisions(missingIDs, (CDOBranchPoint)view, -1, 0, true);
                                        loadedRevisions.addAll(revisions);
                                    }
                                    Object[] children = contentProvider.getChildren(finalObject);
                                    int i = 0;
                                    while (i < children.length) {
                                        InternalCDOObject cdoObject;
                                        InternalEObject instance;
                                        Object child = children[i];
                                        if (child instanceof InternalCDOObject && (instance = (cdoObject = (InternalCDOObject)child).cdoInternalInstance()) != cdoObject) {
                                            children[i] = instance;
                                        }
                                        ++i;
                                    }
                                    children = CDOContentProvider.this.modifyChildren(finalObject, children);
                                    CDOContentProvider.this.childrenCache.put(originalObject, children);
                                }
                                catch (Exception ex) {
                                    InternalCDOObject cdoObject;
                                    CDOContentProvider.this.childrenCache.put(originalObject, new Object[]{new ViewerUtil.Error(originalObject, ex.getMessage())});
                                    if (finalOpeningContext != null) {
                                        CDOContentProvider.this.closeContext(finalOpeningContext);
                                    }
                                    if (view == null && finalObject instanceof EObject && (cdoObject = CDOContentProvider.getCDOObject((EObject)finalObject)) != null) {
                                        view = cdoObject.cdoView();
                                    }
                                    if (view != null && view.isClosed()) break block8;
                                    OM.LOG.error((Throwable)ex);
                                }
                            }
                            RunnableViewerRefresh viewerRefresh = CDOContentProvider.this.getViewerRefresh();
                            viewerRefresh.addNotification(originalObject, true, true, () -> {
                                Set<Object> set = LOADING_OBJECTS;
                                synchronized (set) {
                                    LOADING_OBJECTS.remove(originalObject);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                if (FIND_ITEM_METHOD != null) {
                    try {
                        TreeItem item;
                        TreeItem[] childItems;
                        int childCount;
                        Object widget = FIND_ITEM_METHOD.invoke((Object)this.viewer, originalObject);
                        if (widget instanceof TreeItem && (childCount = (childItems = (item = (TreeItem)widget).getItems()).length) != 0) {
                            ArrayList<Object> result = new ArrayList<Object>();
                            int i = 0;
                            while (i < childCount) {
                                TreeItem childItem = childItems[i];
                                Object child = childItem.getData();
                                if (child != null) {
                                    result.add(child);
                                }
                                ++i;
                            }
                            int size = result.size();
                            if (size != 0) {
                                return result.toArray(new Object[size]);
                            }
                        }
                    }
                    catch (Exception widget) {
                        // empty catch block
                    }
                }
                String text = "Loading...";
                if (finalOpeningContext != null) {
                    text = "Opening...";
                }
                return new Object[]{new ViewerUtil.Pending(originalObject, text)};
            }
            catch (NoPermissionException | LifecycleException originalObject) {
            }
            catch (RuntimeException ex) {
                if (!LifecycleUtil.isActive((Object)object)) break block27;
                throw ex;
            }
        }
        return ItemProvider.NO_ELEMENTS;
    }

    public Object getParent(Object object) {
        block8: {
            try {
                if (object instanceof ViewerUtil.Pending) {
                    return ((ViewerUtil.Pending)object).getParent();
                }
                if (object instanceof CDOElement) {
                    CDOElement element = (CDOElement)object;
                    return element.getParent();
                }
                if (object instanceof EObject) {
                    EObject eObject = CDOUtil.getEObject((EObject)((EObject)object));
                    CDOElement element = CDOElement.getFor((Object)eObject);
                    if (element != null) {
                        return element;
                    }
                    ITreeContentProvider contentProvider = this.getContentProvider(object);
                    if (contentProvider != null) {
                        return contentProvider.getParent(object);
                    }
                }
            }
            catch (NoPermissionException | LifecycleException eObject) {
            }
            catch (RuntimeException ex) {
                if (!LifecycleUtil.isActive((Object)object)) break block8;
                throw ex;
            }
        }
        return null;
    }

    protected void hookViewer(TreeViewer viewer) {
    }

    protected void unhookViewer(TreeViewer viewer) {
    }

    protected abstract Object adapt(Object var1, Object var2);

    protected abstract Object[] modifyChildren(Object var1, Object[] var2);

    protected abstract ITreeContentProvider getContentProvider(Object var1);

    protected abstract RunnableViewerRefresh getViewerRefresh();

    protected abstract boolean isContext(Object var1);

    protected abstract ContextState getContextState(CONTEXT var1);

    protected abstract void openContext(CONTEXT var1);

    protected abstract void closeContext(CONTEXT var1);

    protected abstract Object getRootObject(CONTEXT var1);

    private Object[] determineChildRevisions(Object object, List<CDORevision> loadedRevisions, List<CDOID> missingIDs) {
        if (object instanceof EObject) {
            InternalCDORevision revision;
            EObject eObject;
            InternalCDOObject cdoObject;
            if (GET_CHILDREN_FEATURES_METHOD != null && (cdoObject = CDOContentProvider.getCDOObject(eObject = (EObject)object)) != null && (revision = cdoObject.cdoRevision(false)) != null) {
                try {
                    ITreeItemContentProvider provider = (ITreeItemContentProvider)this.adapt(object, ITreeItemContentProvider.class);
                    if (provider instanceof ItemProviderAdapter) {
                        ITreeContentProvider contentProvider;
                        CDOContentProvider.determineChildRevisions(cdoObject, revision, (ItemProviderAdapter)provider, loadedRevisions, missingIDs);
                        if (missingIDs.isEmpty() && (contentProvider = this.getContentProvider(object)) != null) {
                            return contentProvider.getChildren(object);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        } else if (object instanceof ResourceSet) {
            EList resources = ((ResourceSet)object).getResources();
            return resources.toArray((Object[])new Resource[resources.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isObjectLoading(Object ... objects) {
        Set<Object> set = LOADING_OBJECTS;
        synchronized (set) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Object object = objectArray[n2];
                if (LOADING_OBJECTS.contains(object)) {
                    return true;
                }
                ++n2;
            }
        }
    }

    private static InternalCDOObject getCDOObject(EObject eObject) {
        return (InternalCDOObject)CDOUtil.getCDOObject((EObject)eObject, (boolean)false);
    }

    private static boolean hasChildren(InternalCDOObject cdoObject, InternalCDORevision revision, ItemProviderAdapter provider) throws Exception {
        for (EStructuralFeature feature : CDOContentProvider.getChildrenFeatures(cdoObject, provider)) {
            if (!(feature.isMany() ? !revision.isEmpty(feature) : revision.getValue(feature) != null)) continue;
            return true;
        }
        return false;
    }

    private static void determineChildRevisions(InternalCDOObject cdoObject, InternalCDORevision revision, ItemProviderAdapter provider, List<CDORevision> loadedRevisions, List<CDOID> missingIDs) throws Exception {
        InternalCDOView view = cdoObject.cdoView();
        InternalCDORevisionCache revisionCache = view.getSession().getRevisionManager().getCache();
        for (EStructuralFeature feature : CDOContentProvider.getChildrenFeatures(cdoObject, provider)) {
            if (feature.isMany()) {
                CDOList list = revision.getListOrNull(feature);
                if (list == null) continue;
                for (Object object : list) {
                    CDOContentProvider.determineChildRevision(loadedRevisions, missingIDs, view, revisionCache, object);
                }
                continue;
            }
            Object value = revision.getValue(feature);
            CDOContentProvider.determineChildRevision(loadedRevisions, missingIDs, view, revisionCache, value);
        }
    }

    private static void determineChildRevision(List<CDORevision> loadedRevisions, List<CDOID> missingIDs, InternalCDOView view, InternalCDORevisionCache cache, Object object) {
        if (object instanceof CDOID) {
            CDOID id = (CDOID)object;
            CDORevision childRevision = cache.getRevision(id, (CDOBranchPoint)view);
            if (childRevision != null) {
                loadedRevisions.add(childRevision);
            } else {
                missingIDs.add(id);
            }
        }
    }

    private static Collection<? extends EStructuralFeature> getChildrenFeatures(InternalCDOObject cdoObject, ItemProviderAdapter provider) throws Exception {
        return (Collection)GET_CHILDREN_FEATURES_METHOD.invoke((Object)provider, cdoObject);
    }

    private static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = c.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static enum ContextState {
        Opening,
        Open,
        Closed;

    }
}

