/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingUnitSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.IMappingConstants;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.db.BatchedStatement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class UnitMappingTable
extends Lifecycle
implements IMappingConstants {
    public static final String UNITS = "CDO_UNITS";
    public static final String UNITS_ELEM = "CDO_ELEM";
    public static final String UNITS_UNIT = "CDO_UNIT";
    private static final String SQL_SELECT_ROOTS = "SELECT DISTINCT CDO_UNIT FROM CDO_UNITS";
    private static final String SQL_INSERT_MAPPINGS = "INSERT INTO CDO_UNITS (CDO_ELEM, CDO_UNIT) VALUES (?, ?)";
    private static final String SQL_SELECT_CLASSES = "SELECT CDO_CLASS, COUNT(CDO_ELEM) FROM CDO_UNITS, " + CDODBSchema.CDO_OBJECTS + " WHERE " + "CDO_ELEM" + "=" + "CDO_ID" + " AND " + "CDO_UNIT" + "=? GROUP BY " + "CDO_CLASS";
    private static final int WRITE_UNIT_MAPPING_BATCH_SIZE = 100000;
    private final IMappingStrategy mappingStrategy;
    private IDBTable table;

    public UnitMappingTable(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public List<CDOID> readUnitRoots(IDBStoreAccessor accessor) {
        ArrayList<CDOID> rootIDs = new ArrayList<CDOID>();
        IIDHandler idHandler = this.mappingStrategy.getStore().getIDHandler();
        Statement stmt = null;
        try {
            try {
                stmt = accessor.getDBConnection().createStatement();
                if (DBUtil.isTracerEnabled()) {
                    DBUtil.trace((String)stmt.toString());
                }
                ResultSet resultSet = stmt.executeQuery(SQL_SELECT_ROOTS);
                while (resultSet.next()) {
                    CDOID rootID = idHandler.getCDOID(resultSet, 1);
                    rootIDs.add(rootID);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
        return rootIDs;
    }

    public void readUnitRevisions(IDBStoreAccessor accessor, IView view, CDOID rootID, CDORevisionHandler revisionHandler, OMMonitor monitor) {
        IDBStore store = this.mappingStrategy.getStore();
        IIDHandler idHandler = store.getIDHandler();
        IMetaDataManager metaDataManager = store.getMetaDataManager();
        long timeStamp = view.isHistorical() ? view.getTimeStamp() : store.getRepository().getTimeStamp();
        CDOBranchPoint branchPoint = view.getBranch().getPoint(timeStamp);
        IDBConnection connection = accessor.getDBConnection();
        IDBPreparedStatement stmt = connection.prepareStatement(SQL_SELECT_CLASSES, IDBPreparedStatement.ReuseProbability.HIGH);
        int jdbcFetchSize = store.getJDBCFetchSize();
        int oldFetchSize = -1;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, rootID);
                oldFetchSize = stmt.getFetchSize();
                stmt.setFetchSize(jdbcFetchSize);
                IDBResultSet resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    CDOID classID = idHandler.getCDOID((ResultSet)resultSet, 1);
                    EClass eClass = (EClass)metaDataManager.getMetaInstance(classID);
                    IClassMappingUnitSupport classMapping = (IClassMappingUnitSupport)this.mappingStrategy.getClassMapping(eClass);
                    classMapping.readUnitRevisions(accessor, branchPoint, rootID, revisionHandler);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            if (oldFetchSize != -1) {
                try {
                    stmt.setFetchSize(oldFetchSize);
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            DBUtil.close((Statement)stmt);
        }
    }

    public BatchedStatement initUnit(IDBStoreAccessor accessor, long timeStamp, IView view, CDOID rootID, CDORevisionHandler revisionHandler, Set<CDOID> initializedIDs, OMMonitor monitor) {
        IIDHandler idHandler = this.mappingStrategy.getStore().getIDHandler();
        IDBConnection connection = accessor.getDBConnection();
        BatchedStatement stmt = DBUtil.batched((PreparedStatement)connection.prepareStatement(SQL_INSERT_MAPPINGS, IDBPreparedStatement.ReuseProbability.HIGH), (int)100000);
        try {
            CDORevision revision = view.getRevision(rootID);
            this.initUnit(stmt, view, rootID, revisionHandler, initializedIDs, timeStamp, idHandler, revision, monitor);
            return stmt;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    private void initUnit(BatchedStatement stmt, IView view, CDOID rootID, CDORevisionHandler revisionHandler, Set<CDOID> initializedIDs, long timeStamp, IIDHandler idHandler, CDORevision revision, OMMonitor monitor) throws SQLException {
        revisionHandler.handleRevision(revision);
        CDOID id = revision.getID();
        initializedIDs.add(id);
        this.writeUnitMapping(stmt, rootID, timeStamp, idHandler, id);
        List children = CDORevisionUtil.getChildRevisions((CDORevision)revision, (CDORevisionProvider)view, (boolean)true);
        for (CDORevision child : children) {
            this.initUnit(stmt, view, rootID, revisionHandler, initializedIDs, timeStamp, idHandler, child, monitor);
        }
    }

    public void finishUnit(BatchedStatement stmt, CDOID rootID, List<CDOID> ids, long timeStamp) {
        IDBStore store = this.mappingStrategy.getStore();
        IIDHandler idHandler = store.getIDHandler();
        Connection connection = null;
        try {
            try {
                connection = stmt.getConnection();
                for (CDOID id : ids) {
                    this.writeUnitMapping(stmt, rootID, timeStamp, idHandler, id);
                }
            }
            catch (SQLException ex) {
                DBUtil.rollbackSilently((Connection)connection);
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        try {
            connection.commit();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void writeUnitMappings(IDBStoreAccessor accessor, Map<CDOID, CDOID> unitMappings, long timeStamp) {
        IIDHandler idHandler = this.mappingStrategy.getStore().getIDHandler();
        IDBConnection connection = accessor.getDBConnection();
        BatchedStatement stmt = DBUtil.batched((PreparedStatement)connection.prepareStatement(SQL_INSERT_MAPPINGS, IDBPreparedStatement.ReuseProbability.HIGH), (int)100000);
        try {
            try {
                for (Map.Entry<CDOID, CDOID> entry : unitMappings.entrySet()) {
                    CDOID id = entry.getKey();
                    CDOID rootID = entry.getValue();
                    this.writeUnitMapping(stmt, rootID, timeStamp, idHandler, id);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void writeUnitMapping(BatchedStatement stmt, CDOID rootID, long timeStamp, IIDHandler idHandler, CDOID id) throws SQLException {
        idHandler.setCDOID((PreparedStatement)stmt, 1, id);
        idHandler.setCDOID((PreparedStatement)stmt, 2, rootID);
        stmt.executeUpdate();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IDBStore store = this.mappingStrategy.getStore();
        final DBType idType = store.getIDHandler().getDBType();
        final int idLength = store.getIDColumnLength();
        IDBDatabase database = store.getDatabase();
        this.table = database.getSchema().getTable(UNITS);
        if (this.table == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    UnitMappingTable.this.table = schema.addTable(UnitMappingTable.UNITS);
                    UnitMappingTable.this.table.addField(UnitMappingTable.UNITS_ELEM, idType, idLength, true);
                    UnitMappingTable.this.table.addField(UnitMappingTable.UNITS_UNIT, idType, idLength);
                    UnitMappingTable.this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{UnitMappingTable.UNITS_ELEM});
                    UnitMappingTable.this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{UnitMappingTable.UNITS_UNIT});
                }
            });
        }
    }

    protected void doDeactivate() throws Exception {
        this.table = null;
        super.doDeactivate();
    }
}

