/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.common.util.PartialCollectionLoadingNotSupportedException;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOUndoDetector;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.object.CDOLegacyWrapper;
import org.eclipse.emf.internal.cdo.object.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.view.CDOEvent;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.fsm.FiniteStateMachine;
import org.eclipse.net4j.util.fsm.ITransition;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOStateMachine
extends FiniteStateMachine<CDOState, CDOEvent, InternalCDOObject> {
    public static final CDOStateMachine INSTANCE = new CDOStateMachine();
    static final ThreadLocal<Boolean> SWITCHING_TARGET = new InheritableThreadLocal<Boolean>();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_STATEMACHINE, CDOStateMachine.class);
    private static final Field NATIVE_VIEW_AND_STATE_FIELD = ReflectUtil.getField(CDOObjectImpl.class, (String)"viewAndState");
    private static final Field LEGACY_VIEW_AND_STATE_FIELD = ReflectUtil.getField(CDOLegacyWrapper.class, (String)"viewAndState");
    private InternalCDOObject lastTracedObject;
    private CDOState lastTracedState;
    private CDOEvent lastTracedEvent;

    private CDOStateMachine() {
        super(CDOState.class, CDOEvent.class);
        this.init(CDOState.TRANSIENT, CDOEvent.PREPARE, new PrepareTransition());
        this.init(CDOState.TRANSIENT, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.DETACH, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.REATTACH, new ReattachTransition());
        this.init(CDOState.TRANSIENT, CDOEvent.READ, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.ATTACH, new AttachTransition());
        this.init(CDOState.PREPARED, CDOEvent.DETACH, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.READ, IGNORE);
        this.init(CDOState.PREPARED, CDOEvent.WRITE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.DETACH_REMOTE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.NEW, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.NEW, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.NEW, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.NEW, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.NEW, CDOEvent.READ, IGNORE);
        this.init(CDOState.NEW, CDOEvent.WRITE, new WriteNewTransition());
        this.init(CDOState.NEW, CDOEvent.INVALIDATE, DetachRemoteTransition.INSTANCE);
        this.init(CDOState.NEW, CDOEvent.DETACH_REMOTE, FAIL);
        this.init(CDOState.NEW, CDOEvent.COMMIT, new CommitTransition(false));
        this.init(CDOState.NEW, CDOEvent.ROLLBACK, new RollbackTransition());
        this.init(CDOState.CLEAN, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.CLEAN, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.READ, IGNORE);
        this.init(CDOState.CLEAN, CDOEvent.WRITE, new WriteTransition(false));
        this.init(CDOState.CLEAN, CDOEvent.INVALIDATE, new InvalidateTransition(null, null));
        this.init(CDOState.CLEAN, CDOEvent.DETACH_REMOTE, DetachRemoteTransition.INSTANCE);
        this.init(CDOState.CLEAN, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.DIRTY, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.READ, IGNORE);
        this.init(CDOState.DIRTY, CDOEvent.WRITE, new RewriteTransition());
        this.init(CDOState.DIRTY, CDOEvent.INVALIDATE, new ConflictTransition(null, null));
        this.init(CDOState.DIRTY, CDOEvent.DETACH_REMOTE, new InvalidConflictTransition());
        this.init(CDOState.DIRTY, CDOEvent.COMMIT, new CommitTransition(true));
        this.init(CDOState.DIRTY, CDOEvent.ROLLBACK, new RollbackTransition());
        this.init(CDOState.PROXY, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.PROXY, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.PROXY, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.PROXY, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.PROXY, CDOEvent.READ, new LoadTransition());
        this.init(CDOState.PROXY, CDOEvent.WRITE, new WriteTransition(true));
        this.init(CDOState.PROXY, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.PROXY, CDOEvent.DETACH_REMOTE, DetachRemoteTransition.INSTANCE);
        this.init(CDOState.PROXY, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.PROXY, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.ATTACH, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.CONFLICT, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.READ, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.WRITE, new RewriteTransition());
        this.init(CDOState.CONFLICT, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.COMMIT, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.ROLLBACK, new RollbackTransition());
        this.init(CDOState.INVALID, CDOEvent.PREPARE, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.ATTACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.DETACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.INVALID, CDOEvent.READ, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.WRITE, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.INVALID, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.INVALID, CDOEvent.COMMIT, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID, CDOEvent.ROLLBACK, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.PREPARE, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.ATTACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.DETACH, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.REATTACH, FAIL);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.READ, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.DETACH_REMOTE, IGNORE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.COMMIT, InvalidTransition.INSTANCE);
        this.init(CDOState.INVALID_CONFLICT, CDOEvent.ROLLBACK, DetachRemoteTransition.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(InternalCDOObject object, InternalCDOTransaction transaction) {
        Object object2 = transaction.getViewMonitor();
        synchronized (object2) {
            transaction.lockView();
            try {
                object.cdoInternalPreAttach();
                ArrayList contents = new ArrayList();
                this.prepare(object, (Pair<InternalCDOTransaction, List<InternalCDOObject>>)Pair.create((Object)transaction, contents));
                this.attachOrReattach(object, transaction);
                for (InternalCDOObject content : contents) {
                    this.attachOrReattach(content, transaction);
                }
            }
            finally {
                transaction.unlockView();
            }
        }
    }

    private void attachOrReattach(InternalCDOObject object, InternalCDOTransaction transaction) {
        if (transaction.getCleanRevisions().containsKey(object)) {
            this.reattachObject(object, transaction);
        } else {
            this.attachObject(object);
        }
    }

    private void prepare(InternalCDOObject object, Pair<InternalCDOTransaction, List<InternalCDOObject>> transactionAndContents) {
        if (TRACER.isEnabled()) {
            TRACER.format("PREPARE: {0} --> {1}", new Object[]{object, transactionAndContents.getElement1()});
        }
        this.process(object, CDOEvent.PREPARE, transactionAndContents);
    }

    private void attachObject(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("ATTACH: {0}", new Object[]{object});
        }
        this.process(object, CDOEvent.ATTACH, null);
    }

    private void reattachObject(InternalCDOObject object, InternalCDOTransaction transaction) {
        if (TRACER.isEnabled()) {
            TRACER.format("REATTACH: {0}", new Object[]{object});
        }
        this.process(object, CDOEvent.REATTACH, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(InternalCDOObject object) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Lock lock = this.getLock(object);
            if (lock != null) {
                lock.lock();
            }
            try {
                if (TRACER.isEnabled()) {
                    this.trace(object, CDOEvent.DETACH);
                }
                ArrayList objectsToDetach = new ArrayList();
                InternalCDOTransaction transaction = (InternalCDOTransaction)object.cdoView();
                this.process(object, CDOEvent.DETACH, objectsToDetach);
                for (InternalCDOObject content : objectsToDetach) {
                    CDOState oldState = this.setStateQuietely(content, CDOState.TRANSIENT);
                    content.cdoInternalPostDetach(false);
                    this.setStateQuietely(content, oldState);
                }
                for (InternalCDOObject content : objectsToDetach) {
                    transaction.detachObject(content);
                    content.cdoInternalSetState(CDOState.TRANSIENT);
                    content.cdoInternalSetView(null);
                    content.cdoInternalSetID(null);
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public InternalCDORevision read(InternalCDOObject object) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            InternalCDORevision internalCDORevision;
            block9: {
                Lock lock = this.getLock(object);
                if (lock != null) {
                    lock.lock();
                }
                try {
                    if (TRACER.isEnabled()) {
                        this.trace(object, CDOEvent.READ);
                    }
                    this.process(object, CDOEvent.READ, null);
                    internalCDORevision = object.cdoRevision();
                    if (lock == null) break block9;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.unlock();
                    }
                    throw throwable;
                }
            }
            return internalCDORevision;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalCDORevision readNoLoad(InternalCDOObject object) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Lock lock = this.getLock(object);
            if (lock != null) {
                lock.lock();
            }
            try {
                switch (object.cdoState()) {
                    case TRANSIENT: 
                    case NEW: 
                    case PROXY: 
                    case CONFLICT: 
                    case INVALID: 
                    case INVALID_CONFLICT: 
                    case PREPARED: {
                        return null;
                    }
                }
                InternalCDORevision internalCDORevision = object.cdoRevision();
                return internalCDORevision;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public Object write(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Object object3;
            block8: {
                Lock lock = this.getLock(object);
                if (lock != null) {
                    lock.lock();
                }
                try {
                    object3 = this.writeUnsynced(object, featureDelta);
                    if (lock == null) break block8;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.unlock();
                    }
                    throw throwable;
                }
            }
            return object3;
        }
    }

    public Object writeUnsynced(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.WRITE);
        }
        FeatureDeltaAndResult featureDeltaAndResult = new FeatureDeltaAndResult(featureDelta);
        this.process(object, CDOEvent.WRITE, featureDeltaAndResult);
        return featureDeltaAndResult.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(InternalCDOObject ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        Object object = this.getMonitor(objects[0]);
        synchronized (object) {
            Lock lock = this.getLock(objects[0]);
            if (lock != null) {
                lock.lock();
            }
            try {
                InternalCDOObject[] internalCDOObjectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalCDOObject object2 = internalCDOObjectArray[n2];
                    CDOState state = object2.cdoState();
                    if (state == CDOState.CLEAN || state == CDOState.PROXY) {
                        this.changeState(object2, CDOState.PROXY);
                        object2.cdoInternalSetRevision(null);
                        this.read(object2);
                    }
                    ++n2;
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(InternalCDOObject object, CDORevisionKey key) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Lock lock = this.getLock(object);
            if (lock != null) {
                lock.lock();
            }
            try {
                if (TRACER.isEnabled()) {
                    this.trace(object, CDOEvent.INVALIDATE);
                }
                this.process(object, CDOEvent.INVALIDATE, key);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachRemote(InternalCDOObject object) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Lock lock = this.getLock(object);
            if (lock != null) {
                lock.lock();
            }
            try {
                if (TRACER.isEnabled()) {
                    this.trace(object, CDOEvent.DETACH_REMOTE);
                }
                this.process(object, CDOEvent.DETACH_REMOTE, null);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public void commit(Map<CDOID, CDOObject> objects, CDOSessionProtocol.CommitTransactionResult result) {
        for (CDOObject object : objects.values()) {
            this.commitObject((InternalCDOObject)object, result);
        }
        for (CDOObject object : objects.values()) {
            this.changeState((InternalCDOObject)object, CDOState.CLEAN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitObject(InternalCDOObject object, CDOSessionProtocol.CommitTransactionResult result) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Lock lock = this.getLock(object);
            if (lock != null) {
                lock.lock();
            }
            try {
                if (TRACER.isEnabled()) {
                    this.trace(object, CDOEvent.COMMIT);
                }
                this.process(object, CDOEvent.COMMIT, result);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(InternalCDOObject object, InternalCDOTransaction transaction) {
        Object object2 = this.getMonitor(object);
        synchronized (object2) {
            Lock lock = this.getLock(object);
            if (lock != null) {
                lock.lock();
            }
            try {
                if (TRACER.isEnabled()) {
                    this.trace(object, CDOEvent.ROLLBACK);
                }
                this.process(object, CDOEvent.ROLLBACK, transaction);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    protected CDOState getState(InternalCDOObject object) {
        return object.cdoState();
    }

    protected void setState(InternalCDOObject object, CDOState state) {
        object.cdoInternalSetState(state);
    }

    private CDOState setStateQuietely(InternalCDOObject object, CDOState state) {
        Field viewAndStateField;
        if (object instanceof CDOObjectImpl) {
            viewAndStateField = NATIVE_VIEW_AND_STATE_FIELD;
        } else if (object instanceof CDOLegacyWrapper) {
            viewAndStateField = LEGACY_VIEW_AND_STATE_FIELD;
        } else {
            return object.cdoInternalSetState(state);
        }
        try {
            InternalCDOView.ViewAndState viewAndState = (InternalCDOView.ViewAndState)viewAndStateField.get(object);
            CDOState oldState = viewAndState.state;
            ReflectUtil.setValue((Field)viewAndStateField, (Object)object, (Object)viewAndState.getViewAndState(state));
            return oldState;
        }
        catch (Exception ex) {
            return object.cdoInternalSetState(state);
        }
    }

    private Lock getLock(InternalCDOObject object) {
        InternalCDOView view = object.cdoView();
        if (view != null) {
            return view.getViewLock();
        }
        return null;
    }

    private Object getMonitor(InternalCDOObject object) {
        InternalCDOView view = object.cdoView();
        if (view != null) {
            return view.getViewMonitor();
        }
        return object;
    }

    private void trace(InternalCDOObject object, CDOEvent event) {
        CDOState state = object.cdoState();
        if (this.lastTracedObject != object || this.lastTracedState != state || this.lastTracedEvent != event) {
            TRACER.format("{0}: {1}", new Object[]{event, object.getClass().getName()});
            this.lastTracedObject = object;
            this.lastTracedState = state;
            this.lastTracedEvent = event;
        }
    }

    private void testAttach(InternalCDOObject object) {
        this.process(object, CDOEvent.ATTACH, null);
    }

    public void internalReattach(InternalCDOObject object, InternalCDOTransaction transaction) {
        InternalCDORevisionManager revisionManager = transaction.getSession().getRevisionManager();
        Map<InternalCDOObject, InternalCDORevision> cleanRevisions = transaction.getCleanRevisions();
        InternalCDORevision cleanRevision = cleanRevisions.get(object).copy();
        CDOID id = cleanRevision.getID();
        InternalCDOSavepoint savepoint = transaction.getFirstSavepoint();
        while (savepoint.getNextSavepoint() != null) {
            CDORevisionDelta delta = savepoint.getRevisionDeltas2().get(id);
            if (delta != null) {
                delta.applyTo((CDORevision)cleanRevision);
            }
            savepoint = savepoint.getNextSavepoint();
        }
        object.cdoInternalSetView(transaction);
        CDORevisionFactory factory = revisionManager.getFactory();
        InternalCDORevision revision = (InternalCDORevision)factory.createRevision(object.eClass());
        revision.setID(id);
        revision.setBranchPoint(cleanRevision.getBranch().getHead());
        revision.setVersion(cleanRevision.getVersion());
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalPostAttach();
        InternalCDORevisionDelta revisionDelta = revision.compare((CDORevision)cleanRevision);
        if (revisionDelta.isEmpty()) {
            this.changeState(object, CDOState.CLEAN);
            cleanRevisions.remove(object);
        } else {
            revisionDelta.setTarget(null);
            transaction.registerRevisionDelta((CDORevisionDelta)revisionDelta);
            transaction.registerDirty(object, null);
            this.changeState(object, CDOState.DIRTY);
        }
        InternalCDOSavepoint lastSavepoint = transaction.getLastSavepoint();
        lastSavepoint.getReattachedObjects().put(id, object);
    }

    public void dispatchLoadNotification(InternalCDOObject object) {
        block4: {
            InternalCDOView view = object.cdoView();
            if (view.options().isLoadNotificationEnabled()) {
                try {
                    InternalCDORevision revision = object.cdoRevision();
                    CDONotificationBuilder builder = new CDONotificationBuilder(view);
                    NotificationChain notification = builder.buildNotification(object, revision);
                    if (notification != null) {
                        notification.dispatch();
                    }
                }
                catch (PartialCollectionLoadingNotSupportedException ex) {
                    if (!TRACER.isEnabled()) break block4;
                    TRACER.trace((Throwable)ex);
                }
            }
        }
    }

    private void internalLoad(InternalCDOObject object, boolean forWrite) {
        object.cdoInternalPreLoad();
        InternalCDOView view = object.cdoView();
        InternalCDORevision revision = view.getRevision(object.cdoID(), true);
        if (revision == null) {
            INSTANCE.detachRemote(object);
            CDOInvalidationPolicy policy = view.options().getInvalidationPolicy();
            policy.handleInvalidObject(object);
        }
        if (forWrite && !revision.isWritable()) {
            throw new NoPermissionException((Object)revision);
        }
        object.cdoInternalSetRevision((CDORevision)revision);
        this.changeState(object, CDOState.CLEAN);
        object.cdoInternalPostLoad();
        this.dispatchLoadNotification(object);
    }

    private static abstract class AbstractWriteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, FeatureDeltaAndResult> {
        private AbstractWriteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, FeatureDeltaAndResult featureDeltaAndResult) {
            InternalCDORevision revision = object.cdoRevision();
            if (!revision.isWritable()) {
                throw new NoPermissionException((Object)revision);
            }
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            CDOFeatureDelta featureDelta = featureDeltaAndResult.getFeatureDelta();
            Object result = this.execute(object, transaction, featureDelta, revision);
            featureDeltaAndResult.setResult(result);
        }

        protected abstract Object execute(InternalCDOObject var1, InternalCDOTransaction var2, CDOFeatureDelta var3, InternalCDORevision var4);
    }

    private final class AttachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private AttachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            object.cdoInternalPostAttach();
            Map<CDOID, CDORevision> attachedRevisions = ((InternalCDOTransaction)object.cdoView()).options().getAttachedRevisionsMap();
            if (attachedRevisions != null) {
                InternalCDORevision revision = object.cdoRevision().copy();
                attachedRevisions.put(revision.getID(), (CDORevision)revision);
            }
            CDOStateMachine.this.changeState(object, CDOState.NEW);
        }
    }

    private final class CommitTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, CDOSessionProtocol.CommitTransactionResult> {
        public CommitTransition(boolean useDeltas) {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, CDOSessionProtocol.CommitTransactionResult data) {
            CDOID oldID;
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            InternalCDORevision revision = object.cdoRevision();
            Map<CDOID, CDOID> idMappings = data.getIDMappings();
            CDOID newID = idMappings.get(oldID = object.cdoID());
            if (newID != null) {
                revision.setID(newID);
                transaction.remapObject(oldID);
            }
            revision.adjustForCommit(transaction.getBranch(), data.getTimeStamp());
            revision.adjustReferences(data.getReferenceAdjuster());
            revision.freeze();
            InternalCDORevisionManager revisionManager = transaction.getSession().getRevisionManager();
            revisionManager.addRevision((CDORevision)revision);
        }
    }

    private class ConflictTransition
    extends InvalidateTransition {
        private ConflictTransition() {
        }

        @Override
        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, CDORevisionKey key) {
            InternalCDORevision oldRevision = object.cdoRevision();
            if (key == null || key.getVersion() >= oldRevision.getVersion() - 1) {
                CDOStateMachine.this.changeState(object, CDOState.CONFLICT);
                InternalCDOTransaction transaction = object.cdoView().toTransaction();
                transaction.setConflict(object);
            }
        }

        /* synthetic */ ConflictTransition(ConflictTransition conflictTransition, ConflictTransition conflictTransition2) {
            this();
        }
    }

    private static class DetachRemoteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        static final DetachRemoteTransition INSTANCE = new DetachRemoteTransition();

        private DetachRemoteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            INSTANCE.changeState(object, CDOState.INVALID);
            InternalCDOView view = object.cdoView();
            view.deregisterObject(object);
            object.cdoInternalPostDetach(true);
        }
    }

    private static final class DetachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, List<InternalCDOObject>> {
        private DetachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, List<InternalCDOObject> objectsToDetach) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)object.cdoView();
            objectsToDetach.add(object);
            boolean isResource = object instanceof Resource;
            for (InternalEObject eObject : object.eContents()) {
                InternalCDOObject content;
                boolean isDirectlyConnected;
                boolean bl = isDirectlyConnected = isResource && eObject.eDirectResource() == object;
                if (!isDirectlyConnected && eObject.eDirectResource() != null || (content = FSMUtil.adapt(eObject, transaction)) == null) continue;
                INSTANCE.process(content, CDOEvent.DETACH, objectsToDetach);
            }
        }
    }

    public static final class FeatureDeltaAndResult {
        private final CDOFeatureDelta featureDelta;
        private Object result;

        public FeatureDeltaAndResult(CDOFeatureDelta featureDelta) {
            this.featureDelta = featureDelta;
        }

        public CDOFeatureDelta getFeatureDelta() {
            return this.featureDelta;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }
    }

    private final class InvalidConflictTransition
    extends ConflictTransition {
        private InvalidConflictTransition() {
        }

        @Override
        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, CDORevisionKey UNUSED) {
            CDOStateMachine.this.changeState(object, CDOState.INVALID_CONFLICT);
            InternalCDOTransaction transaction = object.cdoView().toTransaction();
            transaction.setConflict(object);
        }
    }

    private static final class InvalidTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        public static final InvalidTransition INSTANCE = new InvalidTransition();

        private InvalidTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            InternalCDOView view = object.cdoView();
            CDOInvalidationPolicy policy = view.options().getInvalidationPolicy();
            policy.handleInvalidObject(object);
        }
    }

    private class InvalidateTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, CDORevisionKey> {
        private InvalidateTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, CDORevisionKey key) {
            InternalCDORevision oldRevision = object.cdoRevision();
            InternalCDOView view = object.cdoView();
            InternalCDOSession session = view.getSession();
            InternalCDORevisionCache cache = session.getRevisionManager().getCache();
            if (SWITCHING_TARGET.get() == Boolean.TRUE) {
                CDORevisionDelta delta = (CDORevisionDelta)key;
                CDORevisable target = delta.getTarget();
                InternalCDORevision newRevision = (InternalCDORevision)cache.getRevisionByVersion(delta.getID(), (CDOBranchVersion)target);
                if (newRevision == null) {
                    newRevision = oldRevision.copy();
                    session.resolveAllElementProxies((CDORevision)newRevision);
                    delta.applyTo((CDORevision)newRevision);
                    newRevision.setBranchPoint((CDOBranchPoint)target);
                    newRevision.setVersion(target.getVersion());
                    newRevision.setRevised(target.getRevised());
                    cache.addRevision((CDORevision)newRevision);
                }
                object.cdoInternalSetRevision((CDORevision)newRevision);
                CDOStateMachine.this.changeState(object, CDOState.CLEAN);
                object.cdoInternalPostLoad();
                return;
            }
            if (key == null || key.getVersion() >= oldRevision.getVersion()) {
                InternalCDORevision newRevision = null;
                CDOBranch viewBranch = view.getBranch();
                CDOBranchVersion newBranchVersion = this.getNewBranchVersion(key, viewBranch);
                if (newBranchVersion != null) {
                    newRevision = (InternalCDORevision)cache.getRevisionByVersion(key.getID(), newBranchVersion);
                }
                if (newRevision != null) {
                    object.cdoInternalSetRevision((CDORevision)newRevision);
                    CDOStateMachine.this.changeState(object, CDOState.CLEAN);
                    object.cdoInternalPostLoad();
                } else {
                    CDOStateMachine.this.changeState(object, CDOState.PROXY);
                    CDOInvalidationPolicy policy = view.options().getInvalidationPolicy();
                    policy.handleInvalidation(object, key);
                    object.cdoInternalPostInvalidate();
                }
            }
        }

        private CDOBranchVersion getNewBranchVersion(CDORevisionKey key, CDOBranch viewBranch) {
            if (key != null) {
                CDORevisionDelta delta;
                CDORevisable target;
                CDOBranch keyBranch = key.getBranch();
                if (key instanceof CDORevisionDelta && (target = (delta = (CDORevisionDelta)key).getTarget()) != null && keyBranch == target.getBranch()) {
                    return target;
                }
                if (keyBranch == viewBranch) {
                    return keyBranch.getVersion(key.getVersion() + 1);
                }
                return viewBranch.getVersion(1);
            }
            return null;
        }

        /* synthetic */ InvalidateTransition(InvalidateTransition invalidateTransition, InvalidateTransition invalidateTransition2) {
            this();
        }
    }

    private final class LoadTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private LoadTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object UNUSED) {
            CDOStateMachine.this.internalLoad(object, false);
        }
    }

    private final class PrepareTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Pair<InternalCDOTransaction, List<InternalCDOObject>>> {
        private PrepareTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Pair<InternalCDOTransaction, List<InternalCDOObject>> transactionAndContents) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)transactionAndContents.getElement1();
            List contents = (List)transactionAndContents.getElement2();
            boolean reattaching = transaction.getCleanRevisions().containsKey(object);
            if (!reattaching) {
                CDOID id = transaction.createIDForNewObject((EObject)object.cdoInternalInstance());
                object.cdoInternalSetView(transaction);
                CDOStateMachine.this.changeState(object, CDOState.PREPARED);
                EClass eClass = object.eClass();
                CDOSession session = transaction.getSession();
                this.checkPackageRegistrationProblems((InternalCDOSession)session, eClass);
                CDORevisionFactory factory = session.getRevisionManager().getFactory();
                InternalCDORevision revision = (InternalCDORevision)factory.createRevision(eClass);
                revision.setID(id);
                revision.setBranchPoint(transaction.getBranch().getHead());
                object.cdoInternalSetRevision((CDORevision)revision);
                transaction.registerObject(object);
            }
            transaction.registerAttached(object, !reattaching);
            Iterator<InternalEObject> it = this.getPersistentContents(object);
            while (it.hasNext()) {
                boolean objectIsResource;
                InternalEObject content = it.next();
                Resource.Internal directResource = content.eDirectResource();
                boolean bl = objectIsResource = directResource == object;
                if (!objectIsResource && directResource != null) continue;
                InternalCDOObject adapted = FSMUtil.adapt(content, transaction);
                contents.add(adapted);
                INSTANCE.process(adapted, CDOEvent.PREPARE, transactionAndContents);
            }
        }

        private Iterator<InternalEObject> getPersistentContents(InternalCDOObject object) {
            EStructuralFeature[] features = object.cdoClassInfo().getAllPersistentContainments();
            return new EContentsEList.ResolvingFeatureIteratorImpl((EObject)object, features);
        }

        private void checkPackageRegistrationProblems(InternalCDOSession session, EClass eClass) {
            if (session.options().isGeneratedPackageEmulationEnabled()) {
                String packageURI = eClass.getEPackage().getNsURI();
                Object packageObject = session.getPackageRegistry().get((Object)packageURI);
                if (packageObject instanceof InternalCDOPackageInfo) {
                    packageObject = ((InternalCDOPackageInfo)packageObject).getEPackage(false);
                }
                if (packageObject instanceof EPackage && packageObject != eClass.getEPackage()) {
                    throw new IllegalStateException(MessageFormat.format("Global EPackage {0} for EClass {1} is different from EPackage found in CDOPackageRegistry", packageURI, eClass));
                }
            }
        }
    }

    private final class ReattachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, InternalCDOTransaction> {
        private ReattachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, InternalCDOTransaction transaction) {
            CDOStateMachine.this.internalReattach(object, transaction);
            CDOID reattachedObject = object.cdoID();
            this.processRevisionDeltas(reattachedObject, transaction);
        }

        private void processRevisionDeltas(CDOID reattachedObject, InternalCDOTransaction transaction) {
            Map<InternalCDOObject, InternalCDORevision> cleanRevisions = transaction.getCleanRevisions();
            InternalCDOSavepoint lastSavepoint = transaction.getLastSavepoint();
            Map<CDOID, CDORevisionDelta> revisionDeltas = lastSavepoint.getRevisionDeltas2();
            Iterator<Map.Entry<CDOID, CDORevisionDelta>> it = revisionDeltas.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CDOID, CDORevisionDelta> entry = it.next();
                CDORevisionDelta revisionDelta = entry.getValue();
                Map map = ((InternalCDORevisionDelta)revisionDelta).getFeatureDeltaMap();
                this.processFeatureDeltas(reattachedObject, map);
                if (!revisionDelta.isEmpty()) continue;
                it.remove();
                CDOID id = revisionDelta.getID();
                InternalCDOObject cleanObject = (InternalCDOObject)lastSavepoint.getDirtyObjects().remove(id);
                if (cleanObject == null) continue;
                cleanObject.cdoInternalSetState(CDOState.CLEAN);
                cleanRevisions.remove(cleanObject);
            }
            if (revisionDeltas.isEmpty()) {
                transaction.setDirty(false);
            }
        }

        private void processFeatureDeltas(CDOID reattachedObject, Map<EStructuralFeature, CDOFeatureDelta> map) {
            Iterator<Map.Entry<EStructuralFeature, CDOFeatureDelta>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<EStructuralFeature, CDOFeatureDelta> entry = it.next();
                CDOFeatureDelta featureDelta = entry.getValue();
                this.processFeatureDelta(reattachedObject, it, featureDelta);
            }
        }

        private void processFeatureDelta(CDOID reattachedObject, Iterator<?> it, CDOFeatureDelta featureDelta) {
            switch (featureDelta.getType()) {
                case SET: {
                    Object newValue;
                    CDOSetFeatureDelta setFeatureDelta = (CDOSetFeatureDelta)featureDelta;
                    Object oldValue = setFeatureDelta.getOldValue();
                    if (oldValue instanceof EObject) {
                        oldValue = CDOUtil.getCDOObject((EObject)oldValue).cdoID();
                    }
                    if ((newValue = setFeatureDelta.getValue()) instanceof EObject) {
                        newValue = CDOUtil.getCDOObject((EObject)newValue).cdoID();
                    }
                    if (reattachedObject != oldValue || reattachedObject != newValue) break;
                    it.remove();
                    break;
                }
                case LIST: {
                    CDOListFeatureDelta listFeatureDelta = (CDOListFeatureDelta)featureDelta;
                    List listChanges = listFeatureDelta.getListChanges();
                    Iterator listIt = listChanges.iterator();
                    while (listIt.hasNext()) {
                        CDOFeatureDelta singleFeatureDelta = (CDOFeatureDelta)listIt.next();
                        this.processFeatureDelta(reattachedObject, listIt, singleFeatureDelta);
                    }
                    if (!listChanges.isEmpty()) break;
                    it.remove();
                }
            }
        }
    }

    private final class RewriteTransition
    extends AbstractWriteTransition {
        private RewriteTransition() {
        }

        @Override
        protected Object execute(InternalCDOObject object, InternalCDOTransaction transaction, CDOFeatureDelta featureDelta, InternalCDORevision revision) {
            Map<InternalCDOObject, InternalCDORevision> cleanRevisions = transaction.getCleanRevisions();
            InternalCDORevision cleanRevision = cleanRevisions.get(object);
            Object result = null;
            if (featureDelta != null) {
                CDOUndoDetector undoDetector;
                result = featureDelta.applyTo((CDORevision)revision);
                if (!transaction.hasMultipleSavepoints() && (undoDetector = transaction.options().getUndoDetector()).detectUndo(transaction, (CDORevision)cleanRevision, (CDORevision)revision, featureDelta)) {
                    CDOID id = revision.getID();
                    InternalCDOSavepoint lastSavepoint = transaction.getLastSavepoint();
                    Map<CDOID, CDORevisionDelta> revisionDeltas = lastSavepoint.getRevisionDeltas2();
                    InternalCDORevisionDelta revisionDelta = (InternalCDORevisionDelta)revisionDeltas.get(id);
                    if (revisionDelta != null) {
                        Map featureDeltas = revisionDelta.getFeatureDeltaMap();
                        featureDeltas.remove(featureDelta.getFeature());
                        if (featureDeltas.isEmpty()) {
                            cleanRevisions.remove(object);
                            revisionDeltas.remove(id);
                            lastSavepoint.getDirtyObjects().remove(id);
                            if (lastSavepoint.getReattachedObjects().remove(id) != null) {
                                lastSavepoint.getDetachedObjects().remove(id);
                            }
                            object.cdoInternalSetRevision((CDORevision)cleanRevision);
                            CDOStateMachine.this.changeState(object, CDOState.CLEAN);
                        }
                    }
                    if (revisionDeltas.isEmpty()) {
                        transaction.setDirty(false);
                    }
                    CDOTransactionHandler1[] handlers = transaction.getTransactionHandlers1();
                    int i = 0;
                    while (i < handlers.length) {
                        CDOTransactionHandler1 handler = handlers[i];
                        if (handler instanceof CDOTransactionHandler1.WithUndo) {
                            CDOTransactionHandler1.WithUndo withUndo = (CDOTransactionHandler1.WithUndo)handler;
                            withUndo.undoingObject(transaction, object, featureDelta);
                        }
                        ++i;
                    }
                    return result;
                }
            }
            transaction.registerFeatureDelta(object, featureDelta, cleanRevision);
            return result;
        }
    }

    private final class RollbackTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, InternalCDOTransaction> {
        private RollbackTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, InternalCDOTransaction transaction) {
            CDOID id = object.cdoID();
            if (transaction.getLastSavepoint().isNewObject(id)) {
                CDOState oldState = CDOStateMachine.this.setStateQuietely(object, CDOState.TRANSIENT);
                object.cdoInternalPostDetach(false);
                CDOStateMachine.this.setStateQuietely(object, oldState);
                CDOStateMachine.this.changeState(object, CDOState.TRANSIENT);
            } else {
                CDOStateMachine.this.changeState(object, CDOState.PROXY);
                object.cdoInternalPostRollback();
            }
            object.cdoInternalSetRevision(null);
        }
    }

    private final class WriteNewTransition
    extends AbstractWriteTransition {
        private WriteNewTransition() {
        }

        @Override
        protected Object execute(InternalCDOObject object, InternalCDOTransaction transaction, CDOFeatureDelta featureDelta, InternalCDORevision revision) {
            Object result = null;
            if (featureDelta != null) {
                result = featureDelta.applyTo((CDORevision)revision);
            }
            transaction.registerFeatureDelta(object, featureDelta);
            return result;
        }
    }

    private final class WriteTransition
    extends AbstractWriteTransition {
        private boolean load;

        public WriteTransition(boolean load) {
            this.load = load;
        }

        @Override
        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, FeatureDeltaAndResult featureDeltaAndResult) {
            if (this.load) {
                CDOStateMachine.this.internalLoad(object, true);
            }
            super.execute(object, state, event, featureDeltaAndResult);
        }

        @Override
        protected Object execute(InternalCDOObject object, InternalCDOTransaction transaction, CDOFeatureDelta featureDelta, InternalCDORevision cleanRevision) {
            InternalCDORevision revision = cleanRevision.copy();
            Object result = null;
            if (featureDelta != null) {
                CDOUndoDetector undoDetector;
                result = featureDelta.applyTo((CDORevision)revision);
                if (!transaction.hasMultipleSavepoints() && (undoDetector = transaction.options().getUndoDetector()).detectUndo(transaction, (CDORevision)cleanRevision, (CDORevision)revision, featureDelta)) {
                    return null;
                }
            }
            transaction.getCleanRevisions().put(object, cleanRevision);
            object.cdoInternalSetRevision((CDORevision)revision);
            transaction.registerDirty(object, featureDelta, cleanRevision);
            CDOStateMachine.this.changeState(object, CDOState.DIRTY);
            return result;
        }
    }
}

