/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.launching.QVTcLaunchConstants;
import org.eclipse.qvtd.debug.ui.launching.MainTab;
import org.eclipse.qvtd.debug.ui.launching.ParameterRow;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;

public abstract class DirectionalMainTab
extends MainTab
implements QVTcLaunchConstants {
    @Override
    protected void addListeners() {
        super.addListeners();
        this.directionCombo.addModifyListener((ModifyListener)new MainTab.DirectionModifyListener(this));
    }

    @Override
    protected void initializeInternal(@NonNull ILaunchConfiguration configuration) throws CoreException {
        super.initializeInternal(configuration);
        ArrayList<String> directions = new ArrayList<String>();
        if (this.outputsGroup != null) {
            Control[] controlArray = this.outputsGroup.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof ParameterRow) {
                    directions.add(((ParameterRow)child).name.getText());
                }
                ++n2;
            }
        }
        Collections.sort(directions);
        this.directionCombo.setItems(directions.toArray(new String[directions.size()]));
        this.directionCombo.setText(configuration.getAttribute("direction", "NONE"));
        this.modeCombo.setText(configuration.getAttribute("mode", "CHECK"));
        this.partialCheckButton.setSelection(configuration.getAttribute("partial", false));
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("direction", this.directionCombo.getText());
        configuration.setAttribute("mode", this.modeCombo.getText());
        configuration.setAttribute("partial", this.partialCheckButton.getSelection());
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("direction", "NONE");
        configuration.setAttribute("mode", "CHECK");
        configuration.setAttribute("partial", false);
    }

    protected void setDirections(@NonNull Set<TypedModel> enforceables) {
        if (this.directionCombo.isDisposed()) {
            return;
        }
        String oldText = this.directionCombo.getText();
        Object[] directionItems = new String[enforceables.size()];
        int newIndex = -1;
        int i = 0;
        for (TypedModel typedModel : enforceables) {
            String name = typedModel.getName();
            if (ClassUtil.safeEquals((Object)name, (Object)oldText)) {
                newIndex = i;
            }
            directionItems[i++] = name;
        }
        Arrays.sort(directionItems);
        this.directionCombo.setItems((String[])directionItems);
        this.directionCombo.select(newIndex >= 0 ? newIndex : 0);
    }

    @Override
    protected void updateDirection(@NonNull Transformation transformation) {
        HashSet<TypedModel> enforceables = new HashSet<TypedModel>();
        for (Rule rule : transformation.getRule()) {
            for (Domain domain : rule.getDomain()) {
                TypedModel typedModel = domain.getTypedModel();
                if (!domain.isIsEnforceable()) continue;
                enforceables.add(typedModel);
            }
        }
        this.setDirections(enforceables);
    }
}

