/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TimingAnalysisLaunchMainTab
extends AbstractLaunchConfigurationTab
implements TimingAnalysisLaunchAttributes {
    private DataBindingContext m_bindingContext;
    private final SelectionListener checkbox_selection_listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
        }
    };
    private Text textModelIFile;
    private Text textSettingIFile;
    private Button btnExportJson;
    private Button btnPaperscript;
    private Button btnExportMotionPlots;
    private Text textExportMotionPlotsFilter;
    private Text textMotionPlotsSampleFrequency;
    private Text textStochasticSampleLength;
    private Group grpGanttType;
    private Button btnGantt;
    private Button btnCriticalPathGantt;
    private Button btnNoGantt;
    private Button btnRemoveClaimReleaseDependencies;
    private Button btnStochasticImpact;
    private Button btnProductTracing;

    public String getName() {
        return "Timing Analysis";
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout();
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1808));
        this.textModelIFile = this.createFileDialog(container, "Activity Dispatching", "dispatching");
        this.textSettingIFile = this.createFileDialog(container, "Physical settings file", "setting");
        this.grpGanttType = new Group(container, 0);
        this.grpGanttType.setLayout((Layout)new GridLayout(1, false));
        this.grpGanttType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpGanttType.setText("Show");
        this.btnNoGantt = new Button((Composite)this.grpGanttType, 16);
        this.btnNoGantt.setText("no Gantt chart");
        this.btnNoGantt.addSelectionListener(this.checkbox_selection_listener);
        this.btnGantt = new Button((Composite)this.grpGanttType, 16);
        this.btnGantt.addSelectionListener(this.checkbox_selection_listener);
        this.btnGantt.setText("Gantt chart");
        this.btnCriticalPathGantt = new Button((Composite)this.grpGanttType, 16);
        this.btnCriticalPathGantt.setText("Gantt chart with critical path");
        this.btnCriticalPathGantt.addSelectionListener(this.checkbox_selection_listener);
        this.btnStochasticImpact = new Button((Composite)this.grpGanttType, 16);
        this.btnStochasticImpact.setText("Gantt chart using stochastic impact analysis");
        this.btnStochasticImpact.addSelectionListener(this.checkbox_selection_listener);
        Composite grpStochastic = new Composite((Composite)this.grpGanttType, 0);
        grpStochastic.setLayout((Layout)new GridLayout(2, false));
        grpStochastic.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label labelStochasticIterations = new Label(grpStochastic, 0);
        labelStochasticIterations.setText("Stochastic iterations: ");
        this.textStochasticSampleLength = new Text(grpStochastic, 4);
        this.textStochasticSampleLength.addVerifyListener((VerifyListener)new IntegerValidator());
        this.textStochasticSampleLength.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textStochasticSampleLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
            }
        });
        Group grpOptions = new Group(container, 0);
        grpOptions.setLayout((Layout)new GridLayout(1, false));
        grpOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpOptions.setText("Options");
        this.btnExportJson = new Button((Composite)grpOptions, 32);
        this.btnExportJson.setText("Export to JSON");
        this.btnExportJson.addSelectionListener(this.checkbox_selection_listener);
        this.btnPaperscript = new Button((Composite)grpOptions, 32);
        this.btnPaperscript.setText("Show web animation");
        this.btnPaperscript.addSelectionListener(this.checkbox_selection_listener);
        this.btnRemoveClaimReleaseDependencies = new Button((Composite)grpOptions, 32);
        this.btnRemoveClaimReleaseDependencies.setText("Remove dependencies for claims and releases");
        this.btnRemoveClaimReleaseDependencies.addSelectionListener(this.checkbox_selection_listener);
        this.btnProductTracing = new Button((Composite)grpOptions, 32);
        this.btnProductTracing.setText("Enable product tracing");
        this.btnProductTracing.addSelectionListener(this.checkbox_selection_listener);
        Group grpMotionPlots = new Group(container, 0);
        grpMotionPlots.setLayout((Layout)new GridLayout(1, false));
        grpMotionPlots.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpMotionPlots.setText("Motion plots");
        this.btnExportMotionPlots = new Button((Composite)grpMotionPlots, 32);
        this.btnExportMotionPlots.setText("Export motion plots");
        this.btnExportMotionPlots.addSelectionListener(this.checkbox_selection_listener);
        Composite grpFilter = new Composite((Composite)grpMotionPlots, 0);
        grpFilter.setLayout((Layout)new GridLayout(2, false));
        grpFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label labelExportMotionPlotsFilter = new Label(grpFilter, 0);
        labelExportMotionPlotsFilter.setText("Filter: ");
        this.textExportMotionPlotsFilter = new Text(grpFilter, 4);
        this.textExportMotionPlotsFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textExportMotionPlotsFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
            }
        });
        Composite grpFrequency = new Composite((Composite)grpMotionPlots, 0);
        grpFrequency.setLayout((Layout)new GridLayout(2, false));
        grpFrequency.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label labelMotionPlotsSampleFrequency = new Label(grpFrequency, 0);
        labelMotionPlotsSampleFrequency.setText("Sample frequency: ");
        this.textMotionPlotsSampleFrequency = new Text(grpFrequency, 4);
        this.textMotionPlotsSampleFrequency.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textMotionPlotsSampleFrequency.addVerifyListener((VerifyListener)new IntegerValidator());
        this.textMotionPlotsSampleFrequency.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
            }
        });
        this.m_bindingContext = this.initDataBindings();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.textModelIFile.setText(configuration.getAttribute(MODEL_IFILE, ""));
            this.textSettingIFile.setText(configuration.getAttribute(SETTING_IFILE, ""));
            this.btnNoGantt.setSelection(configuration.getAttribute(NO_GANTT_CHART, false));
            this.btnGantt.setSelection(configuration.getAttribute(GANTT_CHART, true));
            this.btnCriticalPathGantt.setSelection(configuration.getAttribute(CRITICAL_PATH, false));
            this.btnStochasticImpact.setSelection(configuration.getAttribute(STOCHASTIC_IMPACT, false));
            this.textStochasticSampleLength.setText(configuration.getAttribute(STOCHASTIC_SAMPLE_LENGTH, "100"));
            this.btnExportJson.setSelection(configuration.getAttribute(EXPORT_JSON, false));
            this.btnPaperscript.setSelection(configuration.getAttribute(PAPERSCRIPT_ANIMATION, false));
            this.btnExportMotionPlots.setSelection(configuration.getAttribute(EXPORT_MOTIONPLOTS, false));
            this.textExportMotionPlotsFilter.setText(configuration.getAttribute(EXPORT_MOTIONPLOTS_FILTER, ""));
            this.textMotionPlotsSampleFrequency.setText(configuration.getAttribute(MOTIONPLOTS_SAMPLE_FREQUENCY, "1000"));
            this.btnRemoveClaimReleaseDependencies.setSelection(configuration.getAttribute(REMOVE_CLAIMS_RELEASES_DEPENDENCIES, false));
            this.btnProductTracing.setSelection(configuration.getAttribute(PRODUCT_TRACE, true));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IFile settingIFile;
        IFile modelIFile = TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile);
        ArrayList<IFile> mappedResources = new ArrayList<IFile>();
        if (modelIFile != null) {
            configuration.setAttribute(MODEL_IFILE, modelIFile.getFullPath().toString());
            mappedResources.add(modelIFile);
        }
        if ((settingIFile = TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile)) != null) {
            configuration.setAttribute(SETTING_IFILE, settingIFile.getFullPath().toString());
            mappedResources.add(settingIFile);
        }
        configuration.setMappedResources(mappedResources.toArray(new IResource[mappedResources.size()]));
        configuration.setAttribute(INTERACTIVE_TIMINGANALYSIS, true);
        configuration.setAttribute(NO_GANTT_CHART, this.btnNoGantt.getSelection());
        configuration.setAttribute(GANTT_CHART, this.btnGantt.getSelection());
        configuration.setAttribute(CRITICAL_PATH, this.btnCriticalPathGantt.getSelection());
        configuration.setAttribute(STOCHASTIC_IMPACT, this.btnStochasticImpact.getSelection());
        configuration.setAttribute(STOCHASTIC_SAMPLE_LENGTH, this.textStochasticSampleLength.getText());
        configuration.setAttribute(EXPORT_JSON, this.btnExportJson.getSelection());
        configuration.setAttribute(PAPERSCRIPT_ANIMATION, this.btnPaperscript.getSelection());
        configuration.setAttribute(EXPORT_MOTIONPLOTS, this.btnExportMotionPlots.getSelection());
        configuration.setAttribute(EXPORT_MOTIONPLOTS_FILTER, this.textExportMotionPlotsFilter.getText());
        configuration.setAttribute(MOTIONPLOTS_SAMPLE_FREQUENCY, this.textMotionPlotsSampleFrequency.getText());
        configuration.setAttribute(REMOVE_CLAIMS_RELEASES_DEPENDENCIES, this.btnRemoveClaimReleaseDependencies.getSelection());
        configuration.setAttribute(PRODUCT_TRACE, this.btnProductTracing.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile) == null) {
            this.setErrorMessage("Please select an existing activity dispatching file");
            return false;
        }
        if (TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile) == null) {
            this.setWarningMessage("Physical settings file not selected. The project default will be used");
            return true;
        }
        String preferredName = this.getPreferredName();
        ArrayList<String> possibleNames = new ArrayList<String>(Arrays.asList(this.getPreferredName(TimingAnalysisLaunchAttributes.GANTT_CHART), this.getPreferredName(TimingAnalysisLaunchAttributes.CRITICAL_PATH), this.getPreferredName(TimingAnalysisLaunchAttributes.STOCHASTIC_IMPACT), this.getPreferredName(TimingAnalysisLaunchAttributes.NO_GANTT_CHART)));
        possibleNames.remove(this.getPreferredName());
        if (possibleNames.contains(launchConfig.getName())) {
            this.setWarningMessage("Reserved name, consider change to: " + preferredName);
            return true;
        }
        return true;
    }

    private Text createFileDialog(Composite container, String title, final String fileExtension) {
        Group grpActivityDispatching = new Group(container, 0);
        grpActivityDispatching.setLayout((Layout)new GridLayout(2, false));
        grpActivityDispatching.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpActivityDispatching.setText(title);
        final Text textField = new Text((Composite)grpActivityDispatching, 2048);
        textField.setEditable(false);
        textField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseMdl = new Button((Composite)grpActivityDispatching, 0);
        btnBrowseMdl.setText("Browse...");
        btnBrowseMdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile iFile = TimingAnalysisLaunchMainTab.this.selectFile(fileExtension, textField);
                if (iFile != null) {
                    textField.setText(iFile.getFullPath().toString());
                    TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
                }
            }
        });
        return textField;
    }

    private String getPreferredName(String showTargetName) {
        return TimingAnalysisUtil.getLaunchName(TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile), TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile), showTargetName);
    }

    private String getPreferredName() {
        if (this.btnPaperscript.getSelection() || this.btnRemoveClaimReleaseDependencies.getSelection()) {
            return null;
        }
        return TimingAnalysisUtil.getLaunchName(TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile), TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile), this.getSelectedShow());
    }

    private String getSelectedShow() {
        if (this.btnGantt.getSelection()) {
            return GANTT_CHART;
        }
        if (this.btnCriticalPathGantt.getSelection()) {
            return CRITICAL_PATH;
        }
        if (this.btnStochasticImpact.getSelection()) {
            return STOCHASTIC_IMPACT;
        }
        return NO_GANTT_CHART;
    }

    private IFile selectFile(final String fileExtension, Text field) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select " + fileExtension + " file");
        dialog.setMessage("Select " + fileExtension + " file to execute scheduling");
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return Objects.equals(((IFile)element).getFileExtension(), fileExtension);
                }
                return element instanceof IContainer;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.timinganalysis.ui", 0, "Please select a " + fileExtension + " file!", null);
                }
                return new Status(0, "org.eclipse.lsat.timinganalysis.ui", 0, "OK", null);
            }
        });
        IFile selectedFile = TimingAnalysisLaunchMainTab.getSelectedIFile(field);
        if (selectedFile != null) {
            dialog.setInitialSelection((Object)selectedFile);
        }
        dialog.open();
        return (IFile)dialog.getFirstResult();
    }

    private static IFile getSelectedIFile(Text textField) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path modelIPath = new Path(textField.getText());
        if (!modelIPath.isEmpty() && wsRoot.exists((IPath)modelIPath)) {
            return wsRoot.getFile((IPath)modelIPath);
        }
        return null;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }

    private static class IntegerValidator
    implements VerifyListener {
        private IntegerValidator() {
        }

        public void verifyText(VerifyEvent e) {
            if (e.widget instanceof Text) {
                Text textField = (Text)e.widget;
                if (e.character == '\b' || e.character == '\u007f') {
                    return;
                }
                String oldText = textField.getText();
                String newText = oldText.substring(0, e.start) + e.text + oldText.substring(e.end);
                if (newText.isEmpty()) {
                    return;
                }
                try {
                    Integer.parseInt(newText);
                }
                catch (NumberFormatException ex) {
                    e.doit = false;
                }
            }
        }
    }
}

