/**
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.machine.teditor.scoping

import machine.Peripheral
import machine.PeripheralType
import machine.SymbolicPosition
import machine.impl.AxisPositionMapEntryImpl
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it 
 *
 */
class MachineScopeProvider extends AbstractDeclarativeScopeProvider {
//    If you want to log the queried scoping rules, just enable this error handler
//    new() {
//        errorHandler = new PolymorphicDispatcher.ErrorHandler<IScope> {
//            override handle(Object[] params, Throwable throwable) {
//                System.err.println(throwable.message)
//                return null
//            }
//        }
//    }
    
    def IScope scope_SetPoint(PeripheralType peripheralType, EReference ref) {
        return Scopes.scopeFor(peripheralType.setPoints)
    }

    def IScope scope_Profile(Peripheral peripheral, EReference ref) {
        return Scopes.scopeFor(peripheral.profiles)
    }

    def IScope scope_SymbolicPosition(Peripheral peripheral, EReference ref) {
        return Scopes.scopeFor(peripheral.positions)
    }

    def IScope scope_Axis(Peripheral peripheral, EReference ref) {
        if (null === peripheral.type) {
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(peripheral.type.axes)
    }
    
    def IScope scope_AxisPositionMapEntry_value(AxisPositionMapEntryImpl entry, EReference ref) {
        if (null === entry.key || !(entry.eContainer instanceof SymbolicPosition) || !(entry.eContainer.eContainer instanceof Peripheral)) {
            return IScope.NULLSCOPE
        }
        val peripheral = entry.eContainer.eContainer as Peripheral
        if (!peripheral.axisPositions.containsKey(entry.key)) {
            return IScope.NULLSCOPE
        }
        return Scopes.scopeFor(peripheral.axisPositions.get(entry.key))
    }
}
