/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.function.Predicate;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.ProcessingIterator;

public class BranchUpToIterator<E>
extends ProcessingIterator<E>
implements BranchIterator<E> {
    private final BranchIterator<? extends E> source;
    private final Predicate<? super E> predicate;
    private final boolean isIncluding;
    private boolean canPrune = false;
    private boolean isSourcePruned = false;

    public BranchUpToIterator(BranchIterator<E> source, Predicate<? super E> predicate, boolean isIncluding) {
        this.source = source;
        this.predicate = predicate;
        this.isIncluding = isIncluding;
    }

    @Override
    protected boolean toNext() {
        while (this.source.hasNext()) {
            Object next = this.source.next();
            this.isSourcePruned = false;
            if (this.predicate.test(next)) {
                this.source.prune();
                this.isSourcePruned = true;
                if (!this.isIncluding) continue;
                return this.setNext(next);
            }
            return this.setNext(next);
        }
        return this.done();
    }

    @Override
    public boolean hasNext() {
        this.canPrune = false;
        return super.hasNext();
    }

    @Override
    public E next() {
        this.canPrune = true;
        return super.next();
    }

    @Override
    public void prune() {
        if (this.canPrune) {
            if (!this.isSourcePruned) {
                this.source.prune();
                this.isSourcePruned = true;
            }
        } else {
            throw new IllegalStateException("Prune is not allowed");
        }
        this.canPrune = false;
    }
}

