/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.LinkedEditingRangesRequest;
import org.eclipse.lemminx.services.extensions.ILinkedEditingRangesParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLLinkedEditing {
    private static final String WORD_PATTERN = "[^\\s>]+";
    private static Logger LOGGER = Logger.getLogger(XMLLinkedEditing.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLLinkedEditing(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public LinkedEditingRanges findLinkedEditingRanges(DOMDocument document, Position position, CancelChecker cancelChecker) {
        try {
            int offset;
            DOMElement element;
            cancelChecker.checkCanceled();
            LinkedEditingRangesRequest request = new LinkedEditingRangesRequest(document, position, this.extensionsRegistry);
            DOMNode node = request.getNode();
            if (node == null) {
                return null;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (ILinkedEditingRangesParticipant participant : this.extensionsRegistry.getLinkedEditingRangesParticipants()) {
                try {
                    participant.findLinkedEditingRanges(request, ranges, cancelChecker);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while processing linked editing ranges for the participant '" + participant.getClass().getName() + "'.", e);
                }
            }
            if (node.isElement() && !(element = (DOMElement)node).isOrphanEndTag() && element.hasEndTag() && (element.isInStartTag(offset = request.getOffset()) || element.isInEndTag(offset, true))) {
                ranges.addAll(Arrays.asList(XMLPositionUtility.selectStartTagName(element), XMLPositionUtility.selectEndTagName(element)));
            }
            cancelChecker.checkCanceled();
            return !ranges.isEmpty() ? new LinkedEditingRanges(ranges, WORD_PATTERN) : null;
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In XMLLinkedEditing, position error", e);
            return null;
        }
    }
}

