/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.status.wifi;

import java.util.Objects;
import java.util.Optional;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class WifiChannel {
    private final int channel;
    private final int frequency;
    private final Optional<Boolean> disabled;
    private final Optional<Float> attenuation;
    private final Optional<Boolean> noInitiatingRadiation;
    private final Optional<Boolean> radarDetection;

    private WifiChannel(Builder builder) {
        this.channel = builder.channel;
        this.frequency = builder.frequency;
        this.disabled = builder.disabled;
        this.attenuation = builder.attenuation;
        this.noInitiatingRadiation = builder.noInitiatingRadiation;
        this.radarDetection = builder.radarDetection;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public Optional<Float> getAttenuation() {
        return this.attenuation;
    }

    public Optional<Boolean> getNoInitiatingRadiation() {
        return this.noInitiatingRadiation;
    }

    public Optional<Boolean> getRadarDetection() {
        return this.radarDetection;
    }

    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public int hashCode() {
        return Objects.hash(this.attenuation, this.channel, this.disabled, this.frequency, this.noInitiatingRadiation, this.radarDetection);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WifiChannel other = (WifiChannel)obj;
        return Objects.equals(this.attenuation, other.attenuation) && this.channel == other.channel && Objects.equals(this.disabled, other.disabled) && this.frequency == other.frequency && Objects.equals(this.noInitiatingRadiation, other.noInitiatingRadiation) && Objects.equals(this.radarDetection, other.radarDetection);
    }

    public static Builder builder(int channel, int frequency) {
        return new Builder(channel, frequency);
    }

    /* synthetic */ WifiChannel(Builder builder, WifiChannel wifiChannel) {
        this(builder);
    }

    public static final class Builder {
        private int channel;
        private int frequency;
        private Optional<Boolean> disabled = Optional.empty();
        private Optional<Float> attenuation = Optional.empty();
        private Optional<Boolean> noInitiatingRadiation = Optional.empty();
        private Optional<Boolean> radarDetection = Optional.empty();

        private Builder(int channel, int frequency) {
            this.channel = channel;
            this.frequency = frequency;
        }

        public Builder withChannel(int channel) {
            this.channel = channel;
            return this;
        }

        public Builder withFrequency(int frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder withDisabled(boolean disabled) {
            this.disabled = Optional.of(disabled);
            return this;
        }

        public Builder withAttenuation(float attenuation) {
            this.attenuation = Optional.of(Float.valueOf(attenuation));
            return this;
        }

        public Builder withNoInitiatingRadiation(boolean noInitiatingRadiation) {
            this.noInitiatingRadiation = Optional.of(noInitiatingRadiation);
            return this;
        }

        public Builder withRadarDetection(boolean radarDetection) {
            this.radarDetection = Optional.of(radarDetection);
            return this;
        }

        public WifiChannel build() {
            return new WifiChannel(this, null);
        }
    }
}

