/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.component;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.camel.component.AbstractCamelComponent;
import org.eclipse.kura.camel.component.Configuration;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlCamelComponent
extends AbstractCamelComponent
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractXmlCamelComponent.class);
    private final String xmlDataProperty;

    public AbstractXmlCamelComponent(String xmlDataProperty) {
        Objects.requireNonNull(xmlDataProperty);
        this.xmlDataProperty = xmlDataProperty;
    }

    protected void activate(BundleContext context, Map<String, Object> properties) throws Exception {
        try {
            this.start(properties);
            this.applyRoutes(properties);
        }
        catch (Exception e) {
            logger.warn("Problem activating component", (Throwable)e);
        }
    }

    protected void deactivate(BundleContext context) throws Exception {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.warn("Problem deactivating component", (Throwable)e);
            throw e;
        }
    }

    protected void modified(Map<String, Object> properties) throws Exception {
        logger.debug("Updating properties: {}", properties);
        try {
            if (this.isRestartNeeded(properties)) {
                logger.info("Need restart");
                this.stop();
                this.start(properties);
            }
            this.applyRoutes(properties);
        }
        catch (Exception e) {
            logger.warn("Problem updating component", (Throwable)e);
            throw e;
        }
    }

    private void applyRoutes(Map<String, Object> properties) throws Exception {
        this.runner.setRoutes(Configuration.asString(properties, this.xmlDataProperty));
    }

    protected boolean isRestartNeeded(Map<String, Object> properties) {
        return false;
    }
}

