/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.Comparator;
import java.util.List;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.network.NetworkTabsUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.service.GwtNetworkServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Span;

public class NetworkInterfacesTableUi
extends Composite {
    private static NetworkInterfacesTableUiUiBinder uiBinder = (NetworkInterfacesTableUiUiBinder)GWT.create(NetworkInterfacesTableUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final String SELECTED_INTERFACE = "ui.selected.interface";
    private final GwtNetworkServiceAsync gwtNetworkService = (GwtNetworkServiceAsync)GWT.create(GwtNetworkService.class);
    GwtSession session;
    NetworkTabsUi tabs;
    GwtNetInterfaceConfig selection;
    @UiField
    Alert notification;
    @UiField
    CellTable<GwtNetInterfaceConfig> interfacesGrid = new CellTable();
    private final ListDataProvider<GwtNetInterfaceConfig> interfacesProvider = new ListDataProvider();
    final SingleSelectionModel<GwtNetInterfaceConfig> selectionModel = new SingleSelectionModel();
    TextColumn<GwtNetInterfaceConfig> col1;

    public NetworkInterfacesTableUi(GwtSession s, NetworkTabsUi tabsPanel) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.session = s;
        this.tabs = tabsPanel;
        this.initTable();
        this.loadData();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (NetworkInterfacesTableUi.this.selection == NetworkInterfacesTableUi.this.selectionModel.getSelectedObject()) {
                    return;
                }
                if (NetworkInterfacesTableUi.this.selection != null && NetworkInterfacesTableUi.this.tabs.isDirty()) {
                    final Modal confirm = new Modal();
                    ModalBody confirmBody = new ModalBody();
                    ModalFooter confirmFooter = new ModalFooter();
                    confirm.setTitle(MSGS.confirm());
                    confirmBody.add((Widget)new Span(MSGS.deviceConfigDirty()));
                    Button yes = new Button(MSGS.yesButton(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            confirm.hide();
                            (this).NetworkInterfacesTableUi.this.selection = (GwtNetInterfaceConfig)(this).NetworkInterfacesTableUi.this.selectionModel.getSelectedObject();
                            if ((this).NetworkInterfacesTableUi.this.selection != null) {
                                (this).NetworkInterfacesTableUi.this.session.set(NetworkInterfacesTableUi.SELECTED_INTERFACE, (this).NetworkInterfacesTableUi.this.selection.getName());
                                (this).NetworkInterfacesTableUi.this.tabs.setNetInterface((this).NetworkInterfacesTableUi.this.selection);
                                (this).NetworkInterfacesTableUi.this.tabs.setDirty(false);
                            }
                        }
                    });
                    Button no = new Button(MSGS.noButton(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            confirm.hide();
                            (this).NetworkInterfacesTableUi.this.selectionModel.setSelected((Object)(this).NetworkInterfacesTableUi.this.selection, true);
                        }
                    });
                    confirmFooter.add((Widget)no);
                    confirmFooter.add((Widget)yes);
                    confirm.add((Widget)confirmBody);
                    confirm.add((Widget)confirmFooter);
                    confirm.show();
                    no.setFocus(true);
                } else {
                    NetworkInterfacesTableUi.this.selection = (GwtNetInterfaceConfig)NetworkInterfacesTableUi.this.selectionModel.getSelectedObject();
                    if (NetworkInterfacesTableUi.this.selection != null) {
                        NetworkInterfacesTableUi.this.session.set(NetworkInterfacesTableUi.SELECTED_INTERFACE, NetworkInterfacesTableUi.this.selection.getName());
                        NetworkInterfacesTableUi.this.tabs.setNetInterface(NetworkInterfacesTableUi.this.selection);
                    }
                }
            }
        });
    }

    public void refresh() {
        if (this.selection != null && this.tabs.isDirty()) {
            final Modal confirm = new Modal();
            ModalBody confirmBody = new ModalBody();
            ModalFooter confirmFooter = new ModalFooter();
            confirm.setTitle(MSGS.confirm());
            confirmBody.add((Widget)new Span(MSGS.deviceConfigDirty()));
            confirmFooter.add((Widget)new Button(MSGS.yesButton(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    confirm.hide();
                    NetworkInterfacesTableUi.this.tabs.setDirty(false);
                    NetworkInterfacesTableUi.this.loadData();
                }
            }));
            confirmFooter.add((Widget)new Button(MSGS.noButton(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    confirm.hide();
                }
            }));
            confirm.add((Widget)confirmBody);
            confirm.add((Widget)confirmFooter);
            confirm.show();
        } else {
            this.tabs.setDirty(false);
            this.loadData();
        }
    }

    private void initTable() {
        this.col1 = new TextColumn<GwtNetInterfaceConfig>(){

            public String getValue(GwtNetInterfaceConfig object) {
                return object.getName();
            }
        };
        this.col1.setCellStyleNames("status-table-row");
        this.col1.setSortable(true);
        this.interfacesGrid.addColumn(this.col1, MSGS.netInterfaceName());
        this.interfacesProvider.addDataDisplay(this.interfacesGrid);
        this.interfacesGrid.setSelectionModel(this.selectionModel);
        this.interfacesGrid.getColumnSortList().push(this.col1);
    }

    private void loadData() {
        EntryClassUi.showWaitModal();
        this.interfacesProvider.getList().clear();
        this.gwtNetworkService.findNetInterfaceConfigurations(new AsyncCallback<List<GwtNetInterfaceConfig>>(){

            public void onFailure(Throwable caught) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(caught);
            }

            public void onSuccess(List<GwtNetInterfaceConfig> result) {
                ColumnSortEvent.ListHandler columnSortHandler = new ColumnSortEvent.ListHandler(NetworkInterfacesTableUi.this.interfacesProvider.getList());
                columnSortHandler.setComparator(NetworkInterfacesTableUi.this.col1, (Comparator)new Comparator<GwtNetInterfaceConfig>(){

                    @Override
                    public int compare(GwtNetInterfaceConfig o1, GwtNetInterfaceConfig o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        if (o1 != null) {
                            return o2 != null ? NetworkInterfacesTableUi.this.compareFromName(o1.getName(), o2.getName()) : 1;
                        }
                        return -1;
                    }
                });
                NetworkInterfacesTableUi.this.interfacesGrid.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
                NetworkInterfacesTableUi.this.interfacesProvider.getList().addAll(result);
                ColumnSortEvent.fire(NetworkInterfacesTableUi.this.interfacesGrid, (ColumnSortList)NetworkInterfacesTableUi.this.interfacesGrid.getColumnSortList());
                NetworkInterfacesTableUi.this.interfacesProvider.flush();
                if (!NetworkInterfacesTableUi.this.interfacesProvider.getList().isEmpty()) {
                    NetworkInterfacesTableUi.this.interfacesGrid.setVisible(true);
                    NetworkInterfacesTableUi.this.notification.setVisible(false);
                    String sessionSelection = (String)NetworkInterfacesTableUi.this.session.get(NetworkInterfacesTableUi.SELECTED_INTERFACE);
                    if (sessionSelection != null) {
                        for (GwtNetInterfaceConfig gc : NetworkInterfacesTableUi.this.interfacesProvider.getList()) {
                            if (!gc.getName().equals(sessionSelection)) continue;
                            NetworkInterfacesTableUi.this.selectionModel.setSelected((Object)gc, true);
                            break;
                        }
                    } else {
                        NetworkInterfacesTableUi.this.selectionModel.setSelected((Object)((GwtNetInterfaceConfig)NetworkInterfacesTableUi.this.interfacesProvider.getList().get(0)), true);
                    }
                } else {
                    NetworkInterfacesTableUi.this.interfacesGrid.setVisible(false);
                    NetworkInterfacesTableUi.this.notification.setVisible(true);
                    NetworkInterfacesTableUi.this.notification.setText(MSGS.netTableNoInterfaces());
                }
                EntryClassUi.hideWaitModal();
            }
        });
    }

    private int compareFromName(String name1, String name2) {
        int result = 1;
        if (name1.equals(name2)) {
            result = 0;
        }
        if ("lo".equals(name1)) {
            result = -1;
        }
        if (name1.startsWith("eth") && !"lo".equals(name2)) {
            result = name2.startsWith("eth") ? name1.compareTo(name2) : -1;
        }
        if (name1.startsWith("wlan") && !name2.startsWith("lo") && !name2.startsWith("eth")) {
            result = name2.startsWith("wlan") ? name1.compareTo(name2) : -1;
        }
        if (name1.startsWith("ppp") && !name2.startsWith("wlan") && !name2.startsWith("lo") && !name2.startsWith("eth")) {
            result = name2.startsWith("ppp") ? name1.compareTo(name2) : -1;
        }
        return result;
    }

    static interface NetworkInterfacesTableUiUiBinder
    extends UiBinder<Widget, NetworkInterfacesTableUi> {
    }
}

