/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.components.AbstractGraphPlacer;
import org.eclipse.elk.alg.layered.components.ComponentGroupGraphPlacer;
import org.eclipse.elk.alg.layered.components.ComponentGroupModelOrderGraphPlacer;
import org.eclipse.elk.alg.layered.components.ComponentOrderingStrategy;
import org.eclipse.elk.alg.layered.components.ModelOrderRowGraphPlacer;
import org.eclipse.elk.alg.layered.components.SimpleRowGraphPlacer;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.Spacing;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public final class ComponentsProcessor {
    private final ComponentGroupGraphPlacer componentGroupGraphPlacer = new ComponentGroupGraphPlacer();
    private final ComponentGroupModelOrderGraphPlacer componentGroupModelOrderGraphPlacer = new ComponentGroupModelOrderGraphPlacer();
    private final ModelOrderRowGraphPlacer modelOrderRowGraphPlacer = new ModelOrderRowGraphPlacer();
    private final SimpleRowGraphPlacer simpleRowGraphPlacer = new SimpleRowGraphPlacer();
    private AbstractGraphPlacer graphPlacer;

    public List<LGraph> split(LGraph graph) {
        ArrayList result;
        boolean compatiblePortConstraints;
        this.graphPlacer = this.simpleRowGraphPlacer;
        Boolean separateProperty = (Boolean)graph.getProperty(LayeredOptions.SEPARATE_CONNECTED_COMPONENTS);
        boolean separate = separateProperty == null || separateProperty != false;
        boolean extPorts = ((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS);
        PortConstraints extPortConstraints = (PortConstraints)graph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        boolean bl = compatiblePortConstraints = !extPortConstraints.isOrderFixed();
        if (separate && (compatiblePortConstraints || !extPorts)) {
            for (LNode node : graph.getLayerlessNodes()) {
                node.id = 0;
            }
            result = Lists.newArrayList();
            for (LNode node : graph.getLayerlessNodes()) {
                Pair<List<LNode>, Set<PortSide>> componentData = this.dfs(node, null);
                if (componentData == null) continue;
                LGraph newGraph = new LGraph();
                newGraph.copyProperties((IPropertyHolder)graph);
                newGraph.setProperty(InternalProperties.EXT_PORT_CONNECTIONS, (Set)componentData.getSecond());
                newGraph.getPadding().copy((Spacing)graph.getPadding());
                newGraph.setProperty(LayeredOptions.NODE_SIZE_MINIMUM, null);
                for (LNode n : (List)componentData.getFirst()) {
                    newGraph.getLayerlessNodes().add(n);
                    n.setGraph(newGraph);
                }
                result.add(newGraph);
            }
            if (extPorts) {
                this.graphPlacer = graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_COMPONENTS) == ComponentOrderingStrategy.GROUP_MODEL_ORDER ? this.componentGroupModelOrderGraphPlacer : (graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_COMPONENTS) == ComponentOrderingStrategy.MODEL_ORDER ? this.modelOrderRowGraphPlacer : this.componentGroupGraphPlacer);
            }
        } else {
            result = Arrays.asList(graph);
        }
        if (graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_COMPONENTS) != ComponentOrderingStrategy.NONE) {
            Collections.sort(result, (g1, g2) -> {
                int g1Order = LGraphUtil.getMinimalModelOrder(g1);
                int g2Order = LGraphUtil.getMinimalModelOrder(g2);
                return Integer.compare(g1Order, g2Order);
            });
        }
        return result;
    }

    private Pair<List<LNode>, Set<PortSide>> dfs(LNode node, Pair<List<LNode>, Set<PortSide>> data) {
        if (node.id == 0) {
            node.id = 1;
            Pair mutableData = data;
            if (mutableData == null) {
                ArrayList component = Lists.newArrayList();
                EnumSet<PortSide> extPortSides = EnumSet.noneOf(PortSide.class);
                mutableData = new Pair((Object)component, extPortSides);
            }
            ((List)mutableData.getFirst()).add(node);
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                ((Set)mutableData.getSecond()).add((PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE));
            }
            for (LPort port1 : node.getPorts()) {
                for (LPort port2 : port1.getConnectedPorts()) {
                    this.dfs(port2.getNode(), (Pair<List<LNode>, Set<PortSide>>)mutableData);
                }
            }
            return mutableData;
        }
        return null;
    }

    public void combine(List<LGraph> components, LGraph target) {
        this.graphPlacer.combine(components, target);
    }
}

